/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.bean.QueryForm;
import com.xdja.pams.syms.entity.CardRegister;
import com.xdja.pams.syms.service.CardRegisterService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
public class CardRegisterController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(CardRegisterController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    CardRegisterService cardRegisterService;
    @Autowired
    private ResourceBundleMessageSource message;

    @RequestMapping(value={"syms/cardregistercontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"syms/cardregistercontroller/query.do"})
    public void query(QueryForm queryForm, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        ArrayList listmap = new ArrayList();
        Page page = new Page();
        try {
            page.setRp(Integer.parseInt(pageParam.getRows()));
            page.setPage(Integer.parseInt(pageParam.getPage()));
            List<CardRegister> list = this.cardRegisterService.query(queryForm, page);
            for (CardRegister cardRegister : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", cardRegister.getId());
                map.put("cardNumber", cardRegister.getCardNumber());
                map.put("packNO", cardRegister.getPackNO());
                map.put("produceDate", Util.getDate("yyyy-MM-dd", cardRegister.getProduceDate()));
                map.put("unit", cardRegister.getUnit());
                map.put("finalUser", cardRegister.getFinalUser());
                listmap.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/cardregistercontroller/checkCardNumber.do"})
    public void checkCardNumber(String cardNumber, String id, HttpServletResponse response) {
        boolean b = this.cardRegisterService.checkCardNumber(cardNumber, (Serializable)((Object)id));
        Util.writeUtf8Text(response, Boolean.toString(!b));
    }

    @RequestMapping(value={"syms/cardregistercontroller/add.do"})
    public String add(String id, ModelMap map) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            map.put((Object)"id", (Object)id);
        }
        return "syms/cardregister/default/add";
    }

    @RequestMapping(value={"syms/cardregistercontroller/save.do"})
    public void save(CardRegister cardRegister, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        boolean b = this.cardRegisterService.checkCardNumber(cardRegister.getCardNumber(), null);
        if (b) {
            map.put("flag", "0");
            map.put("message", "\u4fdd\u5b58\u5931\u8d25\uff0c\u786c\u4ef6\u7f16\u53f7\u5df2\u5b58\u5728");
            Util.writeUtf8JSON(response, Util.toJsonStr(map));
            return;
        }
        try {
            cardRegister.setEditTime(new Date());
            this.cardRegisterService.save(cardRegister);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/cardregistercontroller/update.do"})
    public void update(CardRegister cardRegister, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            cardRegister.setEditTime(new Date());
            this.cardRegisterService.update(cardRegister);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (BatchUpdateException e) {
            map.put("flag", "0");
            map.put("message", "\u4fdd\u5b58\u5931\u8d25\uff0c\u786c\u4ef6\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        catch (Exception e) {
            Throwable cause;
            int i = 0;
            for (cause = e.getCause(); cause != null && !(cause instanceof BatchUpdateException); cause = cause.getCause()) {
                if (i <= 4) continue;
            }
            if (cause instanceof BatchUpdateException) {
                map.put("flag", "0");
                map.put("message", "\u4fdd\u5b58\u5931\u8d25\uff0c\u786c\u4ef6\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/cardregistercontroller/del.do"})
    public void del(String id, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.cardRegisterService.delete((Serializable)((Object)id));
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/cardregistercontroller/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        CardRegister cardRegister = this.cardRegisterService.get((Serializable)((Object)id));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", cardRegister.getId());
        map.put("cardNumber", cardRegister.getCardNumber());
        map.put("packNO", cardRegister.getPackNO());
        map.put("produceDate", Util.getDate("yyyy-MM-dd", cardRegister.getProduceDate()));
        map.put("unit", cardRegister.getUnit());
        map.put("finalUser", cardRegister.getFinalUser());
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/cardregistercontroller/toImport.do"})
    public String toImpl() {
        return "syms/cardregister/default/import";
    }

    @RequestMapping(value={"syms/cardregistercontroller/import.do"})
    public void impl(@RequestParam MultipartFile file, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        int operateResult = 0;
        try {
            String msg = this.saveImportexcel(file);
            operateResult = 1;
            map.put("flag", "1");
            map.put("message", msg);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text1(response, Util.toJsonStr(map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public String saveImportexcel(MultipartFile file) {
        ArrayList<CardRegister> list = new ArrayList<CardRegister>();
        String[] colsName = new String[]{"\u5361\u5e8f\u5217\u53f7", "\u5916\u5305\u88c5\u6761\u7801", "\u7528\u6237\u5355\u4f4d", "\u6700\u7ec8\u7528\u6237", "\u51fa\u5382\u65e5\u671f"};
        int flag = 0;
        if (file == null) {
            return this.getImportError(4);
        }
        try {
            InputStream in = file.getInputStream();
            if (in != null && in.available() != 0) {
                Workbook workBook = Workbook.getWorkbook((InputStream)in);
                Sheet[] sheetS = workBook.getSheets();
                if (sheetS != null && sheetS.length != 0) {
                    int sheetLen = sheetS.length;
                    for (int i = 0; i < sheetLen; ++i) {
                        Object cell;
                        int rowLens = sheetS[i].getRows();
                        int colLens = sheetS[i].getColumns();
                        if (rowLens == 0) break;
                        if (colLens != colsName.length) {
                            String string = this.getImportError(5);
                            return string;
                        }
                        int beginRow = 1;
                        int beginCol = 0;
                        String cellValue = null;
                        String[] rowArray = null;
                        String[] sqlArray = new String[rowLens];
                        rowArray = new String[colLens - beginCol];
                        for (int col = beginCol; col < colLens; ++col) {
                            cell = sheetS[i].getCell(col, 0);
                            if (cell != null) {
                                cellValue = cell.getContents();
                            }
                            rowArray[col] = cellValue;
                        }
                        for (int m = 0; m < colsName.length; ++m) {
                            if (rowArray[m].equals(colsName[m])) continue;
                            cell = this.getImportError(6);
                            return cell;
                        }
                        if (rowLens - beginRow <= 0 || colLens - beginCol <= 0) continue;
                        for (int row = beginRow; row < rowLens; ++row) {
                            rowArray = new String[colLens - beginCol];
                            for (int col = beginCol; col < colLens; ++col) {
                                Cell cell2 = sheetS[i].getCell(col, row);
                                if (cell2 != null) {
                                    cellValue = CellType.DATE.equals(cell2.getType()) ? this.FormateTime(cell2) : cell2.getContents();
                                }
                                if (cellValue != null) {
                                    cellValue = cellValue.replace(" ", "");
                                }
                                rowArray[col] = cellValue;
                            }
                            CardRegister card = new CardRegister();
                            card.setCardNumber(rowArray[0]);
                            card.setPackNO(rowArray[1]);
                            card.setUnit(rowArray[2]);
                            card.setFinalUser(rowArray[3]);
                            card.setProduceDate(rowArray[4]);
                            card.setEditTime(new Date());
                            list.add(card);
                        }
                    }
                }
                workBook.close();
                in.close();
                for (CardRegister cardRegister : list) {
                    try {
                        this.cardRegisterService.save(cardRegister);
                        ++flag;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String string = this.getImportError(4);
            return string;
        }
        return "\u6210\u529f\u5bfc\u5165" + flag + "\u6761\u6570\u636e\u3002";
    }

    public String getImportError(int errcode) {
        String msg = "";
        switch (errcode) {
            case 0: {
                msg = "\u5bfc\u5165\u6210\u529f";
                break;
            }
            case 1: {
                msg = "\u5411\u6b63\u5f0f\u8868\u4e2d\u63d2\u5165\u4fe1\u606f\u51fa\u9519";
                break;
            }
            case 2: {
                msg = "\u5220\u9664\u4fe1\u606f\u51fa\u9519";
                break;
            }
            case 4: {
                msg = "\u4e0a\u4f20excel\u6587\u4ef6\u51fa\u9519";
                break;
            }
            case 5: {
                msg = "\u60a8\u9009\u62e9\u7684excel\u6587\u4ef6\u5305\u542b\u7684\u5217\u6570\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u5bfc\u5165";
                break;
            }
            case 6: {
                msg = "\u60a8\u9009\u62e9\u7684excel\u6587\u4ef6\u5305\u542b\u7684\u5217\u7684\u540d\u79f0\u6216\u8005\u987a\u5e8f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u5bfc\u5165";
                break;
            }
            case 7: {
                msg = "\u60a8\u9009\u62e9\u7684excel\u6587\u4ef6\u65e0\u5185\u5bb9\uff0c\u8bf7\u6dfb\u52a0\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u5bfc\u5165";
                break;
            }
            case 8: {
                msg = "\u6570\u636e\u5e93\u63d2\u5165\u51fa\u9519";
            }
        }
        return msg;
    }

    public String FormateTime(Cell formatecell) {
        Date mydate = null;
        formatecell.getCellFormat().getFormat();
        DateCell dateCell = (DateCell)formatecell;
        mydate = dateCell.getDate();
        return Util.getDate("yyyy-MM-dd", mydate);
    }

    public CardRegisterService getCardRegisterService() {
        return this.cardRegisterService;
    }

    public void setCardRegisterService(CardRegisterService cardRegisterService) {
        this.cardRegisterService = cardRegisterService;
    }
}

