/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.control;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.entity.LegalIP;
import com.xdja.pams.syms.service.LegalIPService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class LegalIPController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(LegalIPController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private LegalIPService legalIPService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DepManageService depService;

    @RequestMapping(value={"syms/ipconfigcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"syms/ipconfigcontroller/query.do"})
    public void query(LegalIP legalIP, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        ArrayList listmap = new ArrayList();
        Page page = new Page();
        try {
            page.setRp(Integer.parseInt(pageParam.getRows()));
            page.setPage(Integer.parseInt(pageParam.getPage()));
            List<LegalIP> list = this.legalIPService.query(legalIP, page);
            for (LegalIP ip : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", ip.getId());
                map.put("areaname", ip.getAreaname());
                map.put("loginip", ip.getLoginip());
                map.put("name", ip.getName());
                map.put("code", ip.getCode());
                map.put("identifier", ip.getIdentifier());
                map.put("note", ip.getNote());
                map.put("mobile", ip.getMobile());
                if (StringUtils.isNotBlank((CharSequence)ip.getDepid())) {
                    Department dep = this.depService.queryDepById(ip.getDepid());
                    map.put("depname", dep != null ? dep.getName() : "");
                } else {
                    map.put("depname", "");
                }
                listmap.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2IP\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/ipconfigcontroller/add.do"})
    public String add(String id, ModelMap map) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            map.put((Object)"id", (Object)id);
        }
        return "syms/ipconfig/default/add";
    }

    @RequestMapping(value={"syms/ipconfigcontroller/save.do"})
    public void save(LegalIP legalIP, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.legalIPService.save(legalIP);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/ipconfigcontroller/update.do"})
    public void update(LegalIP legalIP, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.legalIPService.update(legalIP);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/ipconfigcontroller/del.do"})
    public void del(String id, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HttpSession session = request.getSession();
        operator = (Operator)session.getAttribute("operator");
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.legalIPService.delete((Serializable)((Object)id));
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            Util.writeUtf8JSON(response, Util.toJsonStr(map));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/ipconfigcontroller/getById.do"})
    public void get(String id, HttpServletResponse response) {
        try {
            LegalIP legalIP = this.legalIPService.get((Serializable)((Object)id));
            HashMap<String, String> mapIP = new HashMap<String, String>();
            HashMap mapdep = new HashMap();
            mapIP.put("id", legalIP.getId());
            mapIP.put("areaname", legalIP.getAreaname());
            mapIP.put("loginip", legalIP.getLoginip());
            mapIP.put("name", legalIP.getName());
            mapIP.put("code", legalIP.getCode());
            mapIP.put("identifier", legalIP.getIdentifier());
            mapIP.put("note", legalIP.getNote());
            mapIP.put("mobile", legalIP.getMobile());
            mapIP.put("depid", legalIP.getDepid());
            String r = Util.toJsonStr(mapIP);
            Util.writeUtf8JSON(response, Util.toJsonStr(mapIP));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"syms/ipconfigcontroller/checkIP.do"})
    public void checkIP(String IP, String id, HttpServletResponse response) {
        boolean flag = this.legalIPService.checkIP(IP, id);
        Util.writeUtf8JSON(response, Boolean.toString(!flag));
    }

    public LegalIPService getLegalIPService() {
        return this.legalIPService;
    }

    public void setLegalIPService(LegalIPService legalIPService) {
        this.legalIPService = legalIPService;
    }
}

