/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.service.impl;

import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.bean.DInfoCA;
import com.xdja.pams.scms.bean.TRInfo;
import com.xdja.pams.scms.dao.DeviceDao;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.dao.SystemConfigDao;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SystemConfigServiceImpl
implements SystemConfigService,
SystemConfigPbService {
    @Autowired
    private SystemConfigDao systemConfigDao;
    @Autowired
    private DeviceDao deviceDao;

    @Override
    public List<SystemConfig> getByType(String type) {
        return this.systemConfigDao.getByType(type);
    }

    @Override
    public String getValueByCode(String code) {
        SystemConfig sys = this.systemConfigDao.getByCode(code);
        if (sys != null) {
            return sys.getValue();
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(SystemConfig systemConfig) {
        if (systemConfig != null) {
            String[] types;
            if ("terminalbindtype".equals(systemConfig.getCode())) {
                this.deviceDao.updateBindStateAll(systemConfig.getValue());
            }
            if ("addPersonDevice".equals(systemConfig.getCode()) && StringUtils.isNotBlank((CharSequence)systemConfig.getValue()) && (types = systemConfig.getValue().split(",")).length > 1) {
                SystemConfig onePersonCards = this.getByCode("cardcount");
                onePersonCards.setValue("many");
                this.systemConfigDao.update(onePersonCards);
            }
            if ("cardcount".equals(systemConfig.getCode())) {
                SystemConfig addPersonDeviceTypes = this.getByCode("addPersonDevice");
                String[] types2 = null;
                String typeStr = addPersonDeviceTypes.getValue();
                if (null != typeStr) {
                    types2 = typeStr.split(",");
                }
                if (types2 != null && types2.length > 1 && "one".equals(systemConfig.getValue())) {
                    throw new RuntimeException("\u6dfb\u52a0\u4eba\u5458\u9ed8\u8ba4\u6dfb\u52a0\u5b89\u5168\u5361\u914d\u7f6e\u4e3a\u591a\u5361\uff0c\u53d1\u5361\u6570\u91cf\u53ea\u80fd\u914d\u7f6e\u4e3a\u4e00\u4eba\u591a\u5361");
                }
            }
        }
        this.systemConfigDao.update(systemConfig);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(String id, String value) {
        SystemConfig systemConfig = this.systemConfigDao.getById(id);
        if (systemConfig != null) {
            systemConfig.setValue(value);
            this.update(systemConfig);
        }
    }

    @Override
    public void updateLogo() {
    }

    public SystemConfigDao getSystemConfigDao() {
        return this.systemConfigDao;
    }

    public void setSystemConfigDao(SystemConfigDao systemConfigDao) {
        this.systemConfigDao = systemConfigDao;
    }

    @Override
    public void save(SystemConfig systemConfig) {
        this.systemConfigDao.save(systemConfig);
    }

    @Override
    public DInfo getDInfo() {
        DInfo dInfo = new DInfo(this.getValueByCode("D_URL"), this.getValueByCode("D_WRITE_CARD_PASSWORD"), this.getValueByCode("D_devCardNo"), this.getValueByCode("D_devPassword"), this.getValueByCode("D_gateCardNo"), this.getValueByCode("D_algType"), this.getValueByCode("D_isSM2"), this.getValueByCode("D_Type"), this.getValueByCode("D_isImsi"), this.getValueByCode("D_getGWCertSwitch"), this.getValueByCode("d_isWritePersonInfo"));
        return dInfo;
    }

    @Override
    public TRInfo getTRInfo() {
        TRInfo trInfo = new TRInfo();
        trInfo.setUrl(this.getValueByCode("tr_tURL"));
        trInfo.setTrSwitch(this.getValueByCode("tr_switch"));
        trInfo.setMmcode(this.getValueByCode("tr_mmpcode"));
        trInfo.setCardName(this.getValueByCode("tr_cardName"));
        trInfo.setCardVersion(this.getValueByCode("tr_cardVersion"));
        return trInfo;
    }

    @Override
    public SystemConfig getByCode(String code) {
        return this.systemConfigDao.getByCode(code);
    }

    @Override
    public SystemConfig getById(String id) {
        return this.systemConfigDao.getById(id);
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    @Override
    public DInfo getDInfoByYYS(String yys, String personType) {
        String yysType = this.getyysType(yys, personType);
        DInfo dInfo = new DInfo(this.getValueByCode("D_URL" + yysType), this.getValueByCode("D_WRITE_CARD_PASSWORD" + yysType), this.getValueByCode("D_devCardNo" + yysType), this.getValueByCode("D_devPassword" + yysType), this.getValueByCode("D_gateCardNo" + yysType), this.getValueByCode("D_algType" + yysType), this.getValueByCode("D_isSM2" + yysType), this.getValueByCode("D_Type" + yysType), this.getValueByCode("D_isImsi" + yysType), this.getValueByCode("D_getGWCertSwitch" + yysType), this.getValueByCode("d_isWritePersonInfo" + yysType));
        dInfo.setUseThirdCert(this.getValueByCode("d_useThirdCert" + yysType));
        dInfo.setIsEmpowerKey(this.getValueByCode("d_isEmpowerKey" + yysType));
        return dInfo;
    }

    @Override
    public DInfoCA getDInfoCAByYYS(String yys, String personType) {
        String yysType = this.getyysType(yys, personType);
        DInfoCA dInfoCA = new DInfoCA(this.getValueByCode("D_URL" + yysType), this.getValueByCode("D_WRITE_CARD_PASSWORD" + yysType), this.getValueByCode("D_devCardNo" + yysType), this.getValueByCode("D_devPassword" + yysType), this.getValueByCode("D_gateCardNo" + yysType), this.getValueByCode("D_algType" + yysType), this.getValueByCode("D_isSM2" + yysType), this.getValueByCode("D_Type" + yysType), this.getValueByCode("D_isImsi" + yysType), this.getValueByCode("D_getGWCertSwitch" + yysType), this.getValueByCode("d_isWritePersonInfo" + yysType), this.getValueByCode("D_isUseSimple_CA") + yysType);
        dInfoCA.setUseThirdCert(this.getValueByCode("d_useThirdCert" + yysType));
        dInfoCA.setIsEmpowerKey(this.getValueByCode("d_isEmpowerKey" + yysType));
        dInfoCA.setIsUserSingleCert(this.getValueByCode("D_isUseSingle_cert" + yysType));
        dInfoCA.setIsNeedVerify(this.getValueByCode("D_isNeedVeryfi_cert" + yysType));
        String days = this.getValueByCode("D_validityBeforeLimitDays" + yysType);
        dInfoCA.setValidityBeforeLimitDays(Strings.isEmpty(days) ? -1 : Integer.parseInt(days));
        return dInfoCA;
    }

    protected String getyysType(String yys, String personType) {
        String yysType = "";
        if ("2".equals(yys)) {
            yysType = "_LT";
        }
        if ("3".equals(yys)) {
            yysType = "_DX";
        }
        if ("2".equals(personType)) {
            yysType = yysType + "_FJ";
        }
        return yysType;
    }

    @Override
    public DInfo getDInfoThird() {
        DInfo dInfo = new DInfo(this.getValueByCode("D_URL_THIRD"), this.getValueByCode("D_devCardNo_THIRD"), this.getValueByCode("D_devPassword_THIRD"));
        return dInfo;
    }
}

