/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syn.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syn.bean.MDPPersonRoleBean;
import com.xdja.pams.syn.bean.QueryParamPoliceAndMDP;
import com.xdja.pams.syn.dao.PoliceAndMDPDao;
import com.xdja.pams.syn.entity.MDPAndPolice;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PoliceAndMDPDaoImpl
implements PoliceAndMDPDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<MDPAndPolice> querySynMDPPersonList(QueryParamPoliceAndMDP param, Page page) {
        StringBuffer sb = new StringBuffer("from MDPAndPolice where 1 = 1");
        ArrayList<String> list = new ArrayList<String>();
        if (param != null) {
            if (StringUtils.isNotBlank((CharSequence)param.getId())) {
                sb.append(" and id = ?");
                list.add(param.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getDepId())) {
                sb.append(" and depId = ?");
                list.add(param.getDepId());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getName())) {
                sb.append(" and name like ?");
                list.add("%" + param.getName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)param.getNameOrCodeOrIdentifier())) {
                sb.append(" and (name like ? or code like ? or identifier like ?)");
                list.add("%" + param.getNameOrCodeOrIdentifier() + "%");
                list.add("%" + param.getNameOrCodeOrIdentifier() + "%");
                list.add("%" + param.getNameOrCodeOrIdentifier() + "%");
            }
            if (param.getPersonType() != null && param.getPersonType().length() > 0) {
                char[] types;
                StringBuffer typeConditionSB = new StringBuffer();
                for (char type : types = param.getPersonType().toCharArray()) {
                    typeConditionSB.append(" personType = ? or");
                    list.add(new String(new char[]{type}));
                }
                String typeConfition = typeConditionSB.toString();
                typeConfition = typeConfition.substring(0, typeConfition.length() - 2);
                sb.append(" and (").append(typeConfition).append(")");
            }
            if (StringUtils.isNotBlank((CharSequence)param.getIdentifier())) {
                sb.append(" and identifier = ?");
                list.add(param.getIdentifier());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getVerifyState())) {
                if ("3".equals(param.getVerifyState())) {
                    sb.append(" and ( personType = '2' or verifyState = ?)");
                } else {
                    sb.append(" and  verifyState = ? ");
                }
                list.add(param.getVerifyState());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getIfDelete())) {
                sb.append(" and ifDelete = ?");
                list.add(param.getIfDelete());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getCode())) {
                sb.append(" and code = ?");
                list.add(param.getCode());
            }
        }
        Object[] values = list.toArray(new String[0]);
        String select = sb.toString() + " order by lastUpdateTime desc";
        String selectCount = "select count(*) " + sb.toString();
        return this.baseDao.getListByHQL(selectCount, select, values, page);
    }

    @Override
    public MDPAndPolice getByIdentifierOrCode(String identifier) {
        return (MDPAndPolice)this.baseDao.getObjectByHQL("from MDPAndPolice where (identifier = ? or code = ?) and ifDelete ='0'", new String[]{identifier, identifier});
    }

    @Override
    public MDPAndPolice getByIdentifierOrCodeIgnoreCase(String identifier) {
        return (MDPAndPolice)this.baseDao.getObjectByHQL("from MDPAndPolice where (upper(identifier) = upper(?) or upper(code) = upper(?)) and ifDelete ='0'", new String[]{identifier, identifier});
    }

    @Override
    public MDPAndPolice getById(String id) {
        return (MDPAndPolice)this.baseDao.getObjectById(MDPAndPolice.class, (Serializable)((Object)id));
    }

    @Override
    public List<MDPPersonRoleBean> queryMDPPersonRole(String[] personIds) {
        if (personIds == null && personIds.length < 1) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String sql = "select distinct p.person_id as \"personId\", p.sys_role_id as \"roleId\", r.name as \"roleName\" from t_mdp_person_role p, t_upms_role r  where p.sys_role_id=r.id and p.person_id in (";
        for (String personId : personIds) {
            sql = sql + "?,";
            list.add(personId);
        }
        sql = sql.substring(0, sql.length() - 1);
        sql = sql + ")";
        Object[] values = list.toArray(new String[0]);
        return this.baseDao.getListBySQL(sql, values, MDPPersonRoleBean.class);
    }

    @Override
    public List<MDPPersonRoleBean> queryMDPPoliceRole(String personId) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "select distinct cast('" + personId + "' as varchar2(32)) as \"personId\", r.id as \"roleId\", r.name as \"roleName\" from  t_upms_role r  where  (r.id in (select p.sys_role_id from T_UPMS_PERSON_ROLE p where p.person_id =? ) or (r.id = '" + "1" + "' or r.id = '" + "2" + "') )and r.id in ('0','1','2','3','4')";
        list.add(personId);
        Object[] values = list.toArray(new String[0]);
        return this.baseDao.getListBySQL(sql, values, MDPPersonRoleBean.class);
    }
}

