/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syn.service.impl;

import com.xdja.drs.service.Data;
import com.xdja.drs.service.DrsServiceClient;
import com.xdja.drs.service.QueryRequest;
import com.xdja.drs.service.QueryResult;
import com.xdja.drs.service.UserUnitInfo;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.sso.bean.SynDepartment;
import com.xdja.pams.sso.bean.SynRst;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.syn.bean.QueryParamDep;
import com.xdja.pams.syn.service.BaseInfoQueryService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class BaseInfoQueryServiceImpl
implements BaseInfoQueryService {
    @Autowired
    DepManageService depManagerService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private UserManageService ums;
    private static final Logger log = LoggerFactory.getLogger(BaseInfoQueryServiceImpl.class);

    @Override
    public SynRst<SynDepartment> queryDepartment(String thirdId, String pageNo, String pageSize, QueryParamDep param) {
        return null;
    }

    @Override
    public SynRst<SynDepartment> queryDepartmenById(QueryParamDep param) {
        String depId = param.getDepId();
        SynRst<SynDepartment> synRst = new SynRst<SynDepartment>();
        Department dep = this.depManagerService.queryDepById(depId);
        SynDepartment synDep = BaseInfoQueryServiceImpl.cvsDepToSynDep(dep);
        ArrayList<SynDepartment> list = new ArrayList<SynDepartment>();
        if (synDep != null) {
            list.add(synDep);
        }
        synRst.setResult("0", MessageManager.getProMessage(this.message, "common.message.operate.success"));
        synRst.setList(list);
        synRst.setCount(list.size());
        return synRst;
    }

    public static SynDepartment cvsDepToSynDep(Department dep) {
        if (dep == null) {
            return null;
        }
        SynDepartment synDep = new SynDepartment();
        synDep.setId(dep.getId());
        synDep.setName(dep.getName());
        synDep.setCode(dep.getCode());
        synDep.setContact(dep.getLinkman());
        synDep.setPhone(dep.getPhone());
        synDep.setGrage(dep.getLevel());
        synDep.setParent_id(dep.getParentID());
        synDep.setSeq(Long.toString(dep.getOrderField()));
        synDep.setDep_abb(dep.getNameAbbr());
        synDep.setNote(dep.getNote());
        synDep.setAmount(Integer.toString(dep.getCount()));
        synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
        synDep.setDelete_flag(dep.getFlag());
        return synDep;
    }

    @Override
    public String queryNameFromQGK(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return null;
        }
        String jkUrl = this.systemConfigService.getValueByCode("datawebservice_url");
        String jkCode = this.systemConfigService.getValueByCode("drs_user_code");
        Person reqPerson = this.ums.getUserByCode(jkCode);
        String localTable = "rk_czrk";
        String condition = "C_GMSFHM='" + identifier.toUpperCase() + "'  or C_GMSFHM='" + identifier.toLowerCase() + "'";
        String localFields = "c_xm";
        QueryRequest qr = new QueryRequest();
        qr.setLocalTable(localTable);
        qr.setCondition(condition);
        qr.setLocalFields(localFields);
        UserUnitInfo uuInfo = new UserUnitInfo();
        uuInfo.setPoliceName(reqPerson.getName());
        uuInfo.setPoliceSfzh(reqPerson.getIdentifier());
        uuInfo.setUnitCode(reqPerson.getDepartment().getCode());
        uuInfo.setUnitName(reqPerson.getDepartment().getName());
        qr.setUuInfo(uuInfo);
        DrsServiceClient dr = DrsServiceClient.getInstance((String)jkUrl, (String)"", (int)0);
        QueryResult returnRes = dr.query(qr);
        if (returnRes.getState() == 1) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff0c\u9519\u8bef\uff1a" + returnRes.getErrMsg());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "syn.base.query.error.queryidentifiererror") + ":" + returnRes.getErrMsg());
        }
        List list = returnRes.getRows();
        String xm = null;
        if (list.size() > 0) {
            Data[] row = (Data[])list.get(0);
            xm = row[0].getValue();
        }
        return xm;
    }

    public static void main(String[] args) {
        String localTable = "rk_czrk";
        String condition = "C_GMSFHM='410000000000000012'  or C_GMSFHM='410000000000000012'";
        String localFields = "c_xm";
        QueryRequest qr = new QueryRequest();
        qr.setLocalTable(localTable);
        qr.setCondition(condition);
        qr.setLocalFields(localFields);
        DrsServiceClient dr = DrsServiceClient.getInstance((String)"http://192.168.22.226:8050/drs/ws/DataRequest?wsdl", (String)"", (int)0);
        QueryResult returnRes = dr.query(qr);
        List list = returnRes.getRows();
        String xm = null;
        if (list.size() > 0) {
            Data[] row = (Data[])list.get(0);
            xm = row[0].getValue();
            System.out.println(xm);
        }
    }
}

