/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.tims.control;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.tims.bean.PnResult;
import com.xdja.pams.tims.bean.QueryForm;
import com.xdja.pams.tims.entity.MsgPush;
import com.xdja.pams.tims.service.MsgPushService;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class MessagePushController
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private MsgPushService msgPushService;
    @Autowired
    private SystemLogService systemLogService;
    private static final Logger log = LoggerFactory.getLogger(MessagePushController.class);

    @RequestMapping(value={"tims/messagepushcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"tims/messagepushcontroller/queryMsgList.do"})
    public void queryMsgList(HttpServletRequest request, HttpServletResponse response, QueryForm form, PageParam pageParam) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        int operateResult = 1;
        List<MsgPush> list = null;
        try {
            list = this.msgPushService.query(form, page);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            operateResult = 0;
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", page.getTotal());
        map.put("rows", list);
        String json = Util.toJsonStr(map);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"tims/messagepushcontroller/toSendPage.do"})
    public String toSendPage(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        try {
            String maxcount = this.systemConfigService.getValueByCode("msgpush_selectpersoncount_max");
            String appid = this.systemConfigService.getValueByCode("msgpush_appid");
            String cache = this.systemConfigService.getValueByCode("msgpush_cache");
            String single = this.systemConfigService.getValueByCode("msgpush_single");
            map.put((Object)"maxcount", (Object)maxcount);
            map.put((Object)"appid", (Object)appid);
            map.put((Object)"cache", (Object)cache);
            map.put((Object)"single", (Object)single);
            map.put((Object)"person", (Object)this.person);
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return "tims/messagePush/default/messagePush";
    }

    @RequestMapping(value={"tims/messagepushcontroller/sendMsg.do"})
    public void sendMsg(HttpServletRequest request, HttpServletResponse response, String param) {
        String rst = null;
        try {
            String str = URLDecoder.decode(param, "utf-8");
            this.msgPushService.saveMsgPushFormBean(str, this.person);
            log.debug("\u6d88\u606f\u63a8\u9001\u5185\u5bb9\uff1a" + str);
            String pnRequest = this.msgPushService.getPnRequestJson(str);
            pnRequest = URLEncoder.encode(pnRequest, "utf-8");
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String urlStr = this.systemConfigService.getValueByCode("msgpush_url");
            rst = httpclient.post(urlStr, pnRequest);
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u63a8\u9001\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            PnResult pr = new PnResult();
            pr.setState(Integer.parseInt("1"));
            pr.setMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            rst = Util.toJsonStr(pr);
        }
        Util.writeUtf8Text(response, rst);
    }

    public ResourceBundleMessageSource getMessage() {
        return this.message;
    }

    public void setMessage(ResourceBundleMessageSource message) {
        this.message = message;
    }
}

