/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.upms.bean.QueryRoleBean;
import com.xdja.pams.upms.dao.TerminalRoleDao;
import com.xdja.pams.upms.entity.Role;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TerminalRoleDaoImpl
implements TerminalRoleDao {
    @Autowired
    private BaseDao baseDao;
    private static final Logger log = LoggerFactory.getLogger(TerminalRoleDaoImpl.class);

    @Override
    public Role queryRoleById(String roleid) {
        return (Role)this.baseDao.getObjectById(Role.class, (Serializable)((Object)roleid));
    }

    @Override
    public List<Role> queryRoleList(Role role, Page page) {
        StringBuilder select = new StringBuilder("from Role where type=2 ");
        ArrayList<String> list = new ArrayList<String>();
        if (role != null) {
            if (StringUtils.isNotBlank((CharSequence)role.getName())) {
                select.append(" and name like ?");
                list.add("%" + role.getName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)role.getId())) {
                select.append(" and id = ?");
                list.add(role.getId());
            }
        }
        select.append("order by seq");
        log.debug("@sql:" + select);
        String selectCount = "select count(1) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new String[0]);
        }
        return this.baseDao.getListByHQL(selectCount, select.toString(), values, page);
    }

    @Override
    public Role addRole(Role role) {
        this.baseDao.create(role);
        return role;
    }

    @Override
    public void updateRole(Role role) {
        this.baseDao.update(role);
    }

    @Override
    public void deleteRole(Role role) {
        this.baseDao.delete(role);
    }

    @Override
    public List<Role> queryRoleList(QueryRoleBean role, Page page) {
        StringBuilder select = new StringBuilder("from Role where type=2 ");
        ArrayList<String> list = new ArrayList<String>();
        if (role != null) {
            if (StringUtils.isNotBlank((CharSequence)role.getCreator_id())) {
                select.append(" and ( creator_id = ?");
                list.add(role.getCreator_id());
                if (StringUtils.isNotBlank((CharSequence)role.getFlag())) {
                    select.append(" or flag = ? )");
                    list.add(role.getFlag());
                } else {
                    select.append(" )");
                }
            } else {
                select.append(" and creator_id is null");
            }
            if (StringUtils.isNotBlank((CharSequence)role.getName())) {
                select.append(" and name like ?");
                list.add("%" + role.getName() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)role.getId())) {
                select.append(" and id = ?");
                list.add(role.getId());
            }
        }
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new String[0]);
        }
        log.info(selectCount);
        return this.baseDao.getListByHQL(selectCount, select.toString() + " order by seq", values, page);
    }

    @Override
    public boolean queryRole(Role role) {
        List<?> list;
        boolean flag = false;
        StringBuilder select = new StringBuilder("from Role where type='2'");
        if (role != null && StringUtils.isNotBlank((CharSequence)role.getName())) {
            select.append(" and name='" + role.getName() + "'");
        }
        if ((list = this.baseDao.getListByHQL(select.toString(), null)) != null && list.size() > 0) {
            flag = true;
        }
        return flag;
    }
}

