/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.webservice.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserviceClient {
    private static final Logger log = LoggerFactory.getLogger(WebserviceClient.class);
    protected static Map<String, HttpPost> httpPostMap = new ConcurrentHashMap<String, HttpPost>();
    protected static Namespace NS_SOAP = Namespace.getNamespace((String)"soap", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static DefaultHttpClient httpClient = null;
    protected static SAXBuilder saxb = null;

    protected static HttpPost getHttpPost(String url) {
        HttpPost httpPost;
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        if ((httpPost = httpPostMap.get(url)) == null) {
            return WebserviceClient.createHttpPost(url);
        }
        return httpPost;
    }

    protected static HttpPost createHttpPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "text/xml; charset=UTF-8");
        httpPostMap.put(url, httpPost);
        log.debug("create httpPost success!");
        return httpPost;
    }

    public void destroy() {
        httpClient.getConnectionManager().shutdown();
    }

    public static String getResponseBody(HttpPost httpPost, String strHttpRequestBody) throws Exception {
        StringEntity entity = new StringEntity(strHttpRequestBody, "utf-8");
        httpPost.setEntity((HttpEntity)entity);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        String responseBody = null;
        responseBody = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        return responseBody;
    }

    static {
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        params.setParameter("http.connection.timeout", (Object)100000);
        params.setParameter("http.socket.timeout", (Object)100000);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(schemeRegistry);
        cm.setDefaultMaxPerRoute(20000);
        cm.setMaxTotal(40000);
        httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        saxb = new SAXBuilder();
    }
}

