/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.wfms.service.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.FileUtil;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.wfms.common.WorkflowUtils;
import com.xdja.pams.wfms.dao.WorkflowManagerDao;
import com.xdja.pams.wfms.entity.Group;
import com.xdja.pams.wfms.entity.User;
import com.xdja.pams.wfms.service.WorkflowManagerService;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkflowManagerServiceImpl
implements WorkflowManagerService {
    @Autowired
    private WorkflowManagerDao dao;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private UserManageService ums;
    @Autowired
    private DepManageService dms;

    @Override
    @Transactional
    public boolean deleteWorkflowDeploy(String deploymentId, String filePath) {
        boolean rtn = false;
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.deploymentId(deploymentId).singleResult();
        String pathname = filePath + "\\" + processDefinition.getKey() + "\\" + processDefinition.getVersion();
        this.repositoryService.deleteDeployment(deploymentId, true);
        File workFlowFile = new File(pathname);
        FileUtil.deleteFile(workFlowFile);
        rtn = true;
        return rtn;
    }

    @Override
    @Transactional
    public Group addWorkflowGroup(Group group) {
        return this.dao.addWorkflowGroup(group);
    }

    @Override
    public Group getWorkflowGroupById(String id) {
        return this.dao.getWorkflowGroupById(id);
    }

    @Override
    @Transactional
    public boolean deleteWorkflowGroup(String id) {
        boolean rtn = false;
        this.dao.deleteWorkflowGroup(id);
        rtn = true;
        return rtn;
    }

    @Override
    @Transactional
    public boolean addGroupUser(String selectId, String groupId) {
        boolean rtn = false;
        ArrayList<User> userList = new ArrayList<User>();
        Group group = this.getWorkflowGroupById(groupId);
        group.setActIdUsers(null);
        if (!Util.varCheckEmp(selectId)) {
            String[] userIds;
            for (String userId : userIds = selectId.split(",")) {
                userList.add(this.dao.getWorkflowUserById(userId));
            }
        }
        group.setActIdUsers(userList);
        this.dao.updateWorkflowGroup(group);
        rtn = true;
        return rtn;
    }

    @Override
    @Transactional
    public boolean addGroupUserAndDep(String selectId, String selectDepId, String groupId) {
        boolean rtn = false;
        ArrayList<User> userList = new ArrayList<User>();
        ArrayList<Department> depList = new ArrayList<Department>();
        Group group = this.getWorkflowGroupById(groupId);
        group.setActIdUsers(null);
        group.setActIdDeps(null);
        if (!Util.varCheckEmp(selectId)) {
            String[] userIds;
            for (String userId : userIds = selectId.split(",")) {
                userList.add(this.dao.getWorkflowUserById(userId));
            }
        }
        if (!Util.varCheckEmp(selectDepId)) {
            String[] depIds;
            for (String depId : depIds = selectDepId.split(",")) {
                depList.add(this.dms.queryDepById(depId));
            }
        }
        group.setActIdUsers(userList);
        group.setActIdDeps(depList);
        this.dao.updateWorkflowGroup(group);
        rtn = true;
        return rtn;
    }

    @Override
    public List<User> getGroupUserList(String workflowGroupId) {
        Group group;
        List<User> userList = null;
        if (!Util.varCheckEmp(workflowGroupId) && (group = this.getWorkflowGroupById(workflowGroupId)) != null) {
            userList = group.getActIdUsers();
        }
        return userList;
    }

    @Override
    @Transactional
    public boolean uploadWordflowFile(InputStream fileInputStream, String exportDirTmp, String fileName) throws Exception {
        boolean rtn = false;
        Deployment deployment = null;
        String extension = FilenameUtils.getExtension((String)fileName);
        if ("bar".equals(extension) || "zip".equals(extension)) {
            ZipInputStream zip = new ZipInputStream(fileInputStream);
            deployment = this.repositoryService.createDeployment().addZipInputStream(zip).deploy();
        } else {
            deployment = this.repositoryService.createDeployment().addInputStream(fileName, fileInputStream).deploy();
        }
        if (deployment != null) {
            List list = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).list();
            for (ProcessDefinition processDefinition : list) {
                WorkflowUtils.exportDiagramToFile(this.repositoryService, processDefinition, exportDirTmp);
            }
            rtn = true;
        }
        return rtn;
    }

    @Override
    public List<Group> getWorkflowGroupList(Group group, Page page) {
        return this.dao.getWorkflowGroupList(group, page);
    }

    @Override
    public List<Person> getGroupUserListAsPerson(String workflowGroupId) {
        ArrayList<Person> personList = null;
        List<User> userList = this.getGroupUserList(workflowGroupId);
        if (userList != null && !userList.isEmpty()) {
            personList = new ArrayList<Person>();
            for (User user : userList) {
                Person p = this.ums.queryPersonById(user.getId());
                if (p == null) continue;
                personList.add(p);
            }
        }
        return personList;
    }
}

