/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.wfms.service.impl;

import com.xdja.pams.common.commonException.WorkflowException;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.wfms.bean.WorkflowFlowBean;
import com.xdja.pams.wfms.service.WorkflowUtilService;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class WorkflowUtilServiceImpl
implements WorkflowUtilService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUtilServiceImpl.class);
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    private ResourceBundleMessageSource message;

    @Override
    public List<WorkflowFlowBean> getWorkFlowBtnList(String procInstId) {
        ArrayList<WorkflowFlowBean> wfbList = new ArrayList<WorkflowFlowBean>();
        String workflowKey = "";
        try {
            String processDefinitionId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstId).singleResult()).getProcessDefinitionId();
            workflowKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult()).getKey();
            ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
            ActivityImpl ai = null;
            ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().processInstanceId(procInstId).singleResult();
            String activitiId = execution.getActivityId();
            ai = def.findActivity(activitiId);
            this.setWorkflowFlow(ai, wfbList);
        }
        catch (Exception e) {
            wfbList = null;
            log.error(MessageManager.getProMessage(this.message, "wfms.error.flowMapError", new String[]{workflowKey}), (Throwable)e);
            throw new WorkflowException(MessageManager.getProMessage(this.message, "wfms.error.flowMapError", new String[]{workflowKey}));
        }
        return wfbList;
    }

    @Override
    public List<WorkflowFlowBean> getWorkFlowBtnListForStart(String workflowKey) {
        ArrayList<WorkflowFlowBean> wfbList = new ArrayList<WorkflowFlowBean>();
        try {
            ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(workflowKey).latestVersion().active().singleResult();
            ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(pd.getId());
            ActivityImpl ai = def.getInitial();
            this.setWorkflowFlow(ai, wfbList);
        }
        catch (Exception e) {
            wfbList = null;
            log.error(MessageManager.getProMessage(this.message, "wfms.error.flowMapError", new String[]{workflowKey}), (Throwable)e);
            throw new WorkflowException(MessageManager.getProMessage(this.message, "wfms.error.flowMapError", new String[]{workflowKey}));
        }
        return wfbList;
    }

    @Override
    public void setWorkflowFlow(ActivityImpl ai, List<WorkflowFlowBean> wfbList) {
        List outTransitions = ai.getOutgoingTransitions();
        for (PvmTransition tr : outTransitions) {
            WorkflowFlowBean wfb = new WorkflowFlowBean();
            wfb.setBtnId(tr.getId());
            wfb.setBtnName((String)tr.getProperty("name"));
            wfb.setConditionText((String)tr.getProperty("conditionText"));
            PvmActivity ac = tr.getDestination();
            if ("exclusiveGateway".equals(ac.getProperty("type"))) {
                wfb.setTaskId((String)ac.getProperty("id"));
                wfb.setTaskName((String)ac.getProperty("name"));
                wfb.setTaskType((String)ac.getProperty("type"));
                ArrayList<WorkflowFlowBean> tmpList = new ArrayList<WorkflowFlowBean>();
                this.setWorkflowFlow((ActivityImpl)ac, tmpList);
                wfb.setOutTransitions(tmpList);
            } else if ("userTask".equals(ac.getProperty("type"))) {
                wfb.setTaskId((String)ac.getProperty("id"));
                wfb.setTaskName((String)ac.getProperty("name"));
                wfb.setTaskType((String)ac.getProperty("type"));
                TaskDefinition td = (TaskDefinition)ac.getProperty("taskDefinition");
                if (td.getAssigneeExpression() != null) {
                    wfb.setTaskAssignee(td.getAssigneeExpression().toString());
                }
                String documention = (String)ac.getProperty("documentation");
                wfb.setTaskDocumention(documention);
                if (documention != null) {
                    String[] documentions = documention.split(",");
                    if (documentions.length > 1) {
                        wfb.setTaskGroupCode(documentions[0]);
                        if ("auto".equals(documentions[1])) {
                            wfb.setTaskFlowIsAuto(true);
                        } else {
                            wfb.setTaskFlowIsAuto(false);
                        }
                    }
                    if (documentions.length > 2) {
                        wfb.setTaskUserHistoryTaskId(documentions[2]);
                    }
                }
            } else if ("endEvent".equals(ac.getProperty("type"))) {
                wfb.setTaskId((String)ac.getProperty("id"));
                wfb.setTaskName((String)ac.getProperty("name"));
                wfb.setTaskType((String)ac.getProperty("type"));
            } else {
                log.error("\u51fa\u73b0\u4e0d\u652f\u6301\u7684\u6d41\u7a0b\u8282\u70b9\u7c7b\u578b\uff1a" + (String)ac.getProperty("type"));
                wfb = null;
            }
            wfbList.add(wfb);
        }
    }
}

