/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.wzmh.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.wzmh.bean.QueryWebPortalBean;
import com.xdja.pams.wzmh.entity.WebPortal;
import com.xdja.pams.wzmh.service.WebPortalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class WebPortalControler
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    WebPortalService webPortalService;
    private static final Logger log = LoggerFactory.getLogger(WebPortalControler.class);

    @RequestMapping(value={"/webPortal/WebPortalControler/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        return sendUrl;
    }

    @RequestMapping(value={"/webPortal/WebPortalControler/queryWebPortalList.do"})
    public void queryWebPortalList(QueryWebPortalBean queryWebPortalBean, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        HttpSession session = request.getSession();
        Operator operator = (Operator)session.getAttribute("operator");
        Person person = operator.getPerson();
        int operateResult = 0;
        try {
            List<WebPortal> list = this.webPortalService.query(queryWebPortalBean, page);
            ArrayList<QueryWebPortalBean> listNew = new ArrayList<QueryWebPortalBean>();
            if (null != list && list.size() > 0) {
                for (WebPortal webPortal : list) {
                    QueryWebPortalBean queryWebPortalBeanNew = new QueryWebPortalBean();
                    BeanUtils.copyProperties((Object)webPortal, (Object)queryWebPortalBeanNew);
                    queryWebPortalBeanNew.setContentTypeName(this.commonCodePbService.getCodeNameByCode(webPortal.getContentType(), "contentType"));
                    queryWebPortalBeanNew.setContentStateName(this.commonCodePbService.getCodeNameByCode(webPortal.getContentState(), "contentState"));
                    listNew.add(queryWebPortalBeanNew);
                }
            }
            map.put("total", Integer.valueOf(page.getTotal()));
            map.put("rows", listNew);
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u53d1\u5e03\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/webPortal/WebPortalControler/toEditOrAddWebPortal.do"})
    public String toEditOrAddEdifice(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        WebPortal webPortal = null;
        if (!"noID".equals(id)) {
            try {
                webPortal = this.webPortalService.getWebPortal((Serializable)((Object)id));
                if (null != webPortal.getContent()) {
                    webPortal.setContent(webPortal.getContent().replaceAll("\"", "'"));
                }
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u697c\u5b87\u7f16\u53f7\u83b7\u53d6\u697c\u5b87\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
        } else {
            webPortal = new WebPortal();
        }
        map.put((Object)"webPortal", (Object)webPortal);
        map.put((Object)"person", (Object)this.person);
        return "jwmh/default/addOrEdit";
    }

    @RequestMapping(value={"/webPortal/WebPortalControler/auditWeb.do"})
    public String auditWeb(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        WebPortal webPortal = null;
        try {
            webPortal = this.webPortalService.getWebPortal((Serializable)((Object)id));
            if (null != webPortal.getContent()) {
                webPortal.setContent(webPortal.getContent().replaceAll("\"", "'"));
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u697c\u5b87\u7f16\u53f7\u83b7\u53d6\u697c\u5b87\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        map.put((Object)"webPortal", (Object)webPortal);
        map.put((Object)"person", (Object)this.person);
        return "jwmh/default/auditWeb";
    }

    @RequestMapping(value={"/webPortal/WebPortalControler/view.do"})
    public String view(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        WebPortal webPortal = null;
        try {
            webPortal = this.webPortalService.getWebPortal((Serializable)((Object)id));
            if (null != webPortal.getContent()) {
                webPortal.setContent(webPortal.getContent().replaceAll("\"", "'"));
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u697c\u5b87\u7f16\u53f7\u83b7\u53d6\u697c\u5b87\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        map.put((Object)"webPortal", (Object)webPortal);
        map.put((Object)"person", (Object)this.person);
        return "jwmh/default/viewWeb";
    }

    @RequestMapping(value={"/webPortal/WebPortalControler/save.do"})
    public void save(HttpServletRequest request, HttpServletResponse response, ModelMap map, WebPortal webPortal) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            webPortal.setPersonId(this.person.getId());
            webPortal.setCreateDate(new Date());
            String imgPath = this.webPortalService.getImg(webPortal);
            webPortal.setImgPath(imgPath);
            this.webPortalService.saveWebPortal(webPortal);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/webPortal/WebPortalControler/update.do"})
    public void update(HttpServletRequest request, HttpServletResponse response, ModelMap map, WebPortal webPortal) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            webPortal.setPersonId(this.person.getId());
            webPortal.setCreateDate(new Date());
            this.webPortalService.updateWebPortal(webPortal);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/webPortal/WebPortalControler/saveAudit.do"})
    public void saveAudit(HttpServletRequest request, HttpServletResponse response, ModelMap map, WebPortal webPortal) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        try {
            this.webPortalService.updateWebPortal(webPortal);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u5ba1\u6838\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/webPortal/WebPortalControler/delete.do"})
    public void delete(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 0;
        WebPortal webPortal = null;
        try {
            webPortal = new WebPortal();
            webPortal.setId(id);
            this.webPortalService.deleteWebPortal(webPortal);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u53d1\u5e03\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }
}

