/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.control;

import com.xdja.pams.bims.bean.DepartmentBean;
import com.xdja.pams.bims.bean.ImpDepExcelBean;
import com.xdja.pams.bims.bean.QueryDepBean;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.sso.bean.SynRst;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
public class DepManageControler
extends BaseControler {
    @Autowired
    private DepManageService depService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private TokenFactory tokenFactory;
    private static final DecimalFormat df = new DecimalFormat("######0.00");
    private String depJsonCache = "";
    private static final Logger log = LoggerFactory.getLogger(DepManageControler.class);

    @RequestMapping(value={"/bims/DepManageControler/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        return sendUrl;
    }

    @RequestMapping(value={"/bims/DepManageControler/getAllDepJson.do"})
    public void getAllDepJson(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        String[] contrlDepsArray;
        ArrayList items = new ArrayList();
        String controlDeps = this.getControlDeps(request);
        for (String ocntrlDepId : contrlDepsArray = controlDeps.split(",")) {
            Department dep = this.depService.queryDepById(ocntrlDepId);
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", dep.getId());
            item.put("text", dep.getName());
            if (dep.getChildDeps() != null && dep.getChildDeps().size() > 0) {
                item.put("state", "closed");
                item.put("children", this.getChildrenMap(dep));
            }
            items.add(item);
        }
        this.depJsonCache = Util.toJsonStr(items);
        log.info(this.depJsonCache);
        Util.writeUtf8Text(response, this.depJsonCache);
    }

    private List<Map<String, Object>> getChildrenMap(Department dep) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (Department depNode : dep.getChildDeps()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", depNode.getId());
            item.put("text", depNode.getName());
            if (depNode.getChildDeps() != null && depNode.getChildDeps().size() > 0) {
                item.put("state", "closed");
                item.put("children", this.getChildrenMap(depNode));
            }
            items.add(item);
        }
        return items;
    }

    @RequestMapping(value={"/bims/DepManageControler/queryDepList.do"})
    public void queryDepList(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryDepBean queryDepBean) {
        int operateResult = 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        try {
            Page page = new Page(Integer.parseInt(queryDepBean.getPage()), Integer.parseInt(queryDepBean.getRows()));
            String controlDeps = this.getControlDeps(request);
            List<Department> depList = this.depService.queryDepList(queryDepBean, controlDeps, page);
            result.put("total", Integer.valueOf(page.getTotal()));
            ArrayList<QueryDepBean> list = new ArrayList<QueryDepBean>();
            for (int i = 0; i < depList.size(); ++i) {
                QueryDepBean depBean = new QueryDepBean();
                Department dep = depList.get(i);
                depBean.setId(dep.getId());
                depBean.setName(dep.getName());
                depBean.setCode(dep.getCode());
                depBean.setNameAbbr(dep.getNameAbbr());
                depBean.setNote(dep.getNote());
                depBean.setOrderField(dep.getOrderField());
                depBean.setLinkman(dep.getLinkman());
                depBean.setPhone(dep.getPhone());
                depBean.setDisplayState(dep.getDisplayState());
                list.add(depBean);
            }
            result.put("rows", list);
            log.info(Util.toJsonStr(result));
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5355\u4f4d\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/bims/DepManageControler/toEditOrAdd.do"})
    public String toEditOrAdd(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        Department dep;
        if (!"noID".equals(id)) {
            dep = this.depService.queryDepById(id);
            if ("8888888888".equals(id)) {
                dep.setParentDep(new Department());
            }
        } else {
            dep = new Department();
            dep.setParentDep(new Department());
        }
        map.put((Object)"dep", (Object)dep);
        return "bims/depManage/default/addOrEdit";
    }

    @RequestMapping(value={"/bims/DepManageControler/add.do"})
    public void add(HttpServletRequest request, HttpServletResponse response, ModelMap map, Department dep) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            if (this.depService.checkDepCode(dep.getCode())) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.dep.error.add.dep1"));
            } else {
                Department parentDep = this.depService.queryDepById(dep.getParentID());
                dep.setParentDep(parentDep);
                dep.setLevel(Integer.parseInt(parentDep.getLevel()) + 1 + "");
                dep.setDepType("dept");
                this.depService.addDep(dep);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u5355\u4f4d\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        log.info(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/DepManageControler/edit.do"})
    public void edit(HttpServletRequest request, HttpServletResponse response, ModelMap map, Department dep) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        Department updatedDep = this.depService.queryDepById(dep.getId());
        try {
            if (dep.getId().equals(dep.getParentID())) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.dep.error.edit.dep1"));
            } else if (dep.getParentID() != null && this.depService.judgeDepIsChildDep(dep.getId(), dep.getParentID())) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.dep.error.edit.dep2"));
            } else if (!updatedDep.getCode().equals(dep.getCode()) && this.depService.checkDepCode(dep.getCode())) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.dep.error.add.dep1"));
            } else {
                boolean parentDepEditFlag = false;
                if (dep.getParentID() != null && updatedDep.getParentDep() != null && !dep.getParentID().equals(updatedDep.getParentDep().getId())) {
                    parentDepEditFlag = true;
                }
                boolean changeCodeFlag = false;
                updatedDep.setName(dep.getName());
                updatedDep.setNameAbbr(dep.getNameAbbr());
                updatedDep.setLinkman(dep.getLinkman());
                updatedDep.setPhone(dep.getPhone());
                updatedDep.setNote(dep.getNote());
                updatedDep.setOrderField(dep.getOrderField());
                updatedDep.setDisplayState(dep.getDisplayState());
                if (dep.getParentID() != null && !"".equals(dep.getParentID())) {
                    Department parentDep = this.depService.queryDepById(dep.getParentID());
                    updatedDep.setParentDep(parentDep);
                    updatedDep.setLevel(Integer.parseInt(parentDep.getLevel()) + 1 + "");
                    if (!dep.getCode().equals(updatedDep.getCode())) {
                        changeCodeFlag = true;
                    }
                    updatedDep.setTreeId(parentDep.getTreeId() + updatedDep.getId() + "-");
                    updatedDep.setTreeCode(parentDep.getTreeCode() + dep.getCode() + "-");
                } else if (!dep.getCode().equals(updatedDep.getCode())) {
                    updatedDep.setTreeCode("-" + dep.getCode() + "-");
                    changeCodeFlag = true;
                }
                updatedDep.setCode(dep.getCode());
                this.depService.updateDep(updatedDep, parentDepEditFlag);
                if (changeCodeFlag) {
                    this.userManageService.updatePersonDepCode(updatedDep);
                    this.depService.updateChildDepTreeCode(updatedDep);
                }
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5355\u4f4d\u4fe1\u606f\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        log.info(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/DepManageControler/depDisplay.do"})
    public void depDisplay(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String displayState) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Department updatedDep = this.depService.queryDepById(id);
            updatedDep.setDisplayState(displayState);
            this.depService.updateDep(updatedDep, false);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/DepManageControler/delete.do"})
    public void delete(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            if ("8888888888".equals(id)) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.dep.error.delete.dep1"));
            } else if (this.depService.isCanDelete(id)) {
                this.depService.deleteDepById(id);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.dep.error.delete.dep2"));
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5355\u4f4d\u4fe1\u606f\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        log.info(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/DepManageControler/deleteBatch.do"})
    public void deleteBatch(HttpServletRequest request, HttpServletResponse response, ModelMap map, String ids) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            int i;
            String canNotDeleteDeps = "";
            String[] idArray = ids.split(",");
            for (i = 0; i < idArray.length; ++i) {
                if (this.depService.isCanDelete(idArray[i])) continue;
                Department dep = this.depService.queryDepById(idArray[i]);
                canNotDeleteDeps = canNotDeleteDeps + dep.getName() + ";";
            }
            if ("".equals(canNotDeleteDeps)) {
                for (i = 0; i < idArray.length; ++i) {
                    this.depService.deleteDepById(idArray[i]);
                }
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "bims.dep.error.delete.dep2") + canNotDeleteDeps);
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5220\u9664\u5355\u4f4d\u4fe1\u606f\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        log.info(Util.toJsonStr(rtnResult));
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/DepManageControler/exportExcel.do"})
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryDepBean queryDepBean) {
        try {
            String fileName = Util.toUtf8String(this.scps.getValueByCode("expBimsDepFileName")) + ".xls";
            String fileTitle = this.scps.getValueByCode("expBimsDepFileTitle");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            Page page = new Page(1, Integer.parseInt(this.scps.getValueByCode("maxExcelCount")));
            List<Department> depList = this.depService.queryDepList(queryDepBean, null, page);
            ArrayList<String> titleList = new ArrayList<String>();
            titleList.add(MessageManager.getProMessage(this.message, "bims.dep.page.info.depcode"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.dep.page.info.depname"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.dep.page.info.depnameabbr"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.dep.page.info.linkman"));
            titleList.add(MessageManager.getProMessage(this.message, "bims.dep.page.info.phone"));
            ExcelUtil.getExcelAsTitle((OutputStream)response.getOutputStream(), fileTitle, fileTitle, depList, titleList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Util.writeUtf8Text(response, MessageManager.getProMessage(this.message, "exp.error.msg"));
        }
    }

    @RequestMapping(value={"/bims/DepManageControler/toImportExcel.do"})
    public String toImportExcel(HttpServletRequest request) {
        String ticket = CookieUtils.getCookie(request, "operator", String.class);
        this.tokenFactory.getOperator().add("upload:dep:rate:" + ticket, "0");
        return "bims/depManage/default/import";
    }

    @RequestMapping(value={"/bims/DepManageControler/importExcel.do"})
    public void importExcel(@RequestParam MultipartFile file, HttpServletResponse response, HttpServletRequest request) {
        log.info("importExcel start.....................");
        HashSet<ImpDepExcelBean> wellList = new HashSet<ImpDepExcelBean>();
        ArrayList<ImpDepExcelBean> errorList = new ArrayList<ImpDepExcelBean>();
        ArrayList<ImpDepExcelBean> codeExitList = new ArrayList<ImpDepExcelBean>();
        ArrayList<ImpDepExcelBean> noParentList = new ArrayList<ImpDepExcelBean>();
        HashMap<String, Object> totalCount = new HashMap<String, Object>();
        try {
            this.depService.importDep(file, wellList, noParentList, errorList, codeExitList, totalCount, this.operator.getPerson().getDepId(), request);
            totalCount.put("wellCount", wellList.size());
            totalCount.put("noParentList", noParentList);
            totalCount.put("noParentCount", noParentList.size());
            totalCount.put("errorList", errorList);
            totalCount.put("errorCount", errorList.size());
            totalCount.put("codeExitList", codeExitList);
            totalCount.put("codeExitCount", codeExitList.size());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (e.getMessage() != null && e.getMessage().indexOf("ORA") > 0) {
                totalCount.put("error", MessageManager.getProMessage(this.message, "exp.error.msg"));
            }
            if (e.getMessage() != null) {
                totalCount.put("error", e.getMessage());
            }
            totalCount.put("error", "\u5bfc\u5165\u5931\u8d25\uff01");
        }
        log.info(Util.toJsonStr(totalCount));
        log.info(".....................importExcel end.");
        Util.writeUtf8Text1(response, Util.toJsonStr(totalCount));
    }

    @RequestMapping(value={"/bims/DepManageControler/importProgress.do"})
    public void importProgress(HttpServletResponse response, HttpServletRequest request) {
        try {
            String ticket = CookieUtils.getCookie(request, "operator", String.class);
            if (StringUtils.isNotBlank((CharSequence)ticket)) {
                double result = 0.0;
                String value = (String)this.tokenFactory.getOperator().get("upload:dep:rate:" + ticket);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    result = Double.parseDouble(value);
                }
                Util.writeUtf8Text1(response, df.format(result *= 100.0));
            } else {
                Util.writeUtf8Text1(response, df.format(0L));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Util.writeUtf8Text1(response, df.format(0L));
        }
    }

    @RequestMapping(value={"/bims/DepManageControler/getAllDepartments.do"})
    public void getAllDepartments(HttpServletRequest request, HttpServletResponse response, ModelMap map, String deptId) {
        SynRst synRst = new SynRst();
        try {
            List<Department> deptList = this.depService.getAllDepartments(deptId);
            ArrayList<DepartmentBean> deptBeanList = new ArrayList<DepartmentBean>();
            for (Department dept : deptList) {
                DepartmentBean departmentBean = new DepartmentBean();
                departmentBean.setCode(dept.getCode());
                departmentBean.setCount(dept.getCount());
                departmentBean.setFlag(dept.getFlag());
                departmentBean.setId(dept.getId());
                departmentBean.setIsDirectDep(dept.getIsDirectDep());
                departmentBean.setLevel(dept.getLevel());
                departmentBean.setLinkman(dept.getLinkman());
                departmentBean.setName(dept.getName());
                departmentBean.setNameAbbr(dept.getNameAbbr());
                departmentBean.setNote(dept.getNote());
                departmentBean.setOrderField(dept.getOrderField());
                departmentBean.setParentID(dept.getParentID());
                departmentBean.setParentID2(dept.getParentID2());
                departmentBean.setPhone(dept.getPhone());
                departmentBean.setTimestamp(dept.getTimestamp());
                deptBeanList.add(departmentBean);
            }
            synRst.setList(deptBeanList);
            synRst.setCount(deptBeanList.size());
            synRst.setResult("0", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.success"));
        }
        catch (Exception e) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.error"));
            log.error("\u83b7\u53d6\u6240\u6709\u90e8\u95e8\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(synRst));
    }
}

