/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.control;

import com.xdja.pams.bims.bean.QueryGroupBean;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.GroupManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class GroupManageControler
extends BaseControler {
    @Autowired
    private GroupManageService groupManageService;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    private static final Logger log = LoggerFactory.getLogger(GroupManageControler.class);

    @RequestMapping(value={"/bims/GroupManageControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/bims/GroupManageControler/queryGroupList.do"})
    public void queryGroupList(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryGroupBean groupBean) {
        int operateResult = 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        try {
            Page page = new Page(Integer.parseInt(groupBean.getPage()), Integer.parseInt(groupBean.getRows()));
            groupBean.setCreatorID(this.person.getId());
            List<BimsGroup> groupList = this.groupManageService.queryGroupList(groupBean, this.getControlDeps(request), page);
            result.put("total", Integer.valueOf(page.getTotal()));
            ArrayList<QueryGroupBean> list = new ArrayList<QueryGroupBean>();
            for (int i = 0; i < groupList.size(); ++i) {
                QueryGroupBean groupQuryBean = new QueryGroupBean();
                BimsGroup group = groupList.get(i);
                groupQuryBean.setId(group.getId());
                groupQuryBean.setName(group.getName());
                String[] typeArray = group.getType().split(",");
                String typeNames = "";
                for (String type : typeArray) {
                    typeNames = typeNames + this.commonCodePbService.getCodeNameByCode(type, "2044") + ",";
                }
                typeNames = typeNames.substring(0, typeNames.length() - 1);
                groupQuryBean.setType(typeNames);
                groupQuryBean.setDepName(group.getDepartment().getName());
                groupQuryBean.setNote(group.getNote());
                groupQuryBean.setOrderField(group.getOrderField());
                groupQuryBean.setCreator(this.userManageService.getPersonById(group.getCreatorID()).getNAME());
                groupQuryBean.setManageFlagName(this.commonCodePbService.getCodeNameByCode(group.getManageFlag(), "group_manage"));
                list.add(groupQuryBean);
            }
            result.put("rows", list);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u67e5\u8be2\u5206\u7ec4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/bims/GroupManageControler/toEditOrAdd.do"})
    public String toEditOrAdd(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        BimsGroup group = !"0".equals(id) ? this.groupManageService.queryGroupByID(id) : new BimsGroup();
        map.put((Object)"group", (Object)group);
        return "bims/groupManage/default/addOrEdit";
    }

    @RequestMapping(value={"/bims/GroupManageControler/add.do"})
    public void add(HttpServletRequest request, HttpServletResponse response, ModelMap map, BimsGroup group) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            int i;
            String depIds = group.getDepId();
            String[] depIdArray = depIds.split(",");
            String repeatName = "";
            for (i = 0; i < depIdArray.length; ++i) {
                QueryGroupBean groupBean = new QueryGroupBean();
                groupBean.setDepId(depIdArray[i]);
                groupBean.setName(group.getName());
                List<BimsGroup> groupList = this.groupManageService.queryGroupList(groupBean, this.getControlDeps(request), null);
                boolean flag = false;
                for (BimsGroup bimsGroup : groupList) {
                    if (!bimsGroup.getName().equals(group.getName()) || !bimsGroup.getDepId().equals(depIdArray[i])) continue;
                    repeatName = this.depManageService.queryDepById(depIdArray[i]).getName() + " \u5355\u4f4d\u4e0b\u5df2\u5b58\u5728\u540c\u540d\u5206\u7ec4\uff0c\u6dfb\u52a0\u64cd\u4f5c\u5931\u8d25";
                    flag = true;
                    break;
                }
                if (flag) break;
            }
            if ("".equals(repeatName)) {
                for (i = 0; i < depIdArray.length; ++i) {
                    BimsGroup bimsgroup = new BimsGroup();
                    bimsgroup.setName(group.getName());
                    bimsgroup.setType(group.getType());
                    bimsgroup.setNote(group.getNote());
                    bimsgroup.setOrderField(group.getOrderField());
                    bimsgroup.setFlag("0");
                    bimsgroup.setManageFlag(group.getManageFlag());
                    bimsgroup.setCreatorID(this.person.getId());
                    bimsgroup.setDepartment(this.depManageService.queryDepById(depIdArray[i]));
                    this.groupManageService.addGroup(bimsgroup);
                }
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(repeatName);
            }
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u6dfb\u52a0\u5206\u7ec4\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/GroupManageControler/edit.do"})
    public void edit(HttpServletRequest request, HttpServletResponse response, ModelMap map, BimsGroup group) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        Page page = new Page(1, 100);
        String repeatName = "";
        try {
            QueryGroupBean groupBean = new QueryGroupBean();
            groupBean.setName(group.getName());
            List<BimsGroup> groupList = this.groupManageService.queryGroupList(groupBean, this.getControlDeps(request), page);
            if (groupList != null && groupList.size() > 0) {
                for (BimsGroup group1 : groupList) {
                    if (group.getId().equals(group1.getId()) || !group.getDepId().equals(group1.getDepartment().getId()) || !group.getName().equals(group1.getName())) continue;
                    repeatName = group1.getDepartment().getName() + " \u5355\u4f4d\u4e0b\u5df2\u5b58\u5728\u540c\u540d\u7684\u5206\u7ec4\uff0c\u4fee\u6539\u64cd\u4f5c\u5931\u8d25";
                }
            }
            if (!"".equals(repeatName)) {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(repeatName);
            } else {
                this.groupManageService.updateGroupForEdit(group);
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            }
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u4fee\u6539\u5206\u7ec4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/GroupManageControler/delete.do"})
    public void delete(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            BimsGroup tempGroup = this.groupManageService.queryGroupByID(id);
            if (tempGroup == null) {
                throw new Exception("\u5220\u9664\u5206\u7ec4\u5f02\u5e38\uff1a\u5206\u7ec4\u4e0d\u5b58\u5728");
            }
            if (tempGroup.getPersonList().size() > 0) {
                throw new Exception("\u5220\u9664\u5206\u7ec4\u5f02\u5e38\uff1a\u5206\u7ec4\u4e0b\u6709\u4eba\u5458\uff0c\u7981\u6b62\u5220\u9664");
            }
            this.groupManageService.deleteGroupById(id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u5220\u9664\u5206\u7ec4\u51fa\u73b0\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/GroupManageControler/getGroupPersonList.do"})
    public void getGroupPersonList(HttpServletRequest request, HttpServletResponse response, String id) {
        try {
            List<Person> list = this.groupManageService.queryGroupMember(id);
            request.setAttribute("personList", list);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            log.error("\u83b7\u53d6\u5206\u7ec4\u4eba\u5458\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u5206\u7ec4\u4eba\u5458\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
    }

    @RequestMapping(value={"/bims/GroupManageControler/toGroupMember.do"})
    public String toGroupMember(HttpServletRequest request, HttpServletResponse response, String maxCount, ModelMap map) {
        ArrayList list = (ArrayList)request.getAttribute("personList");
        String filterPersonIds = (String)request.getAttribute("filterPersonIds");
        if (list == null) {
            list = new ArrayList();
        }
        map.put((Object)"personList", list);
        int i_maxCount = 100;
        if (StringUtils.isNotBlank((CharSequence)maxCount)) {
            try {
                i_maxCount = Integer.parseInt(maxCount);
            }
            catch (NumberFormatException e) {
                log.error("\u6253\u5f00\u5206\u7ec4\u6210\u5458\u5217\u8868\u9875\u9762\u5f02\u5e38", (Throwable)e);
            }
        }
        map.put((Object)"maxCount", (Object)i_maxCount);
        StringBuffer personStrList = new StringBuffer("#");
        StringBuffer nowShowPersonStrList = new StringBuffer("#");
        HashMap personMapAll = new HashMap();
        ArrayList personMapList = new ArrayList();
        int i = 0;
        for (Person person : list) {
            HashMap<String, String> personMap = new HashMap<String, String>();
            personMap.put("id", person.getId());
            personMap.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
            personMap.put("code", person.getCode());
            personMap.put("depName", person.getDepartment().getName());
            if (i < 10) {
                personMapList.add(personMap);
            } else {
                nowShowPersonStrList.append(person.getId()).append("#");
            }
            personMapAll.put(person.getId(), personMap);
            ++i;
            personStrList.append(person.getId()).append("#");
        }
        map.put((Object)"filterPersonIds", (Object)filterPersonIds);
        map.put((Object)"personListJson", (Object)Util.toJsonStr(personMapList));
        map.put((Object)"personStrList", (Object)personStrList);
        map.put((Object)"nowShowPersonStrList", (Object)nowShowPersonStrList);
        map.put((Object)"personMapAll", (Object)Util.toJsonStr(personMapAll));
        return "bims/groupManage/default/groupMember";
    }

    @RequestMapping(value={"/bims/GroupManageControler/toGroupMember1.do"})
    public String toGroupMember1(HttpServletRequest request, HttpServletResponse response, String maxCount, ModelMap map) {
        ArrayList list = (ArrayList)request.getAttribute("personList");
        List depList = (List)request.getAttribute("depList");
        if (list == null) {
            list = new ArrayList();
        }
        map.put((Object)"personList", list);
        map.put((Object)"depList", (Object)depList);
        int i_maxCount = 100;
        if (StringUtils.isNotBlank((CharSequence)maxCount)) {
            try {
                i_maxCount = Integer.parseInt(maxCount);
            }
            catch (NumberFormatException e) {
                log.error("\u6253\u5f00\u5206\u7ec4\u6210\u5458\u5217\u8868\u9875\u9762\u5f02\u5e38", (Throwable)e);
            }
        }
        map.put((Object)"maxCount", (Object)i_maxCount);
        StringBuffer personStrList = new StringBuffer("#");
        StringBuffer nowShowPersonStrList = new StringBuffer("#");
        ArrayList personMapList = new ArrayList();
        HashMap personMapAll = new HashMap();
        int i = 0;
        if (list != null && list.size() > 0) {
            for (Person person : list) {
                HashMap<String, String> personMap = new HashMap<String, String>();
                personMap.put("id", person.getId());
                personMap.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
                personMap.put("code", person.getCode());
                personMap.put("depName", person.getDepartment().getName());
                personMap.put("flag", "person");
                personMap.put("group", "\u4eba");
                personMapAll.put(person.getId(), personMap);
                if (i < 10) {
                    personMapList.add(personMap);
                } else {
                    nowShowPersonStrList.append(person.getId()).append("#");
                }
                ++i;
                personStrList.append(person.getId()).append("#");
            }
        }
        StringBuffer depStrList = new StringBuffer("#");
        if (depList != null && depList.size() > 0) {
            for (Department dep : depList) {
                HashMap<String, String> depMap = new HashMap<String, String>();
                depMap.put("id", dep.getId());
                depMap.put("name", dep.getName());
                depMap.put("code", dep.getCode());
                depMap.put("depName", dep.getName());
                depMap.put("flag", "dep");
                depMap.put("group", "\u5355\u4f4d");
                personMapList.add(depMap);
                depStrList.append(dep.getId()).append("#");
            }
        }
        map.put((Object)"personListJson", (Object)Util.toJsonStr(personMapList));
        map.put((Object)"personStrList", (Object)personStrList);
        map.put((Object)"depStrList", (Object)depStrList);
        map.put((Object)"nowShowPersonStrList", (Object)nowShowPersonStrList);
        map.put((Object)"personMapAll", (Object)Util.toJsonStr(personMapAll));
        return "bims/groupManage/default/groupMember1";
    }

    @RequestMapping(value={"/bims/GroupManageControler/toGroupMemberDepPerson.do"})
    public String toGroupMemberDepPerson(HttpServletRequest request, HttpServletResponse response, String maxCount, ModelMap map) {
        ArrayList list = (ArrayList)request.getAttribute("personList");
        List depList = (List)request.getAttribute("depList");
        String tab = (String)request.getAttribute("tab");
        if (list == null) {
            list = new ArrayList();
        }
        map.put((Object)"personList", list);
        map.put((Object)"depList", (Object)depList);
        int i_maxCount = 100;
        if (StringUtils.isNotBlank((CharSequence)maxCount)) {
            try {
                i_maxCount = Integer.parseInt(maxCount);
            }
            catch (NumberFormatException e) {
                log.error("\u6253\u5f00\u5206\u7ec4\u6210\u5458\u5217\u8868\u9875\u9762\u5f02\u5e38", (Throwable)e);
            }
        }
        map.put((Object)"maxCount", (Object)i_maxCount);
        StringBuffer personStrList = new StringBuffer("#");
        StringBuffer nowShowPersonStrList = new StringBuffer("#");
        ArrayList personMapList = new ArrayList();
        HashMap personMapAll = new HashMap();
        int i = 0;
        if (list != null && list.size() > 0) {
            for (Person person : list) {
                HashMap<String, String> personMap = new HashMap<String, String>();
                personMap.put("id", person.getId());
                personMap.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
                personMap.put("code", person.getCode());
                personMap.put("depName", person.getDepartment().getName());
                personMap.put("flag", "person");
                personMap.put("group", "\u4eba");
                personMapAll.put(person.getId(), personMap);
                if (i < 10) {
                    personMapList.add(personMap);
                } else {
                    nowShowPersonStrList.append(person.getId()).append("#");
                }
                ++i;
                personStrList.append(person.getId()).append("#");
            }
        }
        StringBuffer depStrList = new StringBuffer("#");
        if (depList != null && depList.size() > 0) {
            for (Department dep : depList) {
                HashMap<String, String> depMap = new HashMap<String, String>();
                depMap.put("id", dep.getId());
                depMap.put("name", dep.getName());
                depMap.put("code", dep.getCode());
                depMap.put("depName", dep.getName());
                depMap.put("flag", "dep");
                depMap.put("group", "\u5355\u4f4d");
                personMapList.add(depMap);
                depStrList.append(dep.getId()).append("#");
            }
        }
        map.put((Object)"personListJson", (Object)Util.toJsonStr(personMapList));
        map.put((Object)"personStrList", (Object)personStrList);
        map.put((Object)"depStrList", (Object)depStrList);
        map.put((Object)"nowShowPersonStrList", (Object)nowShowPersonStrList);
        map.put((Object)"personMapAll", (Object)Util.toJsonStr(personMapAll));
        map.put((Object)"tab", (Object)(StringUtils.isNotBlank((CharSequence)tab) ? tab : "DepPerson"));
        return "bims/groupManage/default/groupMemberDepPerson";
    }

    @RequestMapping(value={"/bims/GroupManageControler/toGroupMemberNew.do"})
    public String toGroupMemberNew(HttpServletRequest request, HttpServletResponse response, String maxCount, ModelMap map) {
        ArrayList list = (ArrayList)request.getAttribute("personList");
        if (list == null) {
            list = new ArrayList();
        }
        map.put((Object)"personList", list);
        int i_maxCount = 100;
        if (StringUtils.isNotBlank((CharSequence)maxCount)) {
            try {
                i_maxCount = Integer.parseInt(maxCount);
            }
            catch (NumberFormatException e) {
                log.error("\u6253\u5f00\u5206\u7ec4\u6210\u5458\u5217\u8868\u9875\u9762\u5f02\u5e38", (Throwable)e);
            }
        }
        map.put((Object)"maxCount", (Object)i_maxCount);
        StringBuffer personStrList = new StringBuffer("#");
        StringBuffer nowShowPersonStrList = new StringBuffer("#");
        StringBuffer depStrList = new StringBuffer("#");
        StringBuffer personTypeStrList = new StringBuffer("#");
        StringBuffer sexStrList = new StringBuffer("#");
        StringBuffer policeStrList = new StringBuffer("#");
        HashMap personMapAll = new HashMap();
        int i = 0;
        ArrayList personMapList = new ArrayList();
        for (Person person : list) {
            HashMap<String, String> personMap = new HashMap<String, String>();
            if ("person".equals(person.getFlag())) {
                personMap.put("id", person.getId());
                personMap.put("name", person.getName());
                personMap.put("code", person.getCode());
                personMap.put("flag", person.getFlag());
                if (i < 10) {
                    personMapList.add(personMap);
                } else {
                    nowShowPersonStrList.append(person.getId()).append("#");
                }
                ++i;
                personStrList.append(person.getId()).append("#");
                personMapAll.put(person.getId(), personMap);
                continue;
            }
            personMap.put("id", person.getId());
            personMap.put("name", person.getName());
            personMap.put("code", person.getCode());
            personMap.put("flag", person.getFlag());
            personMapList.add(personMap);
            if ("dep".equals(person.getFlag())) {
                depStrList.append(person.getId()).append("#");
                continue;
            }
            if ("police".equals(person.getFlag())) {
                policeStrList.append(person.getCode()).append("#");
                continue;
            }
            if ("sex".equals(person.getFlag())) {
                sexStrList.append(person.getCode()).append("#");
                continue;
            }
            if (!"PERSON_TYPE".equals(person.getFlag())) continue;
            personTypeStrList.append(person.getCode()).append("#");
        }
        map.put((Object)"personListJson", (Object)Util.toJsonStr(personMapList));
        map.put((Object)"personStrList", (Object)personStrList);
        map.put((Object)"depStrList", (Object)depStrList);
        map.put((Object)"policeStrList", (Object)policeStrList);
        map.put((Object)"sexStrList", (Object)sexStrList);
        map.put((Object)"personTypeStrList", (Object)personTypeStrList);
        map.put((Object)"nowShowPersonStrList", (Object)nowShowPersonStrList);
        map.put((Object)"personMapAll", (Object)Util.toJsonStr(personMapAll));
        map.put((Object)"personListJson", (Object)Util.toJsonStr(personMapList));
        return "bims/groupManage/default/groupMemberNew";
    }

    @RequestMapping(value={"/bims/GroupManageControler/saveGroupMember.do"})
    public void saveGroupMember(HttpServletRequest request, HttpServletResponse response, ModelMap map, String personIds, String groupId) {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            String[] idArray = personIds.split(",");
            this.groupManageService.updateGroupMember(groupId, idArray);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            operateResult = 0;
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u5206\u7ec4\u6210\u5458\u66f4\u65b0\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38");
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }
}

