/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.control;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.bims.bean.PersonTmpBean;
import com.xdja.pams.bims.entity.PersonTmp;
import com.xdja.pams.bims.service.PersonTmpService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.FastDfsUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
public class PersonTmpControler
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private PersonTmpService personTmpService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private FastDfsUtils fastDfsUtils;
    private static final Logger log = LoggerFactory.getLogger(PersonTmpControler.class);

    @RequestMapping(value={"/bims/PersonTmpControler/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            Operator operator = this.getOperator(request);
            request.setAttribute("personId", (Object)operator.getPerson().getId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        return sendUrl;
    }

    @RequestMapping(value={"/bims/PersonTmpControler/queryList.do"})
    public void queryDepList(HttpServletRequest request, HttpServletResponse response, ModelMap map, PersonTmpBean bean, PageParam pageParam) {
        boolean operateResult = true;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(pageParam.getPage()), Integer.parseInt(pageParam.getRows()));
            String controlDeps = this.getControlDeps(request);
            bean.setControlDeps(controlDeps);
            List<PersonTmpBean> list = this.personTmpService.queryBeanList(bean, page);
            result.put("rows", list);
            result.put("total", page.getTotal());
            log.info(Util.toJsonStr(result));
        }
        catch (Exception e) {
            operateResult = false;
            log.error("\u83b7\u53d6\u5355\u4f4d\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/bims/PersonTmpControler/toAdd.do"})
    public String toAdd(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        PersonTmpBean person = new PersonTmpBean();
        map.put((Object)"person", (Object)person);
        return "bims/personTmp/default/addOrEdit";
    }

    @RequestMapping(value={"/bims/PersonTmpControler/save.do"})
    public void save(HttpServletRequest request, HttpServletResponse response, PersonTmp personTmp) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            personTmp.setCreatorId(this.person.getId());
            this.personTmpService.save(personTmp);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u9884\u5f55\u5165\u8b66\u5458\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/PersonTmpControler/toEdit.do"})
    public String toEdit(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String approveFlag) {
        PersonTmpBean personTmp = this.personTmpService.getBeanById(id);
        map.put((Object)"person", (Object)personTmp);
        map.put((Object)"approveFlag", (Object)approveFlag);
        return "bims/personTmp/default/addOrEdit";
    }

    @RequestMapping(value={"/bims/PersonTmpControler/update.do"})
    public void update(HttpServletRequest request, HttpServletResponse response, PersonTmp personTmp) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            personTmp.setCreatorId(this.person.getId());
            this.personTmpService.update(personTmp);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u9884\u5f55\u5165\u8b66\u5458\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/PersonTmpControler/delete.do"})
    public void delete(HttpServletRequest request, HttpServletResponse response, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.personTmpService.delete(id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u9884\u5f55\u5165\u8b66\u5458\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/PersonTmpControler/approve.do"})
    public void approve(HttpServletRequest request, HttpServletResponse response, PersonTmp personTmp) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            rtnResult = this.personTmpService.approve(personTmp);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u9884\u5f55\u5165\u8b66\u5458\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/PersonTmpControler/approveBatch.do"})
    public void approveBatch(HttpServletRequest request, HttpServletResponse response, String ids, String approvalState) {
        ReturnResult rtnResult = new ReturnResult();
        HashMap<String, ReturnResult> batchRst = new HashMap<String, ReturnResult>();
        try {
            String[] idArr;
            for (String id : idArr = ids.split(",")) {
                ReturnResult rst = null;
                try {
                    PersonTmp personTmp = new PersonTmp();
                    personTmp.setId(id);
                    personTmp.setApprovalState(approvalState);
                    rst = this.personTmpService.approve(personTmp);
                }
                catch (Exception e) {
                    log.error("\u4fee\u6539\u9884\u5f55\u5165\u8b66\u5458\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                    rst = new ReturnResult();
                    rtnResult.setRtnCode("1");
                    rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
                }
                batchRst.put(id, rst);
            }
            rtnResult.setData(batchRst);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u9884\u5f55\u5165\u8b66\u5458\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/bims/PersonTmpControler/uploadFile.do"})
    public void uploadFile(HttpServletRequest request, HttpServletResponse response, @RequestParam MultipartFile file) {
        ReturnResult rtnResult = new ReturnResult();
        InputStream input = null;
        FileOutputStream output = null;
        try {
            if ("0".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
                int bytesRead;
                String path = this.systemConfigService.getValueByCode("PERSON_TMP_ENCLOSURE_PATH");
                String filename = UUID.randomUUID().toString().replaceAll("\\-", "");
                String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
                String newFilePath = path + File.separator + filename + "." + extension;
                File filePath = new File(path);
                if (!filePath.exists()) {
                    filePath.mkdirs();
                }
                input = file.getInputStream();
                output = new FileOutputStream(newFilePath);
                byte[] buf = new byte[1024];
                while ((bytesRead = input.read(buf)) > 0) {
                    ((OutputStream)output).write(buf, 0, bytesRead);
                }
                try {
                    input.close();
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                rtnResult.setData(newFilePath);
            } else {
                String fileId = this.fastDfsUtils.uploadToFASTDFS(file.getBytes(), file.getOriginalFilename());
                rtnResult.setData(fileId);
            }
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/bims/PersonTmpControler/downloadFile.do"})
    public void download(HttpServletRequest request, HttpServletResponse response, String filepath) {
        File file = null;
        ServletOutputStream os = null;
        BufferedInputStream fin = null;
        try {
            os = response.getOutputStream();
            if ("0".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
                file = new File(filepath);
                if (file.exists()) {
                    fin = new BufferedInputStream(new FileInputStream(file));
                    if (fin != null) {
                        byte[] b = new byte[2048];
                        int i = 0;
                        while ((i = fin.read(b)) > 0) {
                            os.write(b, 0, i);
                        }
                    }
                    os.flush();
                    os.close();
                    fin.close();
                    os = null;
                    fin = null;
                }
            } else {
                byte[] bytes = this.fastDfsUtils.downloadFromFASTDFS(filepath);
                os.write(bytes);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (fin != null) {
                    fin.close();
                }
                file = null;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

