/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.dao.impl;

import com.xdja.pams.bims.bean.PersonTmpBean;
import com.xdja.pams.bims.dao.PersonTmpDao;
import com.xdja.pams.bims.entity.PersonTmp;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PersonTmpDaoImpl
implements PersonTmpDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public void save(PersonTmp entity) {
        this.baseDao.create(entity);
    }

    @Override
    public void update(PersonTmp entity) {
        this.baseDao.update(entity);
    }

    @Override
    public void delete(String id) {
        PersonTmp entity = this.getById(id);
        if (entity != null) {
            this.baseDao.delete(entity);
        }
    }

    @Override
    public PersonTmp getById(String id) {
        return (PersonTmp)this.baseDao.getObjectById(PersonTmp.class, (Serializable)((Object)id));
    }

    @Override
    public List<PersonTmp> queryList(PersonTmpBean bean, Page page) {
        StringBuilder selectb = new StringBuilder("from t_person_tmp where 1=1");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)bean.getCode())) {
            selectb.append(" and code like ?");
            params.add("%" + bean.getCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)bean.getName())) {
            selectb.append(" and name like ?");
            params.add("%" + bean.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)bean.getPersonType())) {
            selectb.append(" and person_type = ?");
            params.add(bean.getPersonType());
        }
        if (StringUtils.isNotBlank((CharSequence)bean.getApprovalState())) {
            selectb.append(" and APPROVAL_STATE = ?");
            params.add(bean.getApprovalState());
        }
        if (StringUtils.isNotBlank((CharSequence)bean.getDepId())) {
            // empty if block
        }
        if (bean.getIsContain() != null && bean.getIsContain().contains("true")) {
            if (StringUtils.isNotBlank((CharSequence)bean.getDepId())) {
                selectb.append("and dep_Id in (select id from t_department connect by prior id = parent_id start with id = '" + bean.getDepId() + "')");
            } else {
                selectb.append("and dep_id in (" + BimsUtil.getChildDepsSql(bean.getControlDeps()) + ")");
            }
        } else if (StringUtils.isNotBlank((CharSequence)bean.getDepId())) {
            selectb.append("and dep_Id = '" + bean.getDepId() + "' ");
        } else {
            selectb.append("and dep_id in (" + BimsUtil.getChildDepsSql(bean.getControlDeps()) + ")");
        }
        String sqlCount = "select count(1) " + selectb.toString();
        String sql = "select * " + selectb.toString();
        return this.baseDao.getListBySQL(sqlCount, sql, params.toArray(), page, PersonTmp.class);
    }

    private List<PersonTmp> getByCodeOrMobileOrIdentifier(String code, String mobile, String identifier, String id) {
        String sql = "select * from t_person_tmp where APPROVAL_STATE <> '1'";
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            sql = sql + " and code = ?";
            params.add(code);
        }
        if (StringUtils.isNotBlank((CharSequence)identifier)) {
            sql = sql + " and identifier = ?";
            params.add(identifier);
        }
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            sql = sql + " and mobile = ?";
            params.add(mobile);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            sql = sql + " and id <> ?";
            params.add(id);
        }
        return this.baseDao.getListBySQL(sql, params.toArray(), PersonTmp.class);
    }

    @Override
    public List<PersonTmp> getByCode(String code) {
        return this.getByCodeOrMobileOrIdentifier(code, null, null, null);
    }

    @Override
    public List<PersonTmp> getByMobile(String mobile) {
        return this.getByCodeOrMobileOrIdentifier(null, mobile, null, null);
    }

    @Override
    public List<PersonTmp> getByIdentifier(String identifier) {
        return this.getByCodeOrMobileOrIdentifier(null, null, identifier, null);
    }

    @Override
    public boolean checkCode(String code, String id) {
        List<PersonTmp> list = this.getByCodeOrMobileOrIdentifier(code, null, null, id);
        return !list.isEmpty();
    }

    @Override
    public boolean checkMobile(String mobile, String id) {
        List<PersonTmp> list = this.getByCodeOrMobileOrIdentifier(null, mobile, null, id);
        return !list.isEmpty();
    }

    @Override
    public boolean checkIdentifier(String identifier, String id) {
        List<PersonTmp> list = this.getByCodeOrMobileOrIdentifier(null, null, identifier, id);
        return !list.isEmpty();
    }
}

