/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.basedao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.stereotype.Repository;

@Repository
public class BaseDaoImpl
extends HibernateDaoSupport
implements BaseDao {
    @Autowired
    protected DataSource dynamicDataSource;
    protected JdbcTemplate jdbcTemplate;
    private static final Logger log = LoggerFactory.getLogger(BaseDaoImpl.class);

    @Autowired
    private void setSessionFactory2(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
        this.jdbcTemplate = new JdbcTemplate(this.dynamicDataSource);
    }

    @Override
    public Serializable create(Object entity) {
        return this.getHibernateTemplate().save(entity);
    }

    @Override
    public void saveOrUpdate(Object entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    @Override
    public void delete(Object entity) {
        this.getHibernateTemplate().delete(entity);
    }

    @Override
    public void update(Object entity) {
        this.getHibernateTemplate().update(entity);
    }

    @Override
    public void merge(Object o) {
        this.getHibernateTemplate().merge(o);
    }

    @Override
    public List<?> getListByHQL(String selectCount, String select, Object[] values, Page page) {
        if (selectCount != null && !selectCount.equals("") && page != null) {
            Long count = (Long)this.getObjectByHQL(selectCount, values);
            page.setTotal(count.intValue());
            if (page.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        return this.getListByHQL(select, values, page);
    }

    private List<?> getListByHQL(final String select, final Object[] values, final Page page) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(select);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                if (page != null) {
                    return query.setFirstResult(page.getFirstResult()).setMaxResults(page.getRp()).list();
                }
                return query.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(selectCallback);
        return list;
    }

    @Override
    public List<?> getListByHQLAsCache(String select, Object[] values) {
        return this.getListByHQLAsCache(select, values, null);
    }

    private List<?> getListByHQLAsCache(final String select, final Object[] values, final Page page) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(select);
                query.setCacheable(true);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                if (page != null) {
                    return query.setFirstResult(page.getFirstResult()).setMaxResults(page.getRp()).list();
                }
                return query.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(selectCallback);
        return list;
    }

    @Override
    public List<?> getListByHQL(String select, Object[] values) {
        return this.getListByHQL(select, values, null);
    }

    @Override
    public Object getObjectByHQL(final String select, final Object[] values) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(select);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return query.uniqueResult();
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public Object getObjectByHQLAsCache(final String select, final Object[] values) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(select);
                query.setCacheable(true);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return query.uniqueResult();
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public Object getObjectByCriteria(final DetachedCriteria dc) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Criteria criteria = dc.getExecutableCriteria(session);
                return criteria.uniqueResult();
            }
        };
        return this.getHibernateTemplate().execute(callback);
    }

    @Override
    public List<?> getListByCriteria(final DetachedCriteria dc, String orderBy, final Page page) {
        if (page != null) {
            dc.setProjection(Projections.rowCount());
            int i = Integer.parseInt(this.getObjectByCriteria(dc).toString());
            page.setTotal(i);
            if (page.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        if (orderBy != null) {
            String[] aOrderBys = orderBy.trim().split(",");
            for (int i = 0; i < aOrderBys.length; ++i) {
                String[] aOrderBy = aOrderBys[i].trim().split(" ");
                if (StringUtils.isBlank((CharSequence)aOrderBy[0])) continue;
                if (aOrderBy.length > 1) {
                    if (aOrderBy[1].equalsIgnoreCase("desc")) {
                        dc.addOrder(Property.forName((String)aOrderBy[0]).desc());
                        continue;
                    }
                    dc.addOrder(Property.forName((String)aOrderBy[0]).asc());
                    continue;
                }
                dc.addOrder(Property.forName((String)aOrderBy[0]).asc());
            }
        }
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Criteria criteria = dc.getExecutableCriteria(session);
                criteria.setProjection(null);
                if (page != null) {
                    criteria.setFirstResult(page.getFirstResult()).setMaxResults(page.getRp()).setFetchSize(page.getRp());
                }
                return criteria.list();
            }
        };
        List list = (List)this.getHibernateTemplate().execute(callback);
        return list;
    }

    @Override
    public List<?> getListBySQL(String selectCount, String select, Object[] values, Page page, Class<?> c) {
        if (selectCount != null && !selectCount.equals("") && page != null) {
            String count = this.getObjectBySQL(selectCount, values).toString();
            page.setTotal(Integer.parseInt(count));
            if (page.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        return this.getListBySQL(select, values, page, c);
    }

    @Override
    public List<?> getListBySQL(String selectCount, String select, Object[] values, Page page, Class<?> c, List<String> nameKeys) {
        if (selectCount != null && !selectCount.equals("") && page != null) {
            String count = this.getObjectBySQL(selectCount, values, nameKeys).toString();
            page.setTotal(Integer.parseInt(count));
            if (page.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        return this.getListBySQL(select, values, page, c, nameKeys);
    }

    private Object getObjectBySQL(final String select, final Object[] values, final List<String> nameKeys) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query = session.createSQLQuery(select);
                if (values != null) {
                    int m = 0;
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList((String)nameKeys.get(m++), (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                return query.uniqueResult();
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }

    private List<?> getListBySQL(final String select, final Object[] values, final Page page, final Class<?> c, final List<String> nameKeys) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query;
                if (c == null) {
                    query = session.createSQLQuery(select);
                } else {
                    Map map = session.getSessionFactory().getAllClassMetadata();
                    if (map.containsKey(c.getName())) {
                        query = session.createSQLQuery(select).addEntity(c);
                    } else {
                        Object resultTransformer = null;
                        resultTransformer = c.isAssignableFrom(HashMap.class) ? Transformers.ALIAS_TO_ENTITY_MAP : Transformers.aliasToBean((Class)c);
                        query = session.createSQLQuery(select).setResultTransformer((ResultTransformer)resultTransformer);
                    }
                }
                if (values != null) {
                    int m = 0;
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList((String)nameKeys.get(m++), (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                if (page != null) {
                    return query.setFirstResult(page.getFirstResult()).setMaxResults(page.getRp()).list();
                }
                return query.list();
            }
        };
        return this.getHibernateTemplate().executeFind(selectCallback);
    }

    @Override
    public List<?> getListBySQL(final String select, final Object[] values, final Class<?> c, final List<String> nameKeys) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query;
                if (c == null) {
                    query = session.createSQLQuery(select);
                } else {
                    Map map = session.getSessionFactory().getAllClassMetadata();
                    if (map.containsKey(c.getName())) {
                        query = session.createSQLQuery(select).addEntity(c);
                    } else {
                        Object resultTransformer = null;
                        resultTransformer = c.isAssignableFrom(HashMap.class) ? Transformers.ALIAS_TO_ENTITY_MAP : Transformers.aliasToBean((Class)c);
                        query = session.createSQLQuery(select).setResultTransformer((ResultTransformer)resultTransformer);
                    }
                }
                if (values != null) {
                    int m = 0;
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList((String)nameKeys.get(m++), (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                return query.list();
            }
        };
        return this.getHibernateTemplate().executeFind(selectCallback);
    }

    @Override
    public List<?> getListBySQL(String select, Object[] values, Class<?> c) {
        return this.getListBySQL(select, values, null, c);
    }

    private List<?> getListBySQL(final String select, final Object[] values, final Page page, final Class<?> c) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query;
                if (c == null) {
                    query = session.createSQLQuery(select);
                } else {
                    Map map = session.getSessionFactory().getAllClassMetadata();
                    if (map.containsKey(c.getName())) {
                        query = session.createSQLQuery(select).addEntity(c);
                    } else {
                        Object resultTransformer = null;
                        resultTransformer = c.isAssignableFrom(HashMap.class) ? Transformers.ALIAS_TO_ENTITY_MAP : Transformers.aliasToBean((Class)c);
                        query = session.createSQLQuery(select).setResultTransformer((ResultTransformer)resultTransformer);
                    }
                }
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                if (page != null) {
                    return query.setFirstResult(page.getFirstResult()).setMaxResults(page.getRp()).list();
                }
                return query.list();
            }
        };
        return this.getHibernateTemplate().executeFind(selectCallback);
    }

    @Override
    public Object getObjectBySQL(final String select, final Object[] values) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query = session.createSQLQuery(select);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return query.uniqueResult();
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public Object getObjectById(Class<?> c, Serializable id) {
        return this.getHibernateTemplate().get(c, id);
    }

    @Override
    public Object updateBySql(final String sqlUpdate, final Object[] values) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query = session.createSQLQuery(sqlUpdate);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return new Integer(query.executeUpdate());
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public Object updateBySql(final String sqlUpdate, final Object[] values, final List<String> nameKeys) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query = session.createSQLQuery(sqlUpdate);
                if (values != null) {
                    int m = 0;
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList((String)nameKeys.get(m++), (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                return new Integer(query.executeUpdate());
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public List<?> getTopListByHQL(final String select, final Object[] values, final int topnum) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(select);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                if (topnum != -1) {
                    return query.setFirstResult(0).setMaxResults(topnum).list();
                }
                return query.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(selectCallback);
        return list;
    }

    @Override
    public String getSingleValue(String sqlString) {
        String rst = null;
        try {
            rst = (String)this.jdbcTemplate.queryForObject(sqlString, String.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return rst;
    }

    @Override
    public Object jdbcTemplateExcute(CallableStatementCreator csc, CallableStatementCallback<?> action) throws DataAccessException {
        return this.jdbcTemplate.execute(csc, action);
    }

    @Override
    public List<?> excuteProcedure(String sql) {
        log.info("Sql\u8bed\u53e5:" + sql);
        List list = (List)this.jdbcTemplate.execute(sql, (CallableStatementCallback)new CallableStatementCallback<Object>(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                cs.registerOutParameter(1, -10);
                cs.execute();
                ResultSet rs = (ResultSet)cs.getObject(1);
                List recordsList = BaseDaoImpl.this.getResultSet(rs);
                return recordsList;
            }
        });
        return list;
    }

    private List<Map<String, Object>> getResultSet(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int columnCount = rsmd.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    String columnName = rsmd.getColumnName(i + 1);
                    map.put(columnName, rs.getObject(i + 1));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> jdbcTemplateQureyForList(String sqlStr) throws RuntimeException {
        log.debug("@Sql\u8bed\u53e5:" + sqlStr);
        return this.jdbcTemplate.queryForList(sqlStr);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) {
        log.debug("@Sql\u8bed\u53e5:" + sql);
        return (T)this.jdbcTemplate.queryForObject(sql, requiredType, args);
    }

    @Override
    public void flushSession() {
        this.getSession().flush();
        this.getSession().clear();
    }

    @Override
    public Object createBatch(final List entitys) {
        int affectedRow = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                for (int i = 0; i < entitys.size(); ++i) {
                    session.save(entitys.get(i));
                    if (i % 100 != 0) continue;
                    session.flush();
                    session.clear();
                }
                session.flush();
                session.clear();
                return entitys.size();
            }
        });
        return affectedRow;
    }

    @Override
    public List<Map<String, String>> getColumnInfo(String tableName) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            SqlRowSet srcSqlRowSet = this.jdbcTemplate.queryForRowSet("SELECT * FROM " + tableName + " where rownum = 1");
            SqlRowSetMetaData sqlRowSetMetaData = srcSqlRowSet.getMetaData();
            int columnCount = sqlRowSetMetaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("columnName", sqlRowSetMetaData.getColumnName(i));
                map.put("dataType", sqlRowSetMetaData.getColumnTypeName(i));
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public Session getCurrentSession() {
        return this.getSessionFactory().getCurrentSession();
    }
}

