/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.filter;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoFilters
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SsoFilters.class);
    private String ssoLogoutUrl;

    public void destroy() {
        this.ssoLogoutUrl = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String url = httpRequest.getRequestURI();
        try {
            Util util = new Util();
            if (util.checkFilterUrl(url, "sso.not.Filter.url")) {
                request.getRequestDispatcher(url.substring(httpRequest.getContextPath().length())).forward(request, response);
                return;
            }
            TokenFactory tokenFactory = (TokenFactory)BeanUtils.getBean(TokenFactory.class);
            String ticket = CookieUtils.getCookie(httpRequest, "operator", String.class);
            Operator operator = (Operator)tokenFactory.getOperator().get(ticket);
            String casToken = CookieUtils.getCookie(httpRequest, "_const_cas_ticket_", String.class);
            if (url.contains("/login/loginControler/loginOut.do")) {
                if (StringUtils.isNotBlank((CharSequence)ticket)) {
                    CookieUtils.removeCookie(httpRequest, httpResponse, "operator");
                    tokenFactory.getOperator().invalidate(ticket);
                }
                if (operator != null) {
                    tokenFactory.getOperator().invalidate(operator.getPerson().getId());
                }
                if (StringUtils.isNotBlank((CharSequence)casToken)) {
                    tokenFactory.getOperator().invalidate("cas:assertion:" + casToken);
                    CookieUtils.removeCookie(httpRequest, httpResponse, "_const_cas_ticket_");
                }
                httpResponse.sendRedirect(this.ssoLogoutUrl);
                return;
            }
            request.setAttribute("isSSO", (Object)"true");
            String clusterSwitch = SystemConfig.getInstance().getString("cluster.switch");
            AssertionImpl assertion = (AssertionImpl)tokenFactory.getOperator().get("cas:assertion:" + casToken);
            this.setAssertion(httpRequest, (Assertion)assertion);
            if (operator == null || "1".equals(clusterSwitch) && assertion == null) {
                if (operator != null) {
                    CookieUtils.removeCookie(httpRequest, httpResponse, "operator");
                    tokenFactory.getOperator().invalidate(ticket);
                    tokenFactory.getOperator().invalidate(operator.getPerson().getId());
                }
                if (!url.contains("/login/loginControler/login.do") && !url.contains("/login/loginControler/loginOut.do")) {
                    boolean isAjaxReq = false;
                    String xmlhttpreq = httpRequest.getHeader("x-requested-with");
                    xmlhttpreq = xmlhttpreq != null ? xmlhttpreq.toUpperCase() : null;
                    isAjaxReq = "XMLHTTPREQUEST".equals(xmlhttpreq);
                    if (isAjaxReq) {
                        httpResponse.sendError(512);
                    } else {
                        httpResponse.sendRedirect(httpRequest.getContextPath() + "/login/loginControler/login.do");
                    }
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                tokenFactory.getOperator().delay(ticket);
                if ("1".equals(clusterSwitch) && StringUtils.isNotBlank((CharSequence)casToken)) {
                    tokenFactory.getOperator().delay("cas:assertion:" + casToken);
                }
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            log.error("#SSO\u8d44\u6e90\u62e6\u622a\u5931\u8d25", (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.ssoLogoutUrl = config.getInitParameter("logoutUrl");
    }

    private void setAssertion(HttpServletRequest request, Assertion redisAssertion) {
        if ("0".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
            return;
        }
        HttpSession session = request.getSession();
        Assertion sessionAssertion = (Assertion)session.getAttribute("_const_cas_assertion_");
        if (sessionAssertion == null && redisAssertion != null) {
            session.setAttribute("_const_cas_assertion_", (Object)redisAssertion);
        }
        if (redisAssertion == null && sessionAssertion != null) {
            session.removeAttribute("_const_cas_assertion_");
        }
    }
}

