/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.service.impl;

import com.xdja.pams.bims.bean.QueryDepBean;
import com.xdja.pams.bims.bean.QueryGroupBean;
import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.bean.TreeDep;
import com.xdja.pams.bims.bean.TreeNodeAttributes;
import com.xdja.pams.bims.bean.TreePerson;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.GroupManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.service.CommonTreeService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.rptms.bean.QueryReportTemplateBean;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.service.ReportManagerService;
import com.xdja.pams.rptms.service.ReportTemplateManageService;
import com.xdja.pams.scms.bean.FlowUser;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.upms.bean.QueryRoleBean;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.SysRoleService;
import com.xdja.pams.upms.service.TerminalRoleService;
import com.xdja.pams.upms.service.UserPowerService;
import com.xdja.pams.wfms.service.WorkflowManagerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class CommonTreeServiceImpl
implements CommonTreeService {
    @Autowired
    CommonCodeService commonCodeService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private DepManageService depService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private TerminalRoleService terminalRoleService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private GroupManageService groupManageService;
    @Autowired
    private UserPowerService userPowerService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private ReportManagerService reportManagerService;
    @Autowired
    private ReportTemplateManageService reportTemplateManageService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private WorkflowManagerService wms;
    private static final Logger log = LoggerFactory.getLogger(CommonTreeServiceImpl.class);

    @Override
    public List<Map<String, Object>> getChild(String type) {
        List<CommonCode> set = this.commonCodeService.queryByType(type);
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        for (CommonCode code : set) {
            if (!"1".equals(code.getStatus())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", code.getId());
            map.put("code", code.getCode());
            map.put("name", code.getName());
            map.put("note", code.getNote());
            listmap.add(map);
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getChild2(String type) {
        List<CommonCode> set = this.commonCodeService.queryByType(type);
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put("id", "");
        map0.put("code", "");
        map0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        map0.put("note", "");
        listmap.add(map0);
        for (CommonCode code : set) {
            if (!"1".equals(code.getStatus())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", code.getId());
            map.put("code", code.getCode());
            map.put("name", code.getName());
            map.put("note", code.getNote());
            listmap.add(map);
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getDepJson(String id, String controlDeps) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        if (id == null) {
            String[] contrlDepsArray;
            for (String ocntrlDepId : contrlDepsArray = controlDeps.split(",")) {
                Department dep = this.depService.queryDepById(ocntrlDepId);
                HashMap<String, Object> item = new HashMap<String, Object>();
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("code", dep.getCode());
                item.put("id", dep.getId());
                item.put("text", dep.getName());
                item.put("state", "closed");
                item.put("attributes", attr);
                items.add(item);
            }
        } else {
            Department dep2 = this.depService.queryDepById(id);
            for (Department depNode : dep2.getChildDeps()) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("code", depNode.getCode());
                item.put("id", depNode.getId());
                item.put("text", depNode.getName());
                item.put("state", "closed");
                item.put("attributes", attr);
                items.add(item);
            }
        }
        return items;
    }

    @Override
    public List<Map<String, Object>> getParentDepJson(String[] ids, String controlDeps) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        HashMap mapdeps = new HashMap();
        HashMap<String, Department> mapdep = new HashMap<String, Department>();
        String[] contrlDepsArray = controlDeps.split(",");
        if (ids == null) {
            for (String ocntrlDepId : contrlDepsArray) {
                Department dep = this.depService.queryDepById(ocntrlDepId);
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("id", dep.getId());
                item.put("text", dep.getName());
                if (dep.getChildDeps() != null && dep.getChildDeps().size() > 0) {
                    item.put("state", "closed");
                }
                items.add(item);
            }
        } else {
            block1: for (String id : ids) {
                Department dep2 = this.depService.queryDepById(id);
                ArrayList<Department> list = new ArrayList<Department>();
                while (dep2 != null) {
                    boolean flag = false;
                    for (String cId : contrlDepsArray) {
                        if (!dep2.getId().equals(cId)) continue;
                        mapdeps.put(id, list);
                        flag = true;
                        break;
                    }
                    if (flag) continue block1;
                    list.add(dep2);
                    if ((dep2 = dep2.getParentDep()) != null) continue;
                    mapdep.put(id, this.depService.queryDepById(id));
                }
            }
            for (String id : ids) {
                List list = (List)mapdeps.get(id);
                if (list == null) continue;
                for (Department dep : list) {
                    mapdep.put(dep.getId(), dep);
                }
            }
            for (String ocntrlDepId : contrlDepsArray) {
                Department dep = this.depService.queryDepById(ocntrlDepId);
                HashMap<String, Object> maptree = new HashMap<String, Object>();
                maptree.put("id", dep.getId());
                maptree.put("text", dep.getName());
                maptree.put("children", this.getChildDep(maptree, mapdep));
                maptree.put("state", "open");
                items.add(maptree);
            }
            for (Department dep : mapdep.values()) {
                HashMap<String, String> maptree = new HashMap<String, String>();
                maptree.put("id", dep.getId());
                maptree.put("text", dep.getName());
                items.add(maptree);
            }
        }
        return items;
    }

    @Override
    public List<Map<String, Object>> getParentDepPersonJson(String id, String controlDeps) {
        List list0;
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        HashMap mapdeps = new HashMap();
        HashMap<String, Department> mapdep = new HashMap<String, Department>();
        String[] contrlDepsArray = controlDeps.split(",");
        Person person = this.userManageService.queryPersonById(id);
        Department dep2 = person.getDepartment();
        ArrayList<Department> list = new ArrayList<Department>();
        while (dep2 != null) {
            boolean flag = false;
            for (String cId : contrlDepsArray) {
                if (!dep2.getId().equals(cId)) continue;
                mapdeps.put(person.getDepId(), list);
                flag = true;
                break;
            }
            if (flag) break;
            list.add(dep2);
            if ((dep2 = dep2.getParentDep()) != null) continue;
            mapdep.put(id, this.depService.queryDepById(id));
        }
        if ((list0 = (List)mapdeps.get(person.getDepId())) != null) {
            for (Department dep : list0) {
                mapdep.put(dep.getId(), dep);
            }
        }
        for (String ocntrlDepId : contrlDepsArray) {
            Department dep = this.depService.queryDepById(ocntrlDepId);
            HashMap<String, Object> maptree = new HashMap<String, Object>();
            maptree.put("id", dep.getId());
            maptree.put("text", dep.getName());
            maptree.put("children", this.getChildDepPerson(maptree, mapdep));
            maptree.put("state", "open");
            TreeNodeAttributes depNodeAttributs = new TreeNodeAttributes();
            depNodeAttributs.setNodeType("dep");
            depNodeAttributs.setPersonCode(dep.getCode());
            maptree.put("attributes", depNodeAttributs);
            items.add(maptree);
        }
        for (Department dep : mapdep.values()) {
            HashMap<String, Object> maptree = new HashMap<String, Object>();
            maptree.put("id", dep.getId());
            maptree.put("text", dep.getName());
            maptree.put("children", this.getChildDepPerson(maptree, mapdep));
            items.add(maptree);
        }
        return items;
    }

    @Override
    public List<Map<String, Object>> getChildDep(Map<String, Object> map, Map<String, Department> mapdep) {
        Department dep = this.depService.queryDepById((String)map.get("id"));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (dep.getChildDeps() != null) {
            for (Department cdep : dep.getChildDeps()) {
                HashMap<String, Object> cmap = new HashMap<String, Object>();
                cmap.put("id", cdep.getId());
                cmap.put("text", cdep.getName());
                if (mapdep.get(cdep.getId()) != null) {
                    mapdep.remove(cdep.getId());
                    cmap.put("children", this.getChildDep(cmap, mapdep));
                    cmap.put("state", "open");
                } else {
                    cmap.put("state", "closed");
                }
                list.add(cmap);
            }
        }
        return list;
    }

    public List<Map<String, Object>> getChildDepPerson(Map<String, Object> map, Map<String, Department> mapdep) {
        Department dep = this.depService.queryDepById((String)map.get("id"));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (dep.getChildDeps() != null) {
            for (Department cdep : dep.getChildDeps()) {
                HashMap<String, Object> cmap = new HashMap<String, Object>();
                cmap.put("id", cdep.getId());
                cmap.put("text", cdep.getName());
                TreeNodeAttributes depNodeAttributs = new TreeNodeAttributes();
                depNodeAttributs.setNodeType("dep");
                depNodeAttributs.setPersonCode(dep.getCode());
                cmap.put("attributes", depNodeAttributs);
                if (mapdep.get(cdep.getId()) != null) {
                    mapdep.remove(cdep.getId());
                    cmap.put("children", this.getChildDepPerson(cmap, mapdep));
                    cmap.put("state", "open");
                } else {
                    cmap.put("state", "closed");
                }
                list.add(cmap);
                List<Person> personList = cdep.getPersonList();
            }
        }
        for (Person person : dep.getPersonList()) {
            HashMap<String, Object> item3 = new HashMap<String, Object>();
            item3.put("id", person.getId());
            item3.put("text", person.getName());
            TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
            nodeAttributs.setNodeType("person");
            nodeAttributs.setPersonName(person.getName());
            nodeAttributs.setPersonCode(person.getCode());
            nodeAttributs.setDepName(person.getDepartment().getName());
            nodeAttributs.setImei(this.getPersonImei(person.getId()));
            item3.put("attributes", nodeAttributs);
            item3.put("iconCls", "icon-person");
            list.add(item3);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryGroupListForSelect(String personId, QueryGroupBean groupBean, String controlDeps) {
        List<BimsGroup> groupList = this.groupManageService.queryGroupList(groupBean, controlDeps, null);
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        String canUseGroupIds = "";
        HashMap<String, String> groupMap0 = new HashMap<String, String>();
        groupMap0.put("id", "");
        groupMap0.put("code", "");
        groupMap0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        listmap.add(groupMap0);
        for (BimsGroup group : groupList) {
            HashMap<String, String> groupMap = new HashMap<String, String>();
            groupMap.put("id", group.getId());
            groupMap.put("code", group.getId());
            groupMap.put("name", group.getName());
            groupMap.put("depName", group.getDepartment().getName());
            groupMap.put("type", this.getGroupTypeName(group.getType()));
            groupMap.put("useFlag", "canUse");
            canUseGroupIds = canUseGroupIds + group.getId();
            listmap.add(groupMap);
        }
        if (personId != null && !"".equals(personId)) {
            Person person = this.userManageService.queryPersonById(personId);
            for (BimsGroup group : person.getGroupList()) {
                if (canUseGroupIds.indexOf(group.getId()) > -1) continue;
                HashMap<String, String> groupMap = new HashMap<String, String>();
                groupMap.put("id", group.getId());
                groupMap.put("code", group.getId());
                groupMap.put("name", group.getName());
                groupMap.put("depName", group.getDepartment().getName());
                groupMap.put("type", this.getGroupTypeName(group.getType()));
                groupMap.put("useFlag", "canNotUse");
                listmap.add(groupMap);
            }
        }
        return listmap;
    }

    private String getGroupTypeName(String groupType) {
        String[] typeArray = groupType.split(",");
        String typeNames = "";
        for (String type : typeArray) {
            typeNames = typeNames + this.commonCodePbService.getCodeNameByCode(type, "2044") + ",";
        }
        typeNames = typeNames.substring(0, typeNames.length() - 1);
        return typeNames;
    }

    @Override
    public List<Map<String, Object>> getGroupList(String id, QueryGroupBean groupBean, String controlDeps) {
        ArrayList<Map<String, Object>> listmap;
        block3: {
            block2: {
                listmap = new ArrayList<Map<String, Object>>();
                if (!StringUtils.isNotBlank((CharSequence)id)) break block2;
                BimsGroup group = this.groupManageService.queryGroupByID(id);
                if (group == null || group.getPersonList() == null) break block3;
                for (Person person : group.getPersonList()) {
                    HashMap<String, Object> item3 = new HashMap<String, Object>();
                    item3.put("id", person.getId());
                    item3.put("text", person.getName() + "-" + person.getCode());
                    TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
                    nodeAttributs.setNodeType("person");
                    nodeAttributs.setPersonName(person.getName());
                    nodeAttributs.setPersonCode(person.getCode());
                    nodeAttributs.setDepName(person.getDepartment().getName());
                    nodeAttributs.setImei(this.getPersonImei(person.getId()));
                    item3.put("attributes", nodeAttributs);
                    listmap.add(item3);
                }
                break block3;
            }
            List<BimsGroup> groupList = this.groupManageService.queryGroupList(groupBean, controlDeps, null);
            for (BimsGroup group : groupList) {
                HashMap<String, Object> groupMap = new HashMap<String, Object>();
                groupMap.put("id", group.getId());
                groupMap.put("text", group.getName());
                TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
                nodeAttributs.setNodeType("dep");
                groupMap.put("attributes", nodeAttributs);
                groupMap.put("state", "closed");
                listmap.add(groupMap);
            }
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getGroupListZT(String id, QueryGroupBean groupBean, String controlDeps) {
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        List<BimsGroup> groupList = this.groupManageService.queryGroupList(groupBean, controlDeps, null);
        for (BimsGroup group : groupList) {
            HashMap<String, String> groupMap = new HashMap<String, String>();
            groupMap.put("id", group.getId());
            groupMap.put("name", group.getName());
            groupMap.put("type", "group");
            groupMap.put("pId", null);
            listmap.add(groupMap);
            if (group == null || group.getPersonList() == null) continue;
            for (Person person : group.getPersonList()) {
                HashMap<String, String> item3 = new HashMap<String, String>();
                item3.put("id", person.getId());
                item3.put("name", person.getName());
                item3.put("code", person.getCode());
                item3.put("type", "person");
                item3.put("pId", group.getId());
                item3.put("iconSkin", "icon-person");
                listmap.add(item3);
            }
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getPersonTypeList(String id, String appId) {
        ArrayList<Map<String, Object>> listmap;
        block4: {
            block3: {
                listmap = new ArrayList<Map<String, Object>>();
                String result = "";
                Object appInfoList = null;
                Object appInfoPage = null;
                Object appInfo = null;
                Object app2PoliceList = null;
                List<CommonCode> list = this.commonCodeService.queryByTypeId("40288cde4b541981014b543c56c00046");
                if (!StringUtils.isNotBlank((CharSequence)id)) break block3;
                List<CommonCode> groupList = this.commonCodeService.queryByType(id);
                if (groupList == null || groupList.size() <= 0) break block4;
                for (CommonCode commonCode : groupList) {
                    HashMap<String, Object> item3 = new HashMap<String, Object>();
                    item3.put("id", commonCode.getCode());
                    item3.put("text", commonCode.getName());
                    TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
                    nodeAttributs.setNodeType("person");
                    nodeAttributs.setPersonName(id);
                    for (CommonCode commonCodeNew : list) {
                        if (!id.equals(commonCodeNew.getCode())) continue;
                        nodeAttributs.setDepName(commonCodeNew.getName());
                        break;
                    }
                    item3.put("attributes", nodeAttributs);
                    listmap.add(item3);
                }
                break block4;
            }
            List<CommonCode> groupList = this.commonCodeService.queryByType("personType");
            for (CommonCode commonCode : groupList) {
                HashMap<String, Object> groupMap = new HashMap<String, Object>();
                groupMap.put("id", commonCode.getCode());
                groupMap.put("text", commonCode.getName());
                TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
                nodeAttributs.setNodeType("dep");
                groupMap.put("attributes", nodeAttributs);
                groupMap.put("state", "closed");
                listmap.add(groupMap);
            }
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getPersonTypeListZT(String id, String appId) {
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        List<CommonCode> groupList = this.commonCodeService.queryByType("personType");
        for (CommonCode commonCode : groupList) {
            HashMap<String, String> groupMap = new HashMap<String, String>();
            groupMap.put("id", commonCode.getCode());
            groupMap.put("name", commonCode.getName());
            groupMap.put("code", commonCode.getCode());
            groupMap.put("type", commonCode.getCode() + "s");
            List<CommonCode> cCodes = this.commonCodeService.queryByType(commonCode.getCode());
            if (cCodes != null) {
                for (CommonCode cCode : cCodes) {
                    HashMap<String, String> codeMap = new HashMap<String, String>();
                    codeMap.put("id", cCode.getId());
                    codeMap.put("name", cCode.getName());
                    codeMap.put("code", cCode.getCode());
                    codeMap.put("pId", commonCode.getCode());
                    codeMap.put("type", commonCode.getCode());
                    listmap.add(codeMap);
                }
            }
            listmap.add(groupMap);
        }
        return listmap;
    }

    private String getPersonImei(String personId) {
        List<Device> devices = this.deviceService.getByPersonId(personId);
        String imei = "";
        for (Device device : devices) {
            if (!"3".equals(device.getType()) || !StringUtils.isNotBlank((CharSequence)device.getImei())) continue;
            imei = imei + device.getImei() + "#";
        }
        if (imei.endsWith("#")) {
            imei = imei.substring(0, imei.length() - 1);
        }
        return imei;
    }

    @Override
    public List<Map<String, Object>> getDepsJsonByName(String q, String limit, String controlDepsIds) {
        QueryDepBean queryDepBean = new QueryDepBean();
        queryDepBean.setName(q);
        Page page = new Page("1", limit);
        List<Department> depList = this.depManageService.queryDepList(queryDepBean, controlDepsIds, page);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Department dep : depList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("text", dep.getName());
            item.put("depId", dep.getId());
            mapList.add(item);
        }
        return mapList;
    }

    @Override
    public List<Map<String, Object>> getDepAndPersonJson(String id, String rootId, String controlDeps, String controlPolices) {
        ArrayList<Map<String, Object>> mapsList = new ArrayList<Map<String, Object>>();
        if (Util.varCheckEmp(id)) {
            id = rootId;
        }
        if (rootId != null) {
            Department dep = this.depManageService.queryDepById(id);
            HashMap<String, Object> item2 = new HashMap<String, Object>();
            item2.put("id", dep.getId());
            item2.put("text", dep.getName());
            TreeNodeAttributes depNodeAttributs = new TreeNodeAttributes();
            depNodeAttributs.setNodeType("dep");
            depNodeAttributs.setPersonCode(dep.getCode());
            item2.put("attributes", depNodeAttributs);
            item2.put("state", "open");
            QueryPersonBean queryBean = new QueryPersonBean();
            queryBean.setDepId(rootId);
            queryBean.setIsContain("true");
            List<Person> personList = this.userManageService.queryPersonList(queryBean, controlDeps, controlPolices, null);
            ArrayList personMapsList = new ArrayList();
            for (Person person : personList) {
                if (!this.userManageService.judgePerson(person.getPolice(), controlPolices)) continue;
                HashMap<String, Object> item3 = new HashMap<String, Object>();
                item3.put("id", person.getId());
                item3.put("text", person.getName());
                TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
                nodeAttributs.setNodeType("person");
                nodeAttributs.setPersonName(person.getName());
                nodeAttributs.setPersonCode(person.getCode());
                nodeAttributs.setDepName(person.getDepartment().getName());
                nodeAttributs.setImei(this.getPersonImei(person.getId()));
                item3.put("attributes", nodeAttributs);
                item3.put("iconCls", "icon-person");
                personMapsList.add(item3);
            }
            item2.put("children", personMapsList);
            mapsList.add(item2);
            return mapsList;
        }
        if (id == null) {
            String[] contrlDepsArray;
            for (String ocntrlDepId : contrlDepsArray = controlDeps.split(",")) {
                Department dep = this.depManageService.queryDepById(ocntrlDepId);
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", dep.getId());
                item.put("text", dep.getName());
                TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
                nodeAttributs.setNodeType("dep");
                nodeAttributs.setPersonCode(dep.getCode());
                item.put("attributes", nodeAttributs);
                if (dep.getPersonList() != null && !dep.getPersonList().isEmpty() || dep.getChildDeps() != null && !dep.getChildDeps().isEmpty()) {
                    item.put("state", "closed");
                }
                mapsList.add(item);
            }
        } else {
            TreeNodeAttributes nodeAttributs;
            Department dep = this.depManageService.queryDepById(id);
            List<Department> childrenDepList = dep.getChildDeps();
            List<Person> personList = dep.getPersonList();
            for (Department depNode : childrenDepList) {
                HashMap<String, Object> item2 = new HashMap<String, Object>();
                item2.put("id", depNode.getId());
                item2.put("text", depNode.getName());
                nodeAttributs = new TreeNodeAttributes();
                nodeAttributs.setNodeType("dep");
                nodeAttributs.setPersonCode(depNode.getCode());
                item2.put("attributes", nodeAttributs);
                if (depNode.getPersonList() != null && !depNode.getPersonList().isEmpty() || depNode.getChildDeps() != null && !depNode.getChildDeps().isEmpty()) {
                    item2.put("state", "closed");
                }
                mapsList.add(item2);
            }
            for (Person person : personList) {
                if (!this.userManageService.judgePerson(person.getPolice(), controlPolices)) continue;
                HashMap<String, Object> item3 = new HashMap<String, Object>();
                item3.put("id", person.getId());
                item3.put("text", person.getName());
                nodeAttributs = new TreeNodeAttributes();
                nodeAttributs.setNodeType("person");
                nodeAttributs.setPersonName(person.getName());
                nodeAttributs.setPersonCode(person.getCode());
                nodeAttributs.setDepName(person.getDepartment().getName());
                nodeAttributs.setImei(this.getPersonImei(person.getId()));
                item3.put("attributes", nodeAttributs);
                item3.put("iconCls", "icon-person");
                mapsList.add(item3);
            }
        }
        return mapsList;
    }

    @Override
    public List<Map<String, Object>> getDepAndPersonJsonZT(String id, String rootId, String controlDeps, String controlPolices) {
        HashMap<String, String> map;
        ArrayList<Map<String, Object>> mapsList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)rootId)) {
            controlDeps = rootId;
        }
        List<TreeDep> depList = this.depManageService.getTreeDep(controlDeps);
        List<TreePerson> personList = this.userManageService.queryTreePersonList(controlDeps, controlPolices);
        for (TreeDep dep : depList) {
            map = new HashMap<String, String>();
            map.put("id", dep.getId());
            map.put("name", dep.getName());
            map.put("pId", dep.getParentId());
            map.put("type", "dep");
            map.put("code", dep.getCode());
            mapsList.add(map);
        }
        for (TreePerson person : personList) {
            map = new HashMap();
            map.put("id", person.getId());
            if ("2".equals(person.getPersonType())) {
                // empty if block
            }
            if ("2".equals(person.getPersonType())) {
                // empty if block
            }
            map.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
            map.put("pId", person.getDepId());
            map.put("type", "person");
            map.put("iconSkin", "icon-person");
            map.put("code", person.getCode());
            mapsList.add(map);
        }
        return mapsList;
    }

    @Override
    public List<Map<String, Object>> getDepAndPersonJsonZT(String id, String rootId, String controlDeps, String controlPolices, String key, boolean isRetrunDep) {
        ArrayList<Map<String, Object>> mapsList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)rootId)) {
            controlDeps = rootId;
        }
        List<TreePerson> personList = this.userManageService.queryTreePersonList(controlDeps, controlPolices, key);
        if (isRetrunDep) {
            List<TreeDep> depList = this.depManageService.getTreeDep(controlDeps);
            for (TreeDep dep : depList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", dep.getId());
                map.put("name", dep.getName());
                map.put("pId", dep.getParentId());
                map.put("type", "dep");
                map.put("code", dep.getCode());
                map.put("orderField", dep.getOrderField());
                map.put("flag", dep.getFlag());
                mapsList.add(map);
            }
        }
        for (TreePerson person : personList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", person.getId());
            if ("2".equals(person.getPersonType())) {
                // empty if block
            }
            if ("2".equals(person.getPersonType())) {
                // empty if block
            }
            map.put("name", Util.cvNameByPersonType(person.getName(), person.getPersonType()));
            map.put("pId", person.getDepId());
            map.put("type", "person");
            map.put("iconSkin", "icon-person");
            map.put("code", person.getCode());
            map.put("mobile", person.getMobile());
            map.put("orderField", person.getOrderField());
            map.put("flag", person.getFlag());
            mapsList.add(map);
        }
        return mapsList;
    }

    @Override
    public List<Map<String, Object>> showWorkflowUserPage(FlowUser fu) {
        ArrayList<Map<String, Object>> mapsList = new ArrayList<Map<String, Object>>();
        if (fu != null) {
            List<Department> depList;
            List<Person> personList = this.userManageService.getWorkFlowUserList(fu.getGroupId(), fu.getPersonId(), fu.getPowerId(), fu.getDepId());
            if (personList != null && !personList.isEmpty()) {
                HashMap<String, Object> root = new HashMap<String, Object>();
                root.put("id", "root");
                root.put("text", "\u5168\u90e8\u5f85\u9009\u4eba\u5458");
                root.put("state", "open");
                ArrayList childrenList = new ArrayList();
                for (Person p : personList) {
                    HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                    tmpMap.put("id", p.getId());
                    tmpMap.put("text", p.getName() + "-" + p.getCode());
                    TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
                    nodeAttributs.setPersonName(p.getName());
                    nodeAttributs.setPersonCode(p.getCode());
                    nodeAttributs.setDepName(p.getDepartment().getName());
                    nodeAttributs.setNodeType("person");
                    tmpMap.put("attributes", nodeAttributs);
                    childrenList.add(tmpMap);
                }
                root.put("children", childrenList);
                mapsList.add(root);
            }
            if ((depList = this.wms.getWorkflowGroupById(fu.getGroupId()).getActIdDeps()) != null && !depList.isEmpty()) {
                HashMap<String, Object> root = new HashMap<String, Object>();
                root.put("id", "rootDep");
                root.put("text", "\u5168\u90e8\u5f85\u9009\u5355\u4f4d");
                root.put("state", "open");
                ArrayList childrenList = new ArrayList();
                for (Department p : depList) {
                    HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                    tmpMap.put("id", p.getId());
                    tmpMap.put("text", p.getName() + "-" + p.getCode());
                    TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
                    nodeAttributs.setPersonName(p.getName());
                    nodeAttributs.setPersonCode(p.getCode());
                    nodeAttributs.setNodeType("dep");
                    tmpMap.put("attributes", nodeAttributs);
                    childrenList.add(tmpMap);
                }
                root.put("children", childrenList);
                mapsList.add(root);
            }
        }
        return mapsList;
    }

    @Override
    public List<Map<String, Object>> getPersonsJsonByName(String q, String limit, String controlDepsIds, String controlPolices) {
        QueryPersonBean queryPersonBean = new QueryPersonBean();
        queryPersonBean.setName(q);
        Page page = new Page("1", limit);
        List<Person> personList = this.userManageService.queryPersonList(queryPersonBean, controlDepsIds, controlPolices, page);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Person person : personList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("text", person.getName());
            item.put("personId", person.getId());
            mapList.add(item);
        }
        return mapList;
    }

    @Override
    public List<Map<String, Object>> getPersonsJsonByCode(String q, String limit, String controlDepsIds, String controlPolices) {
        QueryPersonBean queryPersonBean = new QueryPersonBean();
        queryPersonBean.setCode(q);
        Page page = new Page("1", limit);
        List<Person> personList = this.userManageService.queryPersonList(queryPersonBean, controlDepsIds, controlPolices, page);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Person person : personList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("text", person.getName());
            item.put("personId", person.getId());
            mapList.add(item);
        }
        return mapList;
    }

    @Override
    public List<Map<String, Object>> getPersonsJsonByCodeOrName(String q, String limit, String controlDepsIds, String controlPolices) {
        Page page = new Page("1", limit);
        List<Person> personList = this.userManageService.queryPersonListByNameOrCode(q, controlDepsIds, controlPolices, page);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Person person : personList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("text", person.getName());
            item.put("personId", person.getId());
            mapList.add(item);
        }
        return mapList;
    }

    @Override
    public List<Map<String, Object>> getPersonJson(String name, String maxNum, String controlDepsIds, String controlPolices) {
        QueryPersonBean queryPersonBean = new QueryPersonBean();
        queryPersonBean.setName(name);
        List<Person> personList = this.userManageService.queryPersonList(queryPersonBean, controlDepsIds, controlPolices, new Page("1", maxNum));
        ArrayList<Map<String, Object>> mapsList = new ArrayList<Map<String, Object>>();
        for (Person person : personList) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", person.getId());
            item.put("text", person.getName() + "-" + person.getCode());
            TreeNodeAttributes nodeAttributs = new TreeNodeAttributes();
            nodeAttributs.setNodeType("person");
            nodeAttributs.setPersonName(person.getName());
            nodeAttributs.setPersonCode(person.getCode());
            nodeAttributs.setDepName(person.getDepartment().getName());
            nodeAttributs.setImei(this.getPersonImei(person.getId()));
            item.put("attributes", nodeAttributs);
            mapsList.add(item);
        }
        return mapsList;
    }

    @Override
    public List<Map<String, Object>> getPersonJsonZT(String name, String maxNum, String controlDepsIds, String controlPolices) {
        QueryPersonBean queryPersonBean = new QueryPersonBean();
        queryPersonBean.setName(name);
        List<Person> personList = this.userManageService.queryPersonList(queryPersonBean, controlDepsIds, controlPolices, new Page("1", maxNum));
        ArrayList<Map<String, Object>> mapsList = new ArrayList<Map<String, Object>>();
        for (Person person : personList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("id", person.getId());
            item.put("name", person.getName() + "-" + person.getCode());
            item.put("code", person.getCode());
            item.put("type", "person");
            item.put("iconSkin", "icon-person");
            mapsList.add(item);
        }
        return mapsList;
    }

    @Override
    public List<Map<String, Object>> getSysRoleList(String personId, String operatorId) {
        QueryRoleBean queryrolebean = new QueryRoleBean();
        queryrolebean.setCreator_id(operatorId);
        queryrolebean.setFlag("1");
        List<Role> rolelist = this.sysRoleService.queryRoleList(queryrolebean, null);
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        String canUseRoleIds = "";
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put("id", "");
        map0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        listmap.add(map0);
        for (Role role : rolelist) {
            if ("0".equals(role.getType())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", role.getId());
            map.put("name", role.getName());
            map.put("useFlag", "canUse");
            canUseRoleIds = canUseRoleIds + role.getId();
            listmap.add(map);
        }
        if (personId != null && !"".equals(personId)) {
            Person person = this.userManageService.queryPersonById(personId);
            for (Role role : person.getRoleList()) {
                if (role.getType().equals("2") || canUseRoleIds.indexOf(role.getId()) >= 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", role.getId());
                map.put("name", role.getName());
                map.put("useFlag", "canNotUse");
                listmap.add(map);
            }
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getTerminalRoleList(String personId, String operatorId) {
        QueryRoleBean queryrolebean = new QueryRoleBean();
        queryrolebean.setType("2");
        queryrolebean.setCreator_id(operatorId);
        queryrolebean.setFlag("1");
        List<Role> rolelist = this.terminalRoleService.queryRoleList(queryrolebean, null);
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        String canUseRoleIds = "";
        HashMap<String, String> map0 = new HashMap<String, String>();
        map0.put("id", "");
        map0.put("name", MessageManager.getProMessage(this.message, "commontree.commoncode.select"));
        listmap.add(map0);
        for (Role role : rolelist) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", role.getId());
            map.put("name", role.getName());
            map.put("useFlag", "canUse");
            canUseRoleIds = canUseRoleIds + role.getId();
            listmap.add(map);
        }
        if (personId != null && !"".equals(personId)) {
            Person person = this.userManageService.queryPersonById(personId);
            for (Role role : person.getRoleList()) {
                if (!role.getType().equals("2") || canUseRoleIds.indexOf(role.getId()) >= 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", role.getId());
                map.put("name", role.getName());
                map.put("useFlag", "canNotUse");
                listmap.add(map);
            }
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getBusinessReports() {
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("code", "");
        map2.put("name", "------\u8bf7\u9009\u62e9-----");
        listmap.add(map2);
        ReportBean reportBean = new ReportBean();
        List<ReportBean> reportList = this.reportManagerService.queryReportList(reportBean, null);
        for (ReportBean report : reportList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", report.getReportId());
            map.put("name", report.getReportName());
            listmap.add(map);
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getReportFiles() {
        ArrayList<Map<String, Object>> listmap = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "");
        map.put("name", "--\u8bf7\u9009\u62e9--");
        map.put("filePath", "");
        map.put("picturePath", "");
        listmap.add(map);
        QueryReportTemplateBean queryReportTemplateBean = new QueryReportTemplateBean();
        List<QueryReportTemplateBean> reportTemplateList = this.reportTemplateManageService.queryReportTemplateList(queryReportTemplateBean, null);
        for (QueryReportTemplateBean reportTemplate : reportTemplateList) {
            map = new HashMap();
            map.put("code", reportTemplate.getId());
            map.put("name", reportTemplate.getName());
            map.put("filePath", reportTemplate.getFilePath());
            map.put("picturePath", reportTemplate.getPicturePath());
            listmap.add(map);
        }
        return listmap;
    }

    @Override
    public List<Map<String, Object>> getDepJsonZT(String id, String controlDeps) {
        ArrayList<Map<String, Object>> mapsList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isBlank((CharSequence)controlDeps)) {
            controlDeps = "8888888888";
        }
        List<TreeDep> depList = this.depManageService.getTreeDep(controlDeps);
        for (TreeDep dep : depList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dep.getId());
            map.put("name", dep.getName());
            map.put("pId", dep.getParentId());
            map.put("type", "dep");
            map.put("code", dep.getCode());
            mapsList.add(map);
        }
        return mapsList;
    }

    @Override
    public String getCommonCodeByCodeUnderType(String type, String code) {
        CommonCode c = this.commonCodePbService.getByCode(code, type);
        if (c != null) {
            return c.getName();
        }
        return null;
    }
}

