/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.token.operator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xdja.pams.common.token.config.TokenConfig;
import com.xdja.pams.common.token.operator.AbstractTokenOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class MemoryTokenOperator
extends AbstractTokenOperator {
    private static LoadingCache<String, Object> CONTAINER;

    public MemoryTokenOperator(TokenConfig tokenConfig) {
        super(tokenConfig);
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.maximumSize(30000L);
        if (this.config.isAutoDelay()) {
            builder.expireAfterAccess(tokenConfig.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
        } else {
            builder.expireAfterWrite(tokenConfig.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
        }
        CONTAINER = builder.build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String key) {
                return null;
            }
        });
    }

    @Override
    public String add(Object value) {
        String key = this.config.getKeyGenerator().key();
        CONTAINER.put((Object)key, value);
        return key;
    }

    @Override
    public void add(String key, String value) {
        CONTAINER.put((Object)key, (Object)value);
    }

    @Override
    public String addEx(Object value, long timeout, TimeUnit unit) {
        String key = this.config.getKeyGenerator().key();
        CONTAINER.put((Object)key, value);
        return key;
    }

    @Override
    public void addEx(String key, String value, long timeout, TimeUnit unit) {
        CONTAINER.put((Object)key, (Object)value);
    }

    @Override
    public Object get(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        return CONTAINER.getIfPresent((Object)token);
    }

    @Override
    public List<Object> values() {
        return new ArrayList<Object>(CONTAINER.asMap().values());
    }

    @Override
    public Map<String, Object> all() {
        return CONTAINER.asMap();
    }

    @Override
    public boolean delay(String token) {
        try {
            CONTAINER.get((Object)token);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean invalidate(String token) {
        CONTAINER.invalidate((Object)token);
        return true;
    }

    @Override
    public void add(String key, Object o) {
        CONTAINER.put((Object)key, o);
    }
}

