/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.getwayapi.service.impl;

import com.xdja.pams.getwayapi.HttpServer;
import com.xdja.pams.getwayapi.service.OnlineService;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GatewayOnlineServiceImpl
implements InitializingBean,
DisposableBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpServer httpServer;
    @Resource
    private SystemConfigService systemConfigService;
    @Resource
    private OnlineService onlineService;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    public void afterPropertiesSet() throws Exception {
        SystemConfig monitorEnable = this.systemConfigService.getByCode("SYSCONF_GATEWAY_ONLINE_ENABLE");
        if (monitorEnable != null && "1".equals(monitorEnable.getValue())) {
            this.logger.info("\u542f\u7528 \u7f51\u5173\u5728\u7ebf\u4fe1\u606f\u76d1\u63a7\u670d\u52a1!");
            SystemConfig forwardEnable = this.systemConfigService.getByCode("SYSCONF_GATEWAY_ONLINE_FORWARD_ENABLE");
            this.logger.info("\u4e0d\u542f\u7528 \u5b89\u5168\u5361\u5728\u7ebf\u72b6\u6001\u8f6c\u53d1\u5904\u7406!");
            String url = this.systemConfigService.getValueByCode("SYSCONF_GATEWAY_ONLINE_FLOW_SERVICE_URL");
            this.httpServer = new HttpServer(url, this.onlineService);
            this.httpServer.startOnlineInfoListenServer();
            this.httpServer.startGetCurrentOnlineInfoTimer();
            this.logger.info("\u7f51\u5173\u5728\u7ebf\u4fe1\u606f\u76d1\u63a7\u670d\u52a1\u542f\u52a8\u6210\u529f!");
        } else {
            this.logger.info("\u4e0d\u542f\u7528 \u7f51\u5173\u5728\u7ebf\u4fe1\u606f\u76d1\u63a7\u670d\u52a1!");
        }
    }

    private void sendMessageToGatewayForGetOnlineInfo() {
        try {
            SystemConfig forwardUrl = this.systemConfigService.getByCode("SYSCONF_GATEWAY_ONLINE_FORWARD_URL");
            if (forwardUrl == null || !StringUtils.hasText((String)forwardUrl.getValue())) {
                throw new IllegalArgumentException("\u5b89\u5168\u5361\u5728\u7ebf\u72b6\u6001\u8f6c\u53d1\u5904\u7406\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            this.logger.info("1\u5206\u949f\u540e\u5411\u7f51\u5173\u53d1\u6d88\u606f\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u4fe1\u606f!");
            TimeUnit.MINUTES.sleep(1L);
            this.logger.info("\u5411\u7f51\u5173" + forwardUrl.getValue() + "\u53d1\u6d88\u606f\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u4fe1\u606f!");
            new HttpRequestUtil().post(forwardUrl.getValue(), "");
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u7f51\u5173\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u4fe1\u606f\u5931\u8d25!", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
        this.executorService.shutdownNow();
    }
}

