/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.lsbk.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.lsbk.bean.CarControlBean;
import com.xdja.pams.lsbk.entity.CarControl;
import com.xdja.pams.lsbk.service.CarControlService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class CarControlControler
extends BaseControler {
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private CarControlService carControlService;
    @Autowired
    CommonCodeService commonCodeService;
    @Autowired
    private ResourceBundleMessageSource message;
    private static final Logger log = LoggerFactory.getLogger(CarControlControler.class);

    @RequestMapping(value={"/lsbk/CarControlControler/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"person_id", (Object)this.person.getId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/lsbk/CarControlControler/list.do"})
    public void list(HttpServletRequest request, HttpServletResponse response, PageParam page, CarControlBean bean) {
        int operateResult = 1;
        try {
            Page p = new Page(page.getPage(), page.getRows());
            List<CarControl> list = this.carControlService.queryList(bean, p);
            ArrayList codelist = new ArrayList();
            for (CarControl person : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", person.getId());
                map.put("creatorid", person.getCreatorid());
                map.put("kssj", Util.getDate("yyyy-MM-dd", person.getKssj()));
                map.put("jssj", Util.getDate("yyyy-MM-dd", person.getJssj()));
                if (StringUtils.isNotBlank((CharSequence)person.getHpzl())) {
                    CommonCode code = this.commonCodeService.getByCode(person.getHpzl(), "hpzl");
                    map.put("hpzl", code.getName());
                } else {
                    map.put("hpzl", person.getHpzl());
                }
                map.put("hphm", person.getHphm());
                map.put("czfs", person.getCzfs());
                map.put("bksy", person.getBksy());
                map.put("sqr", person.getSqr());
                map.put("pzr", person.getPzr());
                map.put("status", person.getStatus());
                codelist.add(map);
            }
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("total", Integer.valueOf(p.getTotal()));
            map.put("rows", codelist);
            Util.writeUtf8Text(response, Util.toJsonStr(map));
        }
        catch (Exception e) {
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/lsbk/CarControlControler/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        CarControl person = this.carControlService.queryById(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", person.getId());
        map.put("creatorid", person.getCreatorid());
        map.put("pzrid", person.getPzrid());
        map.put("kssj", Util.getDate("yyyy-MM-dd", person.getKssj()));
        map.put("jssj", Util.getDate("yyyy-MM-dd", person.getJssj()));
        map.put("hpzl", person.getHpzl());
        map.put("hphm", person.getHphm());
        map.put("czfs", person.getCzfs());
        map.put("bksy", person.getBksy());
        map.put("sqr", person.getSqr());
        map.put("pzr", person.getPzr());
        map.put("status", person.getStatus());
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/lsbk/CarControlControler/forwardUpdatePage.do"})
    public String forwardUpdatePage(String id, ModelMap map) {
        map.put((Object)"id", (Object)id);
        return "lsbk/car/default/update";
    }

    @RequestMapping(value={"/lsbk/CarControlControler/forwardApplyPage.do"})
    public String forwardApplyPage(String id, ModelMap map) {
        map.put((Object)"id", (Object)id);
        map.put((Object)"pzrid", (Object)this.person.getId());
        map.put((Object)"pzr", (Object)this.person.getName());
        return "lsbk/car/default/apply";
    }

    @RequestMapping(value={"/lsbk/CarControlControler/forwardViewPage.do"})
    public String forwardViewPage(String id, ModelMap map) {
        map.put((Object)"id", (Object)id);
        return "lsbk/car/default/view";
    }

    @RequestMapping(value={"/lsbk/CarControlControler/forwardAddPage.do"})
    public String forwardAddPage(String id, ModelMap map) {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        date = cal.getTime();
        String ToDate = Util.getDate("yyyy-MM-dd", date);
        cal.setTime(date);
        cal.add(2, -1);
        date = cal.getTime();
        String fromDate = Util.getDate("yyyy-MM-dd", date);
        map.put((Object)"fromDate", (Object)fromDate);
        map.put((Object)"toDate", (Object)ToDate);
        return "lsbk/car/default/add";
    }

    @RequestMapping(value={"/lsbk/CarControlControler/save.do"})
    public void save(CarControl bean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        int operateResult = 1;
        try {
            bean.setCreatorid(this.person.getId());
            bean.setSqr(this.person.getName());
            bean.setStatus(0);
            this.carControlService.save(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/lsbk/CarControlControler/update.do"})
    public void update(CarControl bean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        int operateResult = 0;
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.carControlService.update(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            operateResult = 0;
            log.error(e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
    }

    @RequestMapping(value={"/lsbk/CarControlControler/apply.do"})
    public void apply(CarControl bean, HttpServletResponse response, HttpServletRequest request) throws IOException {
        ReturnResult rtnResult = new ReturnResult();
        boolean operateResult = true;
        try {
            bean.setPzr(this.person.getName());
            bean.setPzrid(this.person.getId());
            bean.setStatus(1);
            this.carControlService.update(bean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            operateResult = false;
            log.error(e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }
}

