/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.report.service.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.report.service.OnlineTimeReportService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class OnlineTimeReportServiceImpl
implements OnlineTimeReportService {
    @Autowired
    BaseDao baseDao;

    @Override
    public List<Map<String, Object>> queryOnOffTimeData(String depId, String codeOrName, String startDate, String endDate, String cardType, String orderColumn, String orderType, Page page) {
        String sql = "select r.person_id,p.code,p.name,d.name as depname,r.card_type as cardtype,(select name from t_commoncode where type='40288cd841f3e6220141f3f13bf70010' and code = r.card_type) as cardtypename, SUM(f_onlinetime_cxd(on_time,off_time,?,?))*24*3600 as onlinetime from T_SAFECLIENT_ONOFF_FLOW_RECORD r, t_person p, t_department d where r.person_id = p.id and p.dep_id=d.id and p.dep_id in (select id from t_department connect by prior id=parent_id start with id=?)  and ((r.on_time >= to_date(?,'YYYY-MM-DD HH24MISS') and r.off_time <= to_date(?,'YYYY-MM-DD HH24MISS')) or  (r.on_time <= to_date(?,'YYYY-MM-DD HH24MISS') and r.off_time >= to_date(?,'YYYY-MM-DD HH24MISS')) or  (r.on_time <= to_date(?,'YYYY-MM-DD HH24MISS') and r.off_time >= to_date(?,'YYYY-MM-DD HH24MISS'))  )";
        ArrayList<String> param = new ArrayList<String>();
        param.add(startDate);
        param.add(endDate);
        param.add(depId);
        param.add(startDate + " 000000");
        param.add(endDate + " 235959");
        param.add(startDate + " 000000");
        param.add(startDate + " 000000");
        param.add(endDate + " 235959");
        param.add(endDate + " 235959");
        if (StringUtils.isNotBlank((CharSequence)codeOrName)) {
            sql = sql + " and (p.name like ? or p.code like ? )";
            param.add("%" + codeOrName + "%");
            param.add("%" + codeOrName + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)cardType)) {
            sql = sql + " and r.card_Type = ?";
            param.add(cardType);
        }
        sql = sql + " group by r.person_id, r.card_Type, p.code, p.name,d.name";
        if (StringUtils.isNotBlank((CharSequence)orderColumn) && StringUtils.isNotBlank((CharSequence)orderType)) {
            sql = sql + " order by " + orderColumn + " " + orderType;
        }
        String selectCount = "select count(*) from (" + sql + ")";
        List<Map<String, Object>> list = this.baseDao.getListBySQL(selectCount, sql, param.toArray(), page, Map.class);
        for (Map map : list) {
            BigDecimal onlineTime = (BigDecimal)map.get("ONLINETIME");
            String onlineTimeStr = "";
            if (onlineTime.doubleValue() < 60.0) {
                onlineTimeStr = onlineTime.intValue() + "\u79d2";
            } else if (onlineTime.doubleValue() < 3600.0) {
                onlineTimeStr = onlineTime.longValue() / 60L + "\u5206" + onlineTime.longValue() % 60L + "\u79d2";
            } else if (onlineTime.doubleValue() > 3600.0) {
                onlineTimeStr = onlineTime.longValue() / 3600L + "\u5c0f\u65f6" + onlineTime.longValue() % 3600L / 60L + "\u5206" + onlineTime.longValue() % 3600L % 60L + "\u79d2";
            }
            map.put("ONLINETIME", onlineTimeStr);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryOnOffTimeDetailData(String personId, String startDate, String endDate, String cardType, Page page) {
        String sql = "select to_char(on_time,'YYYY-MM-DD HH24:MI') as ontime,to_char(off_time,'YYYY-MM-DD HH24:MI') as offtime, to_char((off_time-on_time)*24,'FM9999990.0')||'h' as onlinetimeH, f_onlinetime_cxd(on_time,off_time,?,?)*24*3600 as onlinetime from T_SAFECLIENT_ONOFF_FLOW_RECORD r where person_id = ? and card_type=? and ((r.on_time >= to_date(?,'YYYY-MM-DD HH24MISS') and r.off_time <= to_date(?,'YYYY-MM-DD HH24MISS')) or  (r.on_time <= to_date(?,'YYYY-MM-DD HH24MISS') and r.off_time >= to_date(?,'YYYY-MM-DD HH24MISS')) or  (r.on_time <= to_date(?,'YYYY-MM-DD HH24MISS') and r.off_time >= to_date(?,'YYYY-MM-DD HH24MISS'))  )order by on_time desc";
        ArrayList<String> param = new ArrayList<String>();
        param.add(startDate);
        param.add(endDate);
        param.add(personId);
        param.add(cardType);
        param.add(startDate + " 000000");
        param.add(endDate + " 235959");
        param.add(startDate + " 000000");
        param.add(startDate + " 000000");
        param.add(endDate + " 235959");
        param.add(endDate + " 235959");
        String selectCount = "select count(*) from (" + sql + ")";
        List<Map<String, Object>> list = this.baseDao.getListBySQL(selectCount, sql, param.toArray(), page, Map.class);
        for (Map map : list) {
            BigDecimal onlineTime = (BigDecimal)map.get("ONLINETIME");
            String onlineTimeStr = "";
            if (onlineTime.doubleValue() < 60.0) {
                onlineTimeStr = onlineTime.intValue() + "\u79d2";
            } else if (onlineTime.doubleValue() < 3600.0) {
                onlineTimeStr = onlineTime.longValue() / 60L + "\u5206" + onlineTime.longValue() % 60L + "\u79d2";
            } else if (onlineTime.doubleValue() > 3600.0) {
                onlineTimeStr = onlineTime.longValue() / 3600L + "\u5c0f\u65f6" + onlineTime.longValue() % 3600L / 60L + "\u5206" + onlineTime.longValue() % 3600L % 60L + "\u79d2";
            }
            map.put("ONLINETIME", onlineTimeStr);
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryFlowData(String depId, String codeOrName, String startDate, String endDate, String cardType, String orderColumn, String orderType, Page page) {
        String sql = "select r.person_id,p.code,p.name,d.name as depname,r.card_type as cardtype,(select name from t_commoncode where type='40288cd841f3e6220141f3f13bf70010' and code = r.card_type) as cardtypename,to_char(sum(uploaded)/1024/1024,'FM9999990.0')||'MB' as UPLOADEDSUM,to_char(sum(downloaded)/1024/1024,'FM9999990.0') ||'MB' DOWNLOADEDSUM , to_char((sum(uploaded) + sum(downloaded))/1024/1024, 'FM9999990.0')||'MB' as UDSUM  from T_SAFECLIENT_ONOFF_FLOW_RECORD r, t_person p, t_department d where r.person_id = p.id and p.dep_id=d.id and p.dep_id in (select id from t_department connect by prior id=parent_id start with id=?)  and r.off_time >= to_date(?,'YYYY-MM-DD HH24MISS') and r.off_time <= to_date(?,'YYYY-MM-DD HH24MISS') ";
        ArrayList<String> param = new ArrayList<String>();
        param.add(depId);
        param.add(startDate + " 000000");
        param.add(endDate + " 235959");
        if (StringUtils.isNotBlank((CharSequence)codeOrName)) {
            sql = sql + " and (p.name like ? or p.code like ? )";
            param.add("%" + codeOrName + "%");
            param.add("%" + codeOrName + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)cardType)) {
            sql = sql + " and r.card_Type = ?";
            param.add(cardType);
        }
        sql = sql + " group by r.person_id, r.card_Type, p.code, p.name,d.name";
        if (StringUtils.isNotBlank((CharSequence)orderColumn) && StringUtils.isNotBlank((CharSequence)orderType)) {
            sql = sql + " order by " + orderColumn + " " + orderType;
        }
        String selectCount = "select count(*) from (" + sql + ")";
        return this.baseDao.getListBySQL(selectCount, sql, param.toArray(), page, Map.class);
    }
}

