/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.dao.impl;

import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.bean.CertInAirForm;
import com.xdja.pams.scms.dao.CertAirDao;
import com.xdja.pams.scms.entity.CertAir;
import com.xdja.pams.scms.util.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CertAirDaoImpl
implements CertAirDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public void create(CertAir air) {
        if (air != null) {
            this.baseDao.create(air);
        }
    }

    @Override
    public CertAir findNotDelteByCardId(String cardId) {
        String hql = "from CertAir where deleteFlag = '0' and cardId = ?";
        Object object = this.baseDao.getObjectByHQL(hql, new Object[]{cardId});
        return object == null ? null : (CertAir)object;
    }

    @Override
    public List<CertAir> findNotDeletesByCardId(String cardId) {
        String hql = "from CertAir where deleteFlag = '0' and cardId = ?";
        return this.baseDao.getListByHQL(hql, new Object[]{cardId});
    }

    @Override
    public List<CertAir> findByCardId(String cardId) {
        String hql = "from CertAir where cardId = ?";
        return this.baseDao.getListByHQL(hql, new Object[]{cardId});
    }

    @Override
    public CertAir getByCardIdAndSN(String cardId, String sn) {
        String sql = "from CertAir where cardId=? and sn=? and deleteFlag = '0'";
        return (CertAir)this.baseDao.getObjectByHQL(sql, new Object[]{cardId, sn});
    }

    @Override
    public CertAir getBySn(String sn) {
        String sql = "from CertAir where sn = ? and deleteFlag = '0'";
        return (CertAir)this.baseDao.getObjectByHQL(sql, new Object[]{sn});
    }

    @Override
    public void updateCert(CertAir air) {
        this.baseDao.update(air);
    }

    @Override
    public List<CertAir> listCertAir(CertInAirForm form, Page page) {
        StringBuilder s = new StringBuilder();
        s.append("from T_CERT_AIR t, t_person p");
        s.append(" where t.PERSON_ID = p.id and t.DELETE_FLAG = '0'");
        ArrayList<String> values = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)form.getCode())) {
            s.append(" and p.code like ? ");
            values.add("%" + form.getCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)form.getName())) {
            s.append(" and p.name like ?");
            values.add("%" + form.getName() + "%");
        }
        String state = form.getState();
        String ss = "";
        ss = StringUtils.isNotBlank((CharSequence)state) ? ("00".equals(state) ? "10,20,30" : ("01".equals(state) ? "11,21,31" : ("02".equals(state) ? "12,22,32" : "0"))) : "0";
        if ("0".equals(ss)) {
            s.append(" and t.source = '2'");
        }
        if (Strings.isNotEmpty(ss)) {
            s.append(" and t.state in (");
            s.append(ss);
            s.append(") ");
        }
        if (form.getIsContain() != null && form.getIsContain().contains("true")) {
            if (StringUtils.isNotBlank((CharSequence)form.getDepId())) {
                s.append(" and p.dep_Id in (select id from t_department connect by prior id = parent_id start with id = '" + form.getDepId() + "')");
            } else {
                s.append(" and p.dep_id in (" + BimsUtil.getChildDepsSql(form.getControlDeps()) + ")");
            }
        } else if (StringUtils.isNotBlank((CharSequence)form.getDepId())) {
            s.append(" and p.dep_Id = '" + form.getDepId() + "' ");
        } else {
            s.append(" and p.dep_id in (" + BimsUtil.getChildDepsSql(form.getControlDeps()) + ")");
        }
        String selectCount = "select count(1) " + s.toString();
        String sql = "select t.* " + s.toString();
        return this.baseDao.getListBySQL(selectCount, sql, values.toArray(), page, CertAir.class);
    }

    @Override
    public CertAir findById(String id) {
        String sql = "from CertAir where id=? and deleteFlag = '0'";
        return (CertAir)this.baseDao.getObjectByHQL(sql, new Object[]{id});
    }
}

