/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.basecode.util.HelpFunction;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.scms.bean.TerminalPersonBean;
import com.xdja.pams.scms.dao.TerminalPersonDao;
import com.xdja.pams.scms.entity.TerminalPerson;
import com.xdja.pams.scms.service.TerminalPersonService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalPersonServiceImpl
implements TerminalPersonService {
    @Autowired
    private TerminalPersonDao terminalPersonDao;
    @Autowired
    private CommonCodeService commonCodeService;

    @Override
    public List<TerminalPersonBean> getTerminalPerson(TerminalPersonBean terminalPersonBean, Page page) {
        List<TerminalPersonBean> terminalPersonList = this.terminalPersonDao.getTerminalPerson(terminalPersonBean, page);
        ArrayList<TerminalPersonBean> terminalPersonBeanList = new ArrayList<TerminalPersonBean>();
        TerminalPersonBean tpb = null;
        for (TerminalPerson terminalPerson : terminalPersonList) {
            tpb = new TerminalPersonBean();
            BeanUtils.copyProperties((Object)terminalPerson, (Object)tpb);
            CommonCode cardBand = this.commonCodeService.getByCode(tpb.getTerminalBand(), "2021");
            tpb.setTerminalBand_Name(cardBand.getName());
            CommonCode cardOs = this.commonCodeService.getByCode(tpb.getTerminalOs(), "2022");
            tpb.setTerminalOs_Name(cardOs.getName());
            CommonCode cardType = this.commonCodeService.getByCode(tpb.getTerminalType(), "2020");
            tpb.setTerminalType_Name(cardType.getName());
            CommonCode cardGrantType = null;
            if (HelpFunction.isEmpty((String)terminalPerson.getPersonId())) {
                tpb.setGrantType("0");
                cardGrantType = this.commonCodeService.getByCode(tpb.getGrantType(), "ifgrant");
                tpb.setGrantType_Name(cardGrantType.getName());
            } else {
                tpb.setGrantType("1");
                cardGrantType = this.commonCodeService.getByCode(tpb.getGrantType(), "ifgrant");
                tpb.setGrantType_Name(cardGrantType.getName());
            }
            terminalPersonBeanList.add(tpb);
        }
        return terminalPersonBeanList;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public TerminalPerson save(TerminalPersonBean terminalPersonBean) {
        TerminalPerson terminalPerson = new TerminalPerson();
        BeanUtils.copyProperties((Object)terminalPersonBean, (Object)terminalPerson);
        return this.terminalPersonDao.save(terminalPerson);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(TerminalPersonBean terminalPersonBean) {
        TerminalPerson terminalPerson = new TerminalPerson();
        BeanUtils.copyProperties((Object)terminalPersonBean, (Object)terminalPerson);
        this.terminalPersonDao.update(terminalPerson);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(TerminalPersonBean terminalPersonBean) {
        TerminalPerson terminalPerson = new TerminalPerson();
        BeanUtils.copyProperties((Object)terminalPersonBean, (Object)terminalPerson);
        this.terminalPersonDao.delete(terminalPerson);
    }

    @Override
    public List<TerminalPersonBean> getTerminalPass(String type, String code) {
        List<TerminalPersonBean> terminalPersonList = this.terminalPersonDao.getTerminalPass(type, code);
        ArrayList<TerminalPersonBean> terminalBeanList = new ArrayList<TerminalPersonBean>();
        for (TerminalPersonBean terminalPerson : terminalPersonList) {
            terminalBeanList.add(terminalPerson);
        }
        return terminalBeanList;
    }
}

