/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.bean.WriteCardAirApplyBean;
import com.xdja.pams.scms.bean.WriteCardAirForm;
import com.xdja.pams.scms.bean.WriteCardAirRtn;
import com.xdja.pams.scms.dao.WriteCardAirDao;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.PersonJITInfo;
import com.xdja.pams.scms.entity.PersonKOALInfo;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.entity.WriteCardAirApply;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.PersonJITInfoService;
import com.xdja.pams.scms.service.PersonKOALInfoService;
import com.xdja.pams.scms.service.WriteCardAirService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.webservice.client.CommonDClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WriteCardAirServiceImpl
implements WriteCardAirService {
    private static Logger log = LoggerFactory.getLogger(WriteCardAirServiceImpl.class);
    @Autowired
    private WriteCardAirDao writeCardAirDao;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private PersonJITInfoService personJITInfoService;
    @Autowired
    private PersonKOALInfoService personKOALInfoService;
    @Autowired
    private CommonCodePbService commonCodePbService;

    @Override
    @Transactional
    public WriteCardAirRtn apply(WriteCardAirApply apply) {
        WriteCardAirRtn rtn = new WriteCardAirRtn();
        Person person = this.userManageService.getUserByIdentifer(apply.getIdentifier());
        if (person == null) {
            rtn.setFlag("1");
            rtn.setMessage("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728");
            return rtn;
        }
        Device device = this.deviceService.getByCardNO(apply.getCardno());
        if (device != null) {
            rtn.setFlag("1");
            rtn.setMessage("\u8bbe\u5907\u5df2\u5199\u5361");
            return rtn;
        }
        WriteCardAirApply applyRecord = this.writeCardAirDao.getLastApplyByIdenCardNo(apply.getIdentifier(), apply.getCardno());
        if (!(applyRecord == null || "3".equals(applyRecord.getState()) && device == null)) {
            rtn.setFlag("1");
            rtn.setMessage("\u7533\u8bf7\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728,\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7");
            return rtn;
        }
        if (applyRecord == null && (applyRecord = this.writeCardAirDao.getLastApplyByCardNo(apply.getCardno())) != null && !"6".equals(applyRecord.getState())) {
            rtn.setFlag("1");
            rtn.setMessage("\u8bbe\u5907\u5df2\u88ab\u522b\u4eba\u7533\u8bf7,\u4e0d\u80fd\u518d\u6b21\u7533\u8bf7");
            return rtn;
        }
        apply.setPersonId(person.getId());
        apply.setCreateDate(new Date());
        apply.setState("0");
        this.writeCardAirDao.save(apply);
        rtn.setFlag("0");
        rtn.setMessage("\u7533\u8bf7\u6210\u529f");
        return rtn;
    }

    @Override
    public List<WriteCardAirApplyBean> query(WriteCardAirForm form, Page page) {
        List<WriteCardAirApply> queryList = this.writeCardAirDao.queryList(form, page);
        ArrayList<WriteCardAirApplyBean> list = new ArrayList<WriteCardAirApplyBean>();
        for (WriteCardAirApply apply : queryList) {
            WriteCardAirApplyBean bean = this.toBean(apply);
            list.add(bean);
        }
        return list;
    }

    private WriteCardAirApplyBean toBean(WriteCardAirApply apply) {
        WriteCardAirApplyBean bean = new WriteCardAirApplyBean();
        BeanUtils.copyProperties((Object)apply, (Object)bean);
        Person person = this.userManageService.queryPersonById(apply.getPersonId());
        bean.setCode(person.getCode());
        bean.setName(person.getName());
        bean.setDepCode(person.getDepartment().getCode());
        bean.setDepName(person.getDepartment().getName());
        String stateName = this.commonCodePbService.getCodeNameByCode(apply.getState(), "WRITECARD_AIR_STATE");
        bean.setStateName(stateName);
        return bean;
    }

    @Override
    @Transactional
    public void approve(WriteCardAirForm form) {
        WriteCardAirApply apply = this.writeCardAirDao.getById(form.getApplyId());
        apply.setState("1");
        this.writeCardAirDao.update(apply);
    }

    @Override
    public WriteCardAirApply getById(String id) {
        return this.writeCardAirDao.getById(id);
    }

    @Override
    public WriteCardAirApply getLastApplyByIdenCardNo(String identifier, String cardno) {
        return this.writeCardAirDao.getLastApplyByIdenCardNo(identifier, cardno);
    }

    @Override
    public WriteCardAirRtn getApplyState(String identifier, String cardno) {
        WriteCardAirApply apply = this.writeCardAirDao.getLastApplyByIdenCardNo(identifier, cardno);
        WriteCardAirRtn rtn = new WriteCardAirRtn();
        Device device = this.deviceService.getByCardNO(cardno);
        rtn.setFlag("0");
        if (apply == null) {
            rtn.setMessage("\u672a\u627e\u5230\u7533\u8bf7\u8bb0\u5f55");
            rtn.setState("5");
            return rtn;
        }
        if ("0".equals(apply.getState())) {
            rtn.setMessage("\u5f85\u5ba1\u6279");
            rtn.setState("0");
            return rtn;
        }
        if ("1".equals(apply.getState())) {
            rtn.setMessage("\u5df2\u5ba1\u6279");
            rtn.setState("1");
            return rtn;
        }
        if ("2".equals(apply.getState())) {
            rtn.setMessage("\u8bc1\u4e66\u7533\u8bf7\u6210\u529f");
            rtn.setState("2");
            return rtn;
        }
        if ("3".equals(apply.getState()) && device != null) {
            rtn.setMessage("\u5df2\u5199\u5361");
            rtn.setState("3");
            return rtn;
        }
        if ("3".equals(apply.getState()) && device == null) {
            rtn.setMessage("\u8bc1\u4e66\u5df2\u64a4\u9500");
            rtn.setState("6");
            return rtn;
        }
        if ("4".equals(apply.getState())) {
            rtn.setMessage("\u5199\u5361\u5931\u8d25\uff0c\u8bc1\u4e66\u64a4\u9500");
            rtn.setState("4");
            return rtn;
        }
        rtn.setMessage("\u672a\u77e5\u5f02\u5e38");
        rtn.setState("-1");
        return rtn;
    }

    @Override
    @Transactional
    public WriteCardAirRtn getCardCertIssue(String identifier, String cardno) {
        WriteCardAirApply apply = this.writeCardAirDao.getLastApplyByIdenCardNo(identifier, cardno);
        WriteCardAirRtn rtn = new WriteCardAirRtn();
        if (apply == null) {
            rtn.setFlag("1");
            rtn.setMessage("\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return rtn;
        }
        if ("2".equals(apply.getState())) {
            rtn.setState("0");
            rtn.setCert(apply.getCertificate());
            return rtn;
        }
        if (!"1".equals(apply.getState()) && !"4".equals(apply.getState())) {
            rtn.setFlag("1");
            rtn.setMessage("\u7533\u8bf7\u72b6\u6001\u4e3a\u3010" + apply.getState() + "\u3011\uff0c\u4e0d\u80fd\u83b7\u53d6\u8bc1\u4e66");
            return rtn;
        }
        Device device = this.deviceService.getByCardNO(cardno);
        if (device != null) {
            rtn.setFlag("1");
            rtn.setMessage("\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8bbe\u5907\u5df2\u7ecf\u53d1\u8bc1");
            return rtn;
        }
        DInfo d = this.systemConfigService.getDInfoByYYS(null, null);
        Person person = this.userManageService.queryPersonById(apply.getPersonId());
        try {
            String cert = null;
            cert = "1".equals(d.getUseThirdCert()) ? this.gerCertJIT(apply, person, d) : ("2".equals(d.getUseThirdCert()) ? this.getCertKR(apply, person, d) : this.certIssue(person, apply, d));
            rtn.setCert(cert);
            rtn.setFlag("0");
            apply.setState("2");
            apply.setCertificate(cert);
            this.writeCardAirDao.update(apply);
        }
        catch (Exception e) {
            log.error("\u7a7a\u4e2d\u53d1\u8bc1\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            rtn.setFlag("1");
            rtn.setMessage("\u7a7a\u4e2d\u53d1\u8bc1\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rtn;
    }

    @Override
    @Transactional
    public WriteCardAirRtn updateWriteCardState(String identifier, String cardno, String flag) {
        WriteCardAirApply apply = this.writeCardAirDao.getLastApplyByIdenCardNo(identifier, cardno);
        WriteCardAirRtn rtn = new WriteCardAirRtn();
        if (apply == null) {
            rtn.setFlag("1");
            rtn.setMessage("\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return rtn;
        }
        if (!"2".equals(apply.getState())) {
            rtn.setFlag("1");
            rtn.setMessage("\u7533\u8bf7\u72b6\u6001\u4e3a\u3010" + apply.getState() + "\u3011\uff0c\u4e0d\u80fd\u66f4\u65b0\u5199\u5361\u72b6\u6001");
            return rtn;
        }
        DInfo d = this.systemConfigService.getDInfoByYYS(null, null);
        Person person = this.userManageService.queryPersonById(apply.getPersonId());
        if ("0".equals(flag)) {
            Device device = new Device();
            device.setId(apply.getId());
            String algType = "2";
            if ("1.0".equals(apply.getCaAlg())) {
                algType = "1";
            }
            Date now = new Date();
            device.setAlgType(algType);
            device.setApplyDate(apply.getCreateDate());
            device.setCertificate(apply.getCertificate());
            device.setCommType("1");
            device.setLockState("0");
            device.setFlag("1");
            device.setType("4");
            device.setBindingDate(now);
            device.setBindingState("0");
            device.setIccid(apply.getCardno());
            device.setHardNo(apply.getCardno());
            device.setOpenDate(now);
            device.setWriteCardDate(now);
            device.setPersonId(apply.getPersonId());
            device.setUseType("0");
            Terminal terminal = new Terminal();
            terminal.setTerminalband("0");
            terminal.setTerminalname("0");
            terminal.setTerminalos("0");
            terminal.setTerminaltype("0");
            device.setTerminal(terminal);
            device.setName("\u7a7a\u4e2d\u53d1\u8bc1");
            String[] cerArr = apply.getCertificate().split("#");
            device.setSn(DInfo.getSN(cerArr[0]));
            device.setState("3");
            List<Mobile> mobiles = person.getMobiledList();
            device.setMobile(mobiles.get(0));
            this.deviceService.save(device);
            if ("2".equals(d.getUseThirdCert())) {
                PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(apply.getId());
                this.personKOALInfoService.save(pki.getPersonId(), device.getId(), pki.getKoalId(), pki.getNote(), "4");
            }
            apply.setState("3");
            apply.setCertificate("");
            this.writeCardAirDao.update(apply);
            rtn.setFlag("0");
            rtn.setMessage("\u66f4\u65b0\u7a7a\u4e2d\u53d1\u5361\u72b6\u6001\u6210\u529f");
        }
        if ("1".equals(flag)) {
            try {
                if ("1".equals(d.getUseThirdCert())) {
                    this.certRevokeJIT(d, apply);
                } else if ("2".equals(d.getUseThirdCert())) {
                    this.certRevokeKR(d, apply);
                } else {
                    this.certRevoke(d, apply);
                }
                apply.setState("4");
                apply.setCertificate("");
                this.writeCardAirDao.update(apply);
                rtn.setFlag("0");
                rtn.setMessage("\u66f4\u65b0\u7a7a\u4e2d\u53d1\u5361\u72b6\u6001\u6210\u529f");
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u7a7a\u4e2d\u53d1\u5361\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                rtn.setFlag("1");
                rtn.setMessage("\u66f4\u65b0\u7a7a\u4e2d\u53d1\u5361\u72b6\u6001\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return rtn;
    }

    private String certIssue(Person person, WriteCardAirApply apply, DInfo d) {
        String strKey;
        String cardtype = DInfo.covCartType("4");
        String caAlg = apply.getCaAlg();
        String version = "2.0";
        if ("2.0".equals(caAlg)) {
            version = "3.0";
        }
        if ((strKey = CommonDClient.certIssue(d.getUrl(), version, cardtype, apply.getCardno(), apply.getPubkey(), "admin", d.getDevCardNo(), d.getDevPassword())).length() > 10) {
            return strKey;
        }
        throw new RuntimeException("\u83b7\u53d6\u5b89\u5168\u5361\u8bc1\u4e66\u5931\u8d25\uff1a" + DInfo.getCertIssueErr(strKey));
    }

    private String getCertKR(WriteCardAirApply apply, Person p, DInfo d) {
        this.certApplyRAKR(apply, p, d);
        this.reviewRAKR(apply, p, d);
        String cert = null;
        cert = this.certIssueKR(apply);
        return cert;
    }

    private void certApplyRAKR(WriteCardAirApply apply, Person p, DInfo d) {
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(apply.getId());
        if (pki != null && StringUtils.isNotBlank((CharSequence)pki.getKoalId())) {
            return;
        }
        String version = "3.0";
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("USER_IDNO", p.getIdentifier());
        userMap.put("USER_NAME", p.getName());
        userMap.put("USER_CREY", "00");
        String userInfo = Util.toJsonStr(userMap);
        String caAlg = "1.0";
        if ("2".equals(d.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = CommonDClient.certApplyRA30(d.getUrl(), version, userInfo, caAlg, d.getDevCardNo(), d.getDevPassword());
        log.debug("\u683c\u5c14\u6ce8\u518c\u63a5\u53e3\u8fd4\u56de:" + rst);
        String[] rstArr = rst.split("#");
        if (rstArr[0] != null && rstArr.length >= 1 && "userId".equals(rstArr[0])) {
            this.personKOALInfoService.save(p.getId(), apply.getId(), rstArr[1], "", "4");
        } else if (rstArr[0] != null) {
            throw new RuntimeException("\u683c\u5c14\u6ce8\u518c\u7528\u6237\u5931\u8d25\uff1a" + DInfo.getCertApplyRAKR(rstArr[0]));
        }
    }

    private void reviewRAKR(WriteCardAirApply apply, Person p, DInfo d) {
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(apply.getId());
        if (pki != null && "1".equals(pki.getState())) {
            return;
        }
        String version = "3.0";
        String reviewType = "2";
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("", p.getCode());
        String userInfo = Util.toJsonStr(userMap);
        String caAlg = "1.0";
        if ("2".equals(d.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = CommonDClient.reviewRA30(d.getUrl(), version, pki.getKoalId(), reviewType, caAlg, d.getDevCardNo(), d.getDevPassword());
        log.debug("\u683c\u5c14\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de:" + rst);
        if (!"1".equals(rst)) {
            throw new RuntimeException("\u683c\u5c14\u5ba1\u6279\u7528\u6237\u5931\u8d25\uff1a" + DInfo.getReviewRAKR(rst));
        }
        this.personKOALInfoService.updateState(pki.getId());
    }

    private String certIssueKR(WriteCardAirApply apply) {
        String cardtype = "4";
        DInfo d = this.systemConfigService.getDInfoByYYS(null, null);
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(apply.getId());
        String caAlg = apply.getCaAlg();
        String strKey = CommonDClient.certIssueRA30(d.getUrl(), "3.0", cardtype, apply.getCardno(), apply.getPubkey(), caAlg, d.getDevCardNo(), d.getDevPassword(), pki.getKoalId());
        if (strKey.length() > 10) {
            return strKey;
        }
        throw new RuntimeException("\u683c\u5c14\u5ba1\u6279\u7528\u6237\u5931\u8d25\uff1a" + DInfo.getCertIssueErr(strKey));
    }

    private String gerCertJIT(WriteCardAirApply apply, Person p, DInfo d) {
        this.certApplyRAJIT(apply, p, d);
        String cert = null;
        cert = this.certIssueJIT(p, apply, d);
        return cert;
    }

    private void certApplyRAJIT(WriteCardAirApply apply, Person p, DInfo d) {
        PersonJITInfo pki = this.personJITInfoService.findByPersonId(p.getId(), "4");
        String cardType = DInfo.covCartTypeJIT("4");
        if (pki != null) {
            this.personJITInfoService.delete(pki);
            return;
        }
        String version = "3.0";
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("xingming", p.getName());
        userMap.put("xingbie", p.getSex());
        userMap.put("shenfenzhenghao", p.getIdentifier());
        userMap.put("jingzhong", p.getPolice());
        userMap.put("renzhi", "0001");
        userMap.put("gongzuogangwei", "0803");
        userMap.put("zhiji", p.getPosition());
        userMap.put("organ_id", "ff8080815b5c0462015b6b034d1b0018");
        String userInfo = Util.toJsonStr(userMap);
        String caAlg = "1.0";
        if ("2".equals(d.getAlgType())) {
            caAlg = "2.0";
        }
        String userInfoId = "";
        if (pki != null && pki.getUserInfoId() != null) {
            userInfoId = pki.getUserInfoId();
        }
        String rst = CommonDClient.certApplyRAJit(d.getUrl(), version, caAlg, cardType, p.getName(), p.getIdentifier(), p.getDepartment().getCode(), userInfo, userInfoId, d.getDevCardNo(), d.getDevPassword());
        log.debug("\u683c\u5c14\u6ce8\u518c\u63a5\u53e3\u8fd4\u56de:" + rst);
        String[] rstArr = rst.split("#");
        if (rstArr[0] != null && rstArr.length >= 2) {
            PersonJITInfo jitInfo = new PersonJITInfo();
            jitInfo.setAuthCode(rstArr[0]);
            jitInfo.setRefCode(rstArr[1]);
            jitInfo.setPersonId(p.getId());
            jitInfo.setCreateDate(new Date());
            this.personJITInfoService.save(jitInfo);
        } else if (rstArr[0] != null) {
            throw new RuntimeException("\u5409\u5927\u6ce8\u518c\u7528\u6237\u5931\u8d25\uff1a" + DInfo.getErrCertApplyRA(rstArr[0]));
        }
    }

    private String certIssueJIT(Person person, WriteCardAirApply apply, DInfo d) {
        String cardtype = DInfo.covCartTypeJIT("4");
        String caAlg = apply.getCaAlg();
        PersonJITInfo pki = this.personJITInfoService.findByPersonId(person.getId(), "4");
        String strKey = CommonDClient.certDownlaodRAJit(d.getUrl(), "3.0", cardtype, apply.getCardno(), apply.getPubkey(), caAlg, pki.getAuthCode(), pki.getRefCode(), person.getName(), person.getIdentifier(), person.getDepartment().getCode(), d.getDevCardNo(), d.getDevPassword());
        if (strKey.length() > 10) {
            return strKey;
        }
        throw new RuntimeException("\u5409\u5927\u8bc1\u4e66\u83b7\u53d6\u5931\u8d25\uff1a" + DInfo.certDownlaodRAJitErr(strKey));
    }

    private void certRevoke(DInfo dInfo, WriteCardAirApply apply) {
        String rst;
        String cardType = DInfo.covCartType("4");
        String version = "2.0";
        if ("2.0".equals(apply.getCaAlg())) {
            version = "3.0";
        }
        if (!("1".equals(rst = CommonDClient.certRevoke(dInfo.getUrl(), version, cardType, apply.getCardno(), apply.getCaAlg(), dInfo.getDevCardNo(), dInfo.getDevPassword())) || "4".equals(rst) || "15".equals(rst))) {
            throw new RuntimeException("\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\u5931\u8d25\uff1a" + DInfo.getCertRevoke(rst));
        }
    }

    private void certRevokeKR(DInfo dInfo, WriteCardAirApply apply) {
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(apply.getId());
        String cardType = "4";
        String rst = CommonDClient.certRevokeRA30(dInfo.getUrl(), "3.0", cardType, apply.getCardno(), apply.getCaAlg(), dInfo.getDevCardNo(), dInfo.getDevPassword(), pki.getKoalId(), "admin");
        if (!("1".equals(rst) || "4".equals(rst) || "15".equals(rst))) {
            throw new RuntimeException("\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\u5931\u8d25\uff1a" + DInfo.getCertRevoke(rst));
        }
    }

    private void certRevokeJIT(DInfo dInfo, WriteCardAirApply apply) {
        PersonJITInfo pki = this.personJITInfoService.findByPersonId(apply.getId(), "4");
        String cardType = DInfo.covCartTypeJIT("4");
        String rst = CommonDClient.certRevokeRAJit(dInfo.getUrl(), "3.0", cardType, apply.getCardno(), apply.getCaAlg(), dInfo.getDevCardNo(), dInfo.getDevPassword());
        if (!("1".equals(rst) || "4".equals(rst) || "15".equals(rst))) {
            throw new RuntimeException("\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\u5931\u8d25\uff1a" + DInfo.getCertRevoke(rst));
        }
    }

    @Override
    public WriteCardAirApplyBean getBeanById(String id) {
        return this.toBean(this.getById(id));
    }
}

