/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.Base64Encrypt;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.TerminalLog;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.IssuingDoubleCertInAirService;
import com.xdja.pams.scms.service.TerminalLogService;
import com.xdja.pams.scms.service.TerminalReportService;
import com.xdja.pams.scms.service.WriteOfflineService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.webservice.client.CommonDClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.Date;
import javax.servlet.ServletContext;
import org.bouncycastle.asn1.sm2.SM2ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

@Service
public class WriteOfflineServiceImpl
implements WriteOfflineService {
    @Autowired
    SystemConfigService systemConfigService;
    @Autowired
    DeviceService deviceService;
    @Autowired
    UserManageService userManagerService;
    @Autowired
    private TerminalLogService terminalLogService;
    @Autowired
    private TerminalReportService terminalReportService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private IssuingDoubleCertInAirService issuingDoubleCertInAirService;
    private static Logger log = LoggerFactory.getLogger(WriteOfflineServiceImpl.class);

    @Override
    public ReturnResult writeOffline(String deviceId, String password, String personType) throws Exception {
        Device device = this.deviceService.get((Serializable)((Object)deviceId));
        DInfo dInfo = this.systemConfigService.getDInfoByYYS(device.getCommType(), personType);
        ReturnResult rst = new ReturnResult();
        if (dInfo == null) {
            throw new Exception(MessageManager.getProMessage(this.message, "scms.d.config.error"));
        }
        if (!"new".equals(dInfo.getType())) {
            throw new Exception(MessageManager.getProMessage(this.message, "scms.device.writeoffline.old.d"));
        }
        Person person = this.userManagerService.queryPersonById(device.getPersonId());
        boolean isSM2 = "1".equals(dInfo.getIsSM2());
        KeyPair keypair = null;
        keypair = isSM2 ? this.createKeypairSM2() : this.createKeypair();
        PublicKey pubKey = keypair.getPublic();
        PrivateKey privKey = keypair.getPrivate();
        byte[] pk = pubKey.getEncoded();
        byte[] pk128 = new byte[128];
        int count = 0;
        if (!isSM2) {
            for (int j = pk.length - 133; j < pk.length - 5; ++j) {
                pk128[count] = pk[j];
                ++count;
            }
        }
        String pkb64 = "";
        pkb64 = isSM2 ? new Base64Encrypt().encodeStr(pk) : new Base64Encrypt().encodeStr(pk128);
        String version = "";
        String cardtype = "4";
        String algType = "";
        if (isSM2) {
            version = "3.0";
            algType = "2".equals(dInfo.getAlgType()) ? "2.0" : "1.0";
        } else {
            version = "2.0";
            algType = "admin";
        }
        String isUseEnaas = this.systemConfigService.getValueByCode("enaas_use");
        String sysId = this.systemConfigService.getValueByCode("enaas_sysid");
        String strCert = null;
        strCert = !"2".equals(personType) && "1".equals(isUseEnaas) ? CommonDClient.certIssueRA(dInfo.getUrl(), version, cardtype, person.getCode(), pkb64, algType, dInfo.getDevCardNo(), dInfo.getDevPassword(), device.getEnaasUserId(), sysId) : CommonDClient.certIssue(dInfo.getUrl(), version, cardtype, person.getCode(), pkb64, algType, dInfo.getDevCardNo(), dInfo.getDevPassword());
        if (strCert.length() < 10) {
            throw new Exception(MessageManager.getProMessage(this.message, "scms.device.writeoffline.getcert.fail") + ":" + DInfo.getCertIssueErr(strCert));
        }
        String old_dcert1 = this.b64toString(strCert);
        if (!this.getPFXCert(password, person.getCode(), privKey, old_dcert1)) {
            throw new Exception(MessageManager.getProMessage(this.message, "scms.device.writeoffline.getcert.fail"));
        }
        try {
            device.setHardNo(person.getCode());
            device.setIccid(person.getCode());
            device.setSn(DInfo.getSN(strCert));
            device.setAlgType(dInfo.getAlgType());
            device.setState("3");
            device.setWriteCardDate(new Date());
            device.setOpenDate(new Date());
            device.setCertificate(old_dcert1);
            this.deviceService.update(device);
        }
        catch (Exception e1) {
            log.error("\u79bb\u7ebf\u5199\u5361\u8bc1\u4e66\u751f\u6210\u6210\u529f\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25", (Throwable)e1);
            String rvkrst = CommonDClient.certRevoke(dInfo.getUrl(), version, cardtype, device.getHardNo(), algType, dInfo.getDevCardNo(), dInfo.getDevPassword());
            if ("1".equals(rst)) {
                log.error("\u79bb\u7ebf\u5199\u5361\u8bc1\u4e66\u751f\u6210\u6210\u529f\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25\uff0c\u64a4\u9500\u8bc1\u4e66\u6210\u529f");
            } else {
                log.error("\u79bb\u7ebf\u5199\u5361\u8bc1\u4e66\u751f\u6210\u6210\u529f\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25\uff0c\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\uff1a" + DInfo.getCertRevoke(rvkrst));
            }
            throw new Exception(MessageManager.getProMessage(this.message, "scms.device.writeoffline.error"));
        }
        TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(device, "0");
        this.terminalLogService.save(terminalLog);
        try {
            this.terminalReportService.report(terminalLog);
        }
        catch (Exception e) {
            log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4e0a\u62a5\u5931\u8d25", (Throwable)e);
        }
        rst.setRtnCode("0");
        rst.setRtnMsg(MessageManager.getProMessage(this.message, "scms.device.writeoffline.success"));
        return rst;
    }

    private KeyPair createKeypairSM2() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPair keypair = null;
        SecureRandom sr = new SecureRandom();
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("ECSM2", "BC");
            kpg.initialize(new ECGenParameterSpec(SM2ObjectIdentifiers.sm2256.getId()), sr);
            keypair = kpg.generateKeyPair();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Exception("\u521b\u5efa\u57fa\u4e8eSM2\u7b97\u6cd5\u7684\u516c\u79c1\u94a5\u5bf9\u5931\u8d25");
        }
        return keypair;
    }

    private KeyPair createKeypair() throws Exception {
        KeyPair keypair = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            keypair = kpg.generateKeyPair();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Exception("\u521b\u5efa\u57fa\u4e8eRSA\u7b97\u6cd5\u7684\u516c\u79c1\u94a5\u5bf9\u5931\u8d25");
        }
        return keypair;
    }

    private boolean getPFXCert(String pfxPW, String code, PrivateKey privKey, String old_dcert1) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        char[] psw = pfxPW.toCharArray();
        Certificate[] chain = new Certificate[1];
        try {
            byte[] x509cert = new Base64Encrypt().decode(old_dcert1);
            ByteArrayInputStream is = new ByteArrayInputStream(x509cert);
            CertificateFactory oCf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)oCf.generateCertificate(is);
            chain[0] = cert;
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            store.load(null, null);
            store.setKeyEntry("firefighter", privKey, psw, chain);
            WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
            ServletContext servletContext = applicationContext.getServletContext();
            String path = servletContext.getRealPath("/") + "certuser" + File.separator + code + ".pfx";
            log.info("\u8bc1\u4e66\u8def\u5f84:" + path);
            try {
                FileOutputStream outStream = new FileOutputStream(path);
                store.store(outStream, psw);
                ((OutputStream)outStream).close();
                return true;
            }
            catch (Exception e) {
                log.error("\u8f93\u51fapfx\u8bc1\u4e66\u51fa\u9519", (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private String getSN(String cert) {
        String sn = "";
        try {
            CertificateFactory certificate_factory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream stream = new ByteArrayInputStream(cert.getBytes());
            X509Certificate x509certificate = (X509Certificate)certificate_factory.generateCertificate(stream);
            sn = x509certificate.getSerialNumber().toString(16);
        }
        catch (CertificateException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchProviderException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        return sn;
    }

    public String b64toString(String b64cert) {
        String certString = "";
        String[] temp = b64cert.split("\n");
        if (temp.length > 2) {
            for (int i = 1; i < temp.length - 1; ++i) {
                certString = certString + temp[i];
            }
        }
        return certString;
    }

    public SystemConfigService getSystemConfigService() {
        return this.systemConfigService;
    }

    public void setSystemConfigService(SystemConfigService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }

    public DeviceService getDeviceService() {
        return this.deviceService;
    }

    public void setDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public UserManageService getUserManagerService() {
        return this.userManagerService;
    }

    public void setUserManagerService(UserManageService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public TerminalLogService getTerminalLogService() {
        return this.terminalLogService;
    }

    public void setTerminalLogService(TerminalLogService terminalLogService) {
        this.terminalLogService = terminalLogService;
    }

    public TerminalReportService getTerminalReportService() {
        return this.terminalReportService;
    }

    public void setTerminalReportService(TerminalReportService terminalReportService) {
        this.terminalReportService = terminalReportService;
    }
}

