/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sms.control;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.sms.bean.QueryForm;
import com.xdja.pams.sms.bean.SmsFormBean;
import com.xdja.pams.sms.entity.Sms;
import com.xdja.pams.sms.service.SmsService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class SmsController
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private SystemLogService systemLogService;
    private static final Logger log = LoggerFactory.getLogger(SmsController.class);

    @RequestMapping(value={"sms/smscontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"sms/smscontroller/query.do"})
    public void querySmsList(HttpServletRequest request, HttpServletResponse response, QueryForm form, PageParam pageParam) {
        int operateResult = 1;
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        ArrayList listmap = new ArrayList();
        try {
            List<Sms> list = this.smsService.query(form, page);
            for (Sms sms : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", sms.getId());
                map.put("dxnr", sms.getDxnr());
                map.put("receiver", sms.getSjh());
                map.put("sender", sms.getJh());
                map.put("scsj", sms.getScsj());
                map.put("fsbz", sms.getFsbzStr());
                listmap.add(map);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            operateResult = 0;
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"sms/smscontroller/toSendPage.do"})
    public String toSendPage(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        try {
            String maxcount = this.systemConfigService.getValueByCode("msgpush_selectpersoncount_max");
            map.put((Object)"maxcount", (Object)maxcount);
            map.put((Object)"person", (Object)this.person);
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return "sms/sms/default/smsSend";
    }

    @RequestMapping(value={"sms/smscontroller/sendSms.do"})
    public void sendSms(HttpServletRequest request, HttpServletResponse response, String param) {
        int operateResult = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String str = URLDecoder.decode(param, "utf-8");
            SmsFormBean smsForm = null;
            boolean flag = true;
            try {
                smsForm = Util.readValue(str, SmsFormBean.class);
            }
            catch (Exception e) {
                throw new RuntimeException("\u4fdd\u5355\u683c\u5f0f\u6709\u8bef", e);
            }
            if (smsForm.getMessage() != null && smsForm.getMessage().length() > 0) {
                flag = this.smsService.checkKeyword(smsForm.getMessage());
            }
            if (!flag) {
                map.put("flag", "0");
                map.put("message", "\u77ed\u4fe1\u5185\u5bb9\u5305\u542b\u654f\u611f\u8bcd\u6c47");
            } else {
                this.smsService.saveSmsFormBean(str, this.person);
                map.put("flag", "1");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"sms/smscontroller/checkKeyword.do"})
    public void checkKeyword(String nr, HttpServletResponse response) {
        boolean flag = this.smsService.checkKeyword(nr);
        Util.writeUtf8JSON(response, Boolean.toString(!flag));
    }

    public ResourceBundleMessageSource getMessage() {
        return this.message;
    }

    public void setMessage(ResourceBundleMessageSource message) {
        this.message = message;
    }
}

