/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.strategy.controller;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.strategy.bean.StrategyLogBean;
import com.xdja.pams.strategy.bean.StrategyMainBean;
import com.xdja.pams.strategy.entity.StrategyLog;
import com.xdja.pams.strategy.service.StrategyInfoService;
import com.xdja.pams.strategy.service.StrategyLogService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
@RequestMapping(value={"/strategy/StrategyLogController"})
public class StrategyLogController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(StrategyLogController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private StrategyLogService strategyLogService;
    @Autowired
    private StrategyInfoService strategyInfoService;

    @RequestMapping(value={"/index.do"})
    public String index(HttpServletRequest request, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/queryList.do"})
    public void queryList(HttpServletRequest request, HttpServletResponse response, StrategyLogBean queryBean) {
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(queryBean.getPage()), Integer.parseInt(queryBean.getRows()));
            List<StrategyLog> list = this.strategyLogService.queryList(queryBean, page);
            result.put("total", page.getTotal());
            result.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u62e6\u622a\u8bb0\u5f55\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/clear.do"})
    public void clear(HttpServletResponse response) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyLogService.clearList();
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u6e05\u7a7a\u62e6\u622a\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/delete.do"})
    public void delete(HttpServletResponse response, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyLogService.delete(id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u5220\u9664\u62e6\u622a\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/toAddStrategy.do"})
    public String toAddStrategy(String id, ModelMap map) {
        try {
            StrategyLog entity = this.strategyLogService.queryById(id);
            map.put((Object)"entity", (Object)entity);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b56\u7565\u4fee\u6539\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "strategy/log/default/addStrategy";
    }

    @RequestMapping(value={"/addStrategy.do"})
    public void addStrategy(HttpServletResponse response, StrategyMainBean queryBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            queryBean.setType("1");
            queryBean.setState("1");
            this.strategyInfoService.addNew(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u6dfb\u52a0\u7b56\u7565\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/toAddWhiteList.do"})
    public String toAddWhiteList(String id, String type, ModelMap map) {
        try {
            StrategyLog entity = this.strategyLogService.queryById(id);
            map.put((Object)"type", (Object)type);
            map.put((Object)"entity", (Object)entity);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b56\u7565\u4fee\u6539\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "strategy/log/default/addWhiteList";
    }
}

