/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.strategy.controller;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.strategy.bean.StrategyTerminalBean;
import com.xdja.pams.strategy.entity.StrategyTerminal;
import com.xdja.pams.strategy.service.StrategyTerminalService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
@RequestMapping(value={"/strategy/StrategyTerminalController"})
public class StrategyTerminalController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(StrategyTerminalController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private StrategyTerminalService strategyTerminalService;

    @RequestMapping(value={"/blackIndex.do"})
    public String blackIndex(HttpServletRequest request, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/whiteIndex.do"})
    public String whiteIndex(HttpServletRequest request, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/queryList.do"})
    public void queryList(HttpServletRequest request, HttpServletResponse response, StrategyTerminalBean queryBean) {
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(queryBean.getPage()), Integer.parseInt(queryBean.getRows()));
            List<StrategyTerminal> list = this.strategyTerminalService.queryList(queryBean, page);
            result.put("total", page.getTotal());
            result.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b56\u7565\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/toAdd.do"})
    public String toAdd(String type, ModelMap map) {
        try {
            map.put((Object)"type", (Object)type);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ec8\u7aef\u7b56\u7565\u6dfb\u52a0\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "strategy/terminal/default/add";
    }

    @RequestMapping(value={"/add.do"})
    public void add(HttpServletResponse response, StrategyTerminalBean queryBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            queryBean.setState("1");
            this.strategyTerminalService.add(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u6dfb\u52a0\u7ec8\u7aef\u7b56\u7565\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/toEdit.do"})
    public String toEdit(String id, ModelMap map) {
        try {
            StrategyTerminal bean = this.strategyTerminalService.queryById(id);
            map.put((Object)"bean", (Object)bean);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b56\u7565\u4fee\u6539\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "strategy/terminal/default/edit";
    }

    @RequestMapping(value={"/edit.do"})
    public void edit(HttpServletResponse response, StrategyTerminalBean queryBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyTerminalService.update(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u4fee\u6539\u7ec8\u7aef\u7b56\u7565\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/delete.do"})
    public void delete(HttpServletResponse response, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyTerminalService.remove(id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u5220\u9664\u7ec8\u7aef\u7b56\u7565\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/changeState.do"})
    public void changeStatus(HttpServletResponse response, StrategyTerminalBean queryBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyTerminalService.changeState(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u4fee\u6539\u7ec8\u7aef\u7b56\u7565\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }
}

