/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.strategy.service.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.strategy.bean.StrategyLogBean;
import com.xdja.pams.strategy.dao.StrategyLogDao;
import com.xdja.pams.strategy.entity.StrategyLog;
import com.xdja.pams.strategy.service.StrategyLogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class StrategyLogServiceImpl
implements StrategyLogService {
    @Autowired
    private StrategyLogDao strategyLogDao;
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<StrategyLog> queryList(StrategyLogBean queryBean, Page page) {
        List<StrategyLog> list = this.strategyLogDao.queryList(queryBean, page);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<StrategyLog>();
        }
        return list;
    }

    @Override
    @Transactional
    public void clearList() {
        this.strategyLogDao.clearList();
    }

    @Override
    @Transactional
    public void add(StrategyLog entity) {
        Long currentTime = System.currentTimeMillis();
        StrategyLogBean queryBean = new StrategyLogBean();
        BeanUtils.copyProperties((Object)entity, (Object)queryBean);
        List<StrategyLog> list = this.strategyLogDao.queryList(queryBean, null);
        if (CollectionUtils.isEmpty(list)) {
            entity.setCreateTime(currentTime);
            entity.setLastUpdateTime(currentTime);
            this.baseDao.create(entity);
        } else {
            StrategyLog strategyLog = list.get(0);
            strategyLog.setLastUpdateTime(currentTime);
            this.baseDao.update(strategyLog);
        }
    }

    @Override
    @Transactional
    public void delete(String id) {
        StrategyLog entity = (StrategyLog)this.baseDao.getObjectById(StrategyLog.class, (Serializable)((Object)id));
        if (entity == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        this.baseDao.delete(entity);
    }

    @Override
    public StrategyLog queryById(String id) {
        StrategyLog entity = (StrategyLog)this.baseDao.getObjectById(StrategyLog.class, (Serializable)((Object)id));
        if (entity == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        return entity;
    }
}

