/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.strategy.service.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.strategy.bean.StrategyTerminalBean;
import com.xdja.pams.strategy.dao.StrategyTerminalDao;
import com.xdja.pams.strategy.entity.StrategyTerminal;
import com.xdja.pams.strategy.service.StrategyTerminalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class StrategyTerminalServiceImpl
implements StrategyTerminalService {
    @Autowired
    private StrategyTerminalDao strategyTerminalDao;
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<StrategyTerminal> queryList(StrategyTerminalBean queryBean, Page page) {
        List<StrategyTerminal> list = this.strategyTerminalDao.queryList(queryBean, page);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<StrategyTerminal>();
        }
        return list;
    }

    @Override
    @Transactional
    public void add(StrategyTerminalBean queryBean) {
        Long currentTime = System.currentTimeMillis();
        if (!(StringUtils.hasText((String)queryBean.getTerminalValue()) && StringUtils.hasText((String)queryBean.getTerminalType()) && StringUtils.hasText((String)queryBean.getType()))) {
            throw new RuntimeException("\u7b56\u7565\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        StrategyTerminal entity = new StrategyTerminal();
        BeanUtils.copyProperties((Object)queryBean, (Object)entity);
        entity.setCreateTime(currentTime);
        entity.setLastUpdateTime(currentTime);
        this.baseDao.create(entity);
    }

    @Override
    public StrategyTerminal queryById(String id) {
        StrategyTerminal entity = (StrategyTerminal)this.baseDao.getObjectById(StrategyTerminal.class, (Serializable)((Object)id));
        if (entity == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        return entity;
    }

    @Override
    @Transactional
    public void update(StrategyTerminalBean queryBean) {
        StrategyTerminal entity = (StrategyTerminal)this.baseDao.getObjectById(StrategyTerminal.class, (Serializable)((Object)queryBean.getId()));
        if (entity == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        entity.setLastUpdateTime(System.currentTimeMillis());
        entity.setTerminalType(queryBean.getTerminalType());
        entity.setTerminalValue(queryBean.getTerminalValue());
        this.baseDao.update(entity);
    }

    @Override
    @Transactional
    public void remove(String id) {
        StrategyTerminal entity = (StrategyTerminal)this.baseDao.getObjectById(StrategyTerminal.class, (Serializable)((Object)id));
        if (entity == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        this.baseDao.delete(entity);
    }

    @Override
    @Transactional
    public void changeState(StrategyTerminalBean queryBean) {
        StrategyTerminal entity = (StrategyTerminal)this.baseDao.getObjectById(StrategyTerminal.class, (Serializable)((Object)queryBean.getId()));
        if (entity == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        entity.setState(queryBean.getState());
        this.baseDao.update(entity);
    }
}

