/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.FastDfsUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
public class SysConfigController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(SysConfigController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private FastDfsUtils fastDfsUtils;

    @RequestMapping(value={"syms/sysconfigcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            if ("1".equals(com.xdja.agreement.config.SystemConfig.getInstance().getString("cluster.switch"))) {
                String logoUri = this.systemConfigService.getValueByCode("system_logo_uri");
                if (StringUtils.isNotBlank((CharSequence)logoUri)) {
                    String fastDfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL");
                    map.put((Object)"logoUrl", (Object)(fastDfsUrl + "/" + logoUri));
                } else {
                    map.put((Object)"logoUrl", (Object)(request.getContextPath() + "/css/themes/default/system/images/logo.png"));
                }
            } else {
                map.put((Object)"logoUrl", (Object)(request.getContextPath() + "/css/themes/default/system/images/logo.png"));
            }
            SystemConfig sysCfgTheme = this.systemConfigService.getByCode("systemTheme");
            if (sysCfgTheme != null) {
                map.put((Object)"sysCfgTheme", (Object)sysCfgTheme);
            }
            String theme = this.operator.getPerson().getTheme();
            map.put((Object)"theme", (Object)theme);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"syms/sysconfigcontroller/add.do"})
    public String add() {
        return "syms/sysconfig/default/add";
    }

    @RequestMapping(value={"syms/sysconfigcontroller/addType.do"})
    public String addType() {
        return "syms/sysconfig/default/addType";
    }

    @RequestMapping(value={"syms/sysconfigcontroller/query.do"})
    public void query(HttpServletResponse response, String name) {
        List<SystemConfig> source = this.systemConfigService.getByType(null);
        List<SystemConfig> list = this.needShowConfigs(source);
        try {
            for (SystemConfig pSC : list) {
                List<SystemConfig> list2 = pSC.getcSystemConfig();
                for (int i = 0; i < list2.size(); ++i) {
                    for (int j = i + 1; j < list2.size(); ++j) {
                        if (list2.get(i).getCode().compareTo(list2.get(j).getCode()) <= 0) continue;
                        SystemConfig temp = list2.get(i);
                        list2.set(i, list2.get(j));
                        list2.set(j, temp);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ArrayList listmap = new ArrayList();
        for (SystemConfig pSC : list) {
            String id = "";
            List<SystemConfig> listMatch = null;
            if (!Util.varCheckEmp(name) && pSC.getName() != null) {
                if (pSC.getName().contains(name)) {
                    id = pSC.getId();
                } else {
                    for (SystemConfig cSC : pSC.getcSystemConfig()) {
                        if (!cSC.getName().contains(name)) continue;
                        id = pSC.getId();
                        break;
                    }
                }
                if (!Util.varCheckEmp(id)) {
                    listMatch = this.systemConfigService.getById(id).getcSystemConfig();
                }
            } else {
                listMatch = pSC.getcSystemConfig();
            }
            if (null == listMatch) continue;
            for (SystemConfig cSC : listMatch) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", cSC.getId());
                map.put("name", cSC.getName());
                map.put("code", cSC.getCode());
                if ("pro_tag".equals(cSC.getCode())) {
                    map.put("value", Strings.isEmpty(cSC.getValue()) ? "" : "**********");
                } else {
                    map.put("value", cSC.getValue());
                }
                map.put("note", cSC.getNote());
                map.put("group", pSC.getName());
                HashMap<String, Object> editor = new HashMap<String, Object>();
                editor.put("type", "validatebox");
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("validType", "length[0,128]");
                editor.put("options", options);
                map.put("editor", editor);
                map.put("type", pSC.getId());
                listmap.add(map);
            }
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(listmap.size()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    private List<SystemConfig> needShowConfigs(List<SystemConfig> source) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        ArrayList<SystemConfig> target = new ArrayList<SystemConfig>();
        String needHideCodes = this.systemConfigService.getValueByCode("need_hide_configs_code");
        if (Strings.isEmpty(needHideCodes)) {
            return source;
        }
        String[] codes = needHideCodes.split(",");
        for (SystemConfig s : source) {
            boolean isNeedHide = false;
            for (String c : codes) {
                if (!s.getCode().equals(c)) continue;
                isNeedHide = true;
            }
            if (isNeedHide) continue;
            target.add(s);
        }
        return target;
    }

    @RequestMapping(value={"syms/sysconfigcontroller/getType.do"})
    public void getType(HttpServletResponse response) {
        List<SystemConfig> list = this.systemConfigService.getByType(null);
        ArrayList listmap = new ArrayList();
        for (SystemConfig pSC : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", pSC.getId());
            map.put("name", pSC.getName());
            listmap.add(map);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(listmap));
    }

    @RequestMapping(value={"syms/sysconfigcontroller/update.do"})
    public void update(SystemConfig systemConfig, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)systemConfig.getCode()) || StringUtils.isBlank((CharSequence)systemConfig.getName()) || StringUtils.isBlank((CharSequence)systemConfig.getId())) {
            map.put("flag", "0");
            map.put("message", "\u53c2\u6570\u9519\u8bef");
            log.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        } else {
            operator = this.getOperator(request);
            person = operator.getPerson();
            try {
                SystemConfig oldConfig = this.systemConfigService.getById(systemConfig.getId());
                oldConfig.setCode(systemConfig.getCode());
                oldConfig.setName(systemConfig.getName());
                oldConfig.setNote(systemConfig.getNote());
                String value = systemConfig.getValue();
                if ("pro_tag".equals(systemConfig.getCode())) {
                    value = DInfo.tagSm3(value);
                }
                oldConfig.setValue(value);
                this.systemConfigService.update(oldConfig);
                map.put("flag", "1");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                map.put("flag", "0");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
            }
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/sysconfigcontroller/updateValue.do"})
    public void updateValue(String id, String value, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)id) || StringUtils.isBlank((CharSequence)value)) {
            map.put("flag", "0");
            map.put("message", "\u53c2\u6570\u9519\u8bef");
            log.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        } else {
            operator = this.getOperator(request);
            person = operator.getPerson();
            try {
                this.systemConfigService.update(id, value);
                map.put("flag", "1");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
                operateResult = 1;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                map.put("flag", "0");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
            }
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/sysconfigcontroller/save.do"})
    public void save(SystemConfig systemConfig, HttpServletResponse response, HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        int operateResult = 0;
        if (StringUtils.isBlank((CharSequence)systemConfig.getCode()) || StringUtils.isBlank((CharSequence)systemConfig.getName())) {
            map.put("flag", "0");
            map.put("message", "\u53c2\u6570\u9519\u8bef");
            log.error("\u4fdd\u5b58\u5931\u8d25\uff0c\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        } else {
            SystemConfig sc = this.systemConfigService.getByCode(systemConfig.getCode());
            if (sc != null) {
                map.put("flag", "0");
                map.put("message", MessageManager.getProMessage(this.message, "sysconfig.message.save.codeerr"));
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                return;
            }
            Operator operator = null;
            Person person = null;
            operator = this.getOperator(request);
            person = operator.getPerson();
            try {
                this.systemConfigService.save(systemConfig);
                map.put("flag", "1");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
                Util.writeUtf8JSON(response, Util.toJsonStr(map));
                operateResult = 1;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                map.put("flag", "0");
                map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"syms/sysconfigcontroller/updateLogo.do"})
    public void updateLogo(@RequestParam MultipartFile file, String logoname, HttpServletRequest request, HttpServletResponse response) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        operator = this.getOperator(request);
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String path = request.getRealPath("/");
            if ("0".equals(com.xdja.agreement.config.SystemConfig.getInstance().getString("cluster.switch"))) {
                InputStream is = file.getInputStream();
                BufferedImage image = ImageIO.read(file.getInputStream());
                ImageIO.write((RenderedImage)image, "png", new File(path + "css/themes/default/system/images/logo.png"));
                is.close();
            } else {
                String uri = this.fastDfsUtils.uploadToFASTDFS(file.getBytes(), "logo.png");
                SystemConfig systemLogo = this.systemConfigService.getByCode("system_logo_uri");
                systemLogo.setValue(uri);
                this.systemConfigService.update(systemLogo);
                String fastDfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL");
                map.put("logoUrl", fastDfsUrl + "/" + uri);
            }
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text1(response, Util.toJsonStr(map));
    }

    public SystemConfigService getSystemConfigService() {
        return this.systemConfigService;
    }

    public void setSystemConfigService(SystemConfigService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }
}

