/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.syms.dao.SystemConfigDao;
import com.xdja.pams.syms.entity.SystemConfig;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SystemConfigDaoImpl
implements SystemConfigDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public SystemConfig save(SystemConfig systemConfig) {
        this.baseDao.create(systemConfig);
        return systemConfig;
    }

    @Override
    public void update(SystemConfig systemConfig) {
        this.baseDao.update(systemConfig);
    }

    @Override
    public List<SystemConfig> getByType(String type) {
        if (type != null) {
            String select = "from SystemConfig where type=?";
            Object[] values = new String[]{type};
            return this.baseDao.getListByHQL(select, values);
        }
        return this.baseDao.getListByHQL("from SystemConfig where type is null and code not like '-Dinfo%' ", null);
    }

    @Override
    public SystemConfig getByCode(String code) {
        String select = "from SystemConfig where code=?";
        Object[] values = new String[]{code};
        return (SystemConfig)this.baseDao.getObjectByHQL(select, values);
    }

    @Override
    public SystemConfig getById(String id) {
        return (SystemConfig)this.baseDao.getObjectById(SystemConfig.class, (Serializable)((Object)id));
    }

    @Override
    public List<SystemConfig> queryByCodeLike(String codeLike) {
        String select = "from SystemConfig where code like ?";
        Object[] values = new String[]{codeLike + "%"};
        return this.baseDao.getListByHQL(select, values);
    }
}

