/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syn.control;

import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syn.bean.MenuLimit;
import com.xdja.pams.syn.service.MenuLimitsService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class MenuLimitsControl {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    MenuLimitsService menuLimitsService;
    private static final Logger log = LoggerFactory.getLogger(MenuLimitsControl.class);

    @RequestMapping(value={"sso/menuLimitsControl/getMenuLimits.do"})
    public String getMenuLimits(HttpServletRequest request, HttpServletResponse response, String personId, String type, String flag) {
        MenuLimit menuLimit = new MenuLimit();
        try {
            menuLimit = this.menuLimitsService.getMenuLimits(personId, type, flag);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u7528\u6237\u540d\u83b7\u53d6\u83dc\u5355\u6743\u9650\u5931\u8d25", (Throwable)e);
            menuLimit.getResult().setFlag("1");
            menuLimit.getResult().setMessage(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        String menuLimitJson = Util.toJsonStr(menuLimit);
        Util.writeUtf8Text(response, menuLimitJson);
        return null;
    }
}

