/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.tims.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.tims.bean.QueryFeedBackBean;
import com.xdja.pams.tims.dao.FeedBackDao;
import com.xdja.pams.tims.entity.FeedBack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FeedBackDaoImpl
implements FeedBackDao {
    @Autowired
    private BaseDao baseDao;
    private static final Logger log = LoggerFactory.getLogger(FeedBackDaoImpl.class);

    @Override
    public List<QueryFeedBackBean> query(QueryFeedBackBean queryBean, Page page) {
        StringBuilder select = new StringBuilder("from FeedBack where 1=1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (queryBean != null) {
            if (StringUtils.isNotBlank((CharSequence)queryBean.getJh())) {
                select.append(" and jh like ?");
                list.add("%" + queryBean.getJh() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getDwmc())) {
                select.append(" and dwmc like ?");
                list.add("%" + queryBean.getDwmc() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getMjxm())) {
                select.append(" and mjxm like ?");
                list.add("%" + queryBean.getMjxm() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getTitle())) {
                select.append(" and title like ?");
                list.add("%" + queryBean.getTitle() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getYjlx())) {
                select.append(" and yjlx = ?");
                list.add(queryBean.getYjlx());
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getClbz())) {
                select.append(" and clbz = ?");
                list.add(queryBean.getClbz());
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getGnmk())) {
                select.append(" and gnmk = ?");
                list.add(queryBean.getGnmk());
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getStartDate())) {
                select.append(" and fksj >= ?");
                try {
                    Date startDate = Util.parseDate(queryBean.getStartDate() + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
                    list.add(startDate);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)queryBean.getEndDate())) {
                select.append(" and fksj <= ?");
                try {
                    Date endDate = Util.parseDate(queryBean.getEndDate() + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
                    list.add(endDate);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        select.append("  order by clbz,fksj");
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        log.info(select.toString());
        return this.baseDao.getListByHQL(selectCount, select.toString(), values, page);
    }

    @Override
    public void submitCljg(String id, String cljg) {
    }

    @Override
    public FeedBack getFeedbackDetail(Serializable id) {
        return (FeedBack)this.baseDao.getObjectById(FeedBack.class, id);
    }

    @Override
    @Transactional
    public void update(FeedBack feedback) {
        this.baseDao.update(feedback);
    }
}

