/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.control;

import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.upms.bean.QueryRoleBean;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.SysPowerService;
import com.xdja.pams.upms.service.SysRoleService;
import com.xdja.pams.upms.service.TerminalPowerService;
import com.xdja.pams.upms.service.TerminalRoleService;
import com.xdja.pams.upms.service.UserPowerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class UserPowerController
extends BaseControler {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private TerminalRoleService terminalRoleService;
    @Autowired
    private SysPowerService sysPowerService;
    @Autowired
    private TerminalPowerService terminalPowerService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private UserPowerService userPowerService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private DepManageService depManageService;
    private static final Logger log = LoggerFactory.getLogger(UserPowerController.class);

    @RequestMapping(value={"/upms/userPowerController/listUserPower.do"})
    public String listUserPower(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        return sendUrl;
    }

    @RequestMapping(value={"/upms/userPowerController/updateRolePower.do"})
    public void updateRolePower(String roleid, String type, String personid, HttpServletResponse response) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.userPowerService.updatePersonRoleByPersonid(personid, roleid, type);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/upms/userPowerController/getSysRoleTreeChild.do"})
    public void getSysRoleTreeChild(String personId, HttpServletResponse response, HttpServletRequest request) {
        Role role3;
        String operatorId = this.person.getId();
        QueryRoleBean queryrolebean = new QueryRoleBean();
        queryrolebean.setType("3");
        queryrolebean.setCreator_id(operatorId);
        queryrolebean.setFlag("1");
        List<Role> rolelist = this.sysRoleService.queryRoleList(queryrolebean, null);
        String personSysRoleIds = this.userPowerService.getPersonSysRoles(personId);
        ArrayList treelist = new ArrayList();
        ArrayList treelist1 = new ArrayList();
        for (Role role2 : rolelist) {
            if (role2.getName().equals("\u5355\u4f4d\u7ba1\u7406\u5458") || role2.getName().equals("\u6e38\u5ba2")) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", role2.getId());
            map.put("text", role2.getName());
            map.put("attributes", "havePowerRoles");
            if (role2.getName().equals("\u8d44\u6e90\u63d0\u4f9b\u8005") || role2.getName().equals("\u5f00\u53d1\u8005")) {
                map.put("checked", true);
            }
            if (personSysRoleIds.indexOf(role2.getId()) > -1) {
                map.put("checked", true);
                personSysRoleIds = personSysRoleIds.replace(role2.getId() + ",", "");
            }
            treelist1.add(map);
        }
        if (treelist1.size() > 0) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", "rootId");
            map1.put("text", MessageManager.getProMessage(this.message, "upms.page.info.title.ableSysRoles"));
            map1.put("children", treelist1);
            treelist.add(map1);
        }
        if (personSysRoleIds.length() > 0) {
            ArrayList treelist2 = new ArrayList();
            for (String roleId : personSysRoleIds.split(",")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                role3 = this.sysRoleService.queryRoleById(roleId);
                if (role3.getName().equals("\u5355\u4f4d\u7ba1\u7406\u5458") || role3.getName().equals("\u6e38\u5ba2")) continue;
                map.put("id", role3.getId());
                map.put("text", role3.getName());
                map.put("attributes", "notPowerRoles");
                map.put("checked", true);
                treelist2.add(map);
            }
            if (treelist2.size() > 0) {
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("id", "rootId");
                map2.put("text", MessageManager.getProMessage(this.message, "upms.page.info.title.unAbleSysRoles"));
                map2.put("children", treelist2);
                treelist.add(map2);
            }
        }
        Person person = this.userManageService.queryPersonById(personId);
        HashSet<String> roleSet = new HashSet<String>();
        String personGroupIds = "";
        for (BimsGroup group : person.getGroupList()) {
            personGroupIds = personGroupIds + group.getId();
            for (Role role3 : group.getRoleList()) {
                if (!"3".equals(role3.getType()) && !"1".equals(role3.getType())) continue;
                roleSet.add(role3.getId());
            }
        }
        ArrayList treelist3 = new ArrayList();
        for (String roleId : roleSet) {
            role3 = this.sysRoleService.queryRoleById(roleId);
            String groupNames = "";
            String depName = "";
            for (BimsGroup group : role3.getGroupSet()) {
                if (personGroupIds.indexOf(group.getId()) <= -1) continue;
                groupNames = groupNames + group.getName() + ",";
            }
            if (!"".equals(groupNames)) {
                groupNames = groupNames.substring(0, groupNames.length() - 1);
                groupNames = "(\u5bf9\u5e94\u5206\u7ec4\uff1a" + groupNames + ")";
            }
            if (!"".equals(depName)) {
                depName = depName.substring(0, depName.length() - 1);
                depName = "(\u5bf9\u5e94\u5355\u4f4d\uff1a" + depName + ")";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", role3.getId());
            map.put("text", role3.getName() + groupNames + depName);
            map.put("checked", true);
            map.put("attributes", "groupPowerRoles");
            treelist3.add(map);
        }
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("id", "rootId");
        map3.put("text", MessageManager.getProMessage(this.message, "upms.page.info.title.getSysRolesForGroup"));
        map3.put("children", treelist3);
        if (treelist3.size() > 0) {
            treelist.add(map3);
        }
        String depRoleId = "";
        List<Department> sjdw = this.depManageService.getHLDep(person.getDepartment().getId());
        HashMap<String, String> depNameMap = new HashMap<String, String>();
        roleSet.clear();
        for (Department dep : sjdw) {
            for (Role role4 : dep.getRoleList()) {
                if (!"3".equals(role4.getType()) && !"1".equals(role4.getType())) continue;
                depRoleId = depRoleId + role4.getId() + ",";
                roleSet.add(role4.getId());
                String depName = (String)depNameMap.get(role4.getId());
                if (depName == null) {
                    depName = "";
                }
                depName = depName + dep.getName() + ",";
                depNameMap.put(role4.getId(), depName);
            }
        }
        ArrayList treelist4 = new ArrayList();
        for (String roleId : roleSet) {
            Role role4;
            role4 = this.sysRoleService.queryRoleById(roleId);
            String groupNames = "";
            String depName = "";
            if (depRoleId.indexOf(roleId) >= 0) {
                depName = (String)depNameMap.get(roleId);
            }
            if (!"".equals(depName)) {
                depName = depName.substring(0, depName.length() - 1);
                depName = "(\u5bf9\u5e94\u5355\u4f4d\uff1a" + depName + ")";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", role4.getId());
            map.put("text", role4.getName() + depName);
            map.put("checked", true);
            map.put("attributes", "groupPowerRoles");
            treelist4.add(map);
        }
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        map4.put("id", "rootId");
        map4.put("text", MessageManager.getProMessage(this.message, "upms.page.info.title.getSysRolesForDep"));
        map4.put("children", treelist4);
        if (treelist4.size() > 0) {
            treelist.add(map4);
        }
        String jsonlist = Util.toJsonStr(treelist);
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/upms/userPowerController/getTerminalRoleTreeChild.do"})
    public void getTerminalRoleTreeChild(String personId, HttpServletResponse response, HttpServletRequest request) {
        Role role3;
        String operatorId = this.person.getId();
        QueryRoleBean queryrolebean = new QueryRoleBean();
        queryrolebean.setType("2");
        queryrolebean.setCreator_id(operatorId);
        queryrolebean.setFlag("1");
        List<Role> rolelist = this.terminalRoleService.queryRoleList(queryrolebean, null);
        String personTerminalRoleIds = this.userPowerService.getPersonTerminalRoles(personId);
        ArrayList treelist = new ArrayList();
        ArrayList treelist1 = new ArrayList();
        for (Role role2 : rolelist) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", role2.getId());
            map.put("text", role2.getName());
            map.put("attributes", "havePowerRoles");
            if (personTerminalRoleIds.indexOf(role2.getId()) > -1) {
                map.put("checked", true);
                personTerminalRoleIds = personTerminalRoleIds.replace(role2.getId() + ",", "");
            }
            treelist1.add(map);
        }
        if (treelist1.size() > 0) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", "rootId");
            map1.put("text", MessageManager.getProMessage(this.message, "upms.page.info.title.ableTerminalRoles"));
            map1.put("children", treelist1);
            treelist.add(map1);
        }
        if (personTerminalRoleIds.length() > 0) {
            ArrayList treelist2 = new ArrayList();
            for (String roleId : personTerminalRoleIds.split(",")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                role3 = this.terminalRoleService.queryRoleById(roleId);
                map.put("id", role3.getId());
                map.put("text", role3.getName());
                map.put("attributes", "notPowerRoles");
                map.put("checked", true);
                treelist2.add(map);
            }
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("id", "rootId");
            map2.put("text", MessageManager.getProMessage(this.message, "upms.page.info.title.unAbleTerminalRoles"));
            map2.put("children", treelist2);
            treelist.add(map2);
        }
        Person person = this.userManageService.queryPersonById(personId);
        HashSet<String> roleSet = new HashSet<String>();
        String personGroupIds = "";
        for (BimsGroup group : person.getGroupList()) {
            personGroupIds = personGroupIds + group.getId();
            for (Role role3 : group.getRoleList()) {
                if (!"2".equals(role3.getType())) continue;
                roleSet.add(role3.getId());
            }
        }
        ArrayList treelist3 = new ArrayList();
        for (String roleId : roleSet) {
            role3 = this.terminalRoleService.queryRoleById(roleId);
            String groupNames = "";
            for (BimsGroup group : role3.getGroupSet()) {
                if (personGroupIds.indexOf(group.getId()) <= -1) continue;
                groupNames = groupNames + group.getName() + ",";
            }
            if (!"".equals(groupNames)) {
                groupNames = groupNames.substring(0, groupNames.length() - 1);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", role3.getId());
            map.put("text", role3.getName() + "(\u5bf9\u5e94\u5206\u7ec4\uff1a" + groupNames + ")");
            map.put("checked", true);
            map.put("attributes", "groupPowerRoles");
            treelist3.add(map);
        }
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("id", "rootId");
        map3.put("text", MessageManager.getProMessage(this.message, "upms.page.info.title.getTerminalRolesForGroup"));
        map3.put("children", treelist3);
        if (treelist3.size() > 0) {
            treelist.add(map3);
        }
        String depRoleId = "";
        List<Department> sjdw = this.depManageService.getHLDep(person.getDepartment().getId());
        HashMap<String, String> depNameMap = new HashMap<String, String>();
        roleSet.clear();
        for (Department dep : sjdw) {
            for (Role role4 : dep.getRoleList()) {
                if (!"2".equals(role4.getType())) continue;
                depRoleId = depRoleId + role4.getId() + ",";
                roleSet.add(role4.getId());
                String depName = (String)depNameMap.get(role4.getId());
                if (depName == null) {
                    depName = "";
                }
                depName = depName + dep.getName() + ",";
                depNameMap.put(role4.getId(), depName);
            }
        }
        ArrayList treelist4 = new ArrayList();
        for (String roleId : roleSet) {
            Role role4;
            role4 = this.sysRoleService.queryRoleById(roleId);
            String groupNames = "";
            String depName = "";
            if (depRoleId.indexOf(roleId) >= 0) {
                depName = (String)depNameMap.get(roleId);
            }
            if (!"".equals(depName)) {
                depName = depName.substring(0, depName.length() - 1);
                depName = "(\u5bf9\u5e94\u5355\u4f4d\uff1a" + depName + ")";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", role4.getId());
            map.put("text", role4.getName() + depName);
            map.put("checked", true);
            map.put("attributes", "groupPowerRoles");
            treelist4.add(map);
        }
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        map4.put("id", "rootId");
        map4.put("text", MessageManager.getProMessage(this.message, "upms.page.info.title.getSysRolesForDep"));
        map4.put("children", treelist4);
        if (treelist4.size() > 0) {
            treelist.add(map4);
        }
        String jsonlist = Util.toJsonStr(treelist);
        Util.writeUtf8Text(response, jsonlist);
    }

    @RequestMapping(value={"/upms/userPowerController/queryUseList.do"})
    public void queryUseList(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean queryPersonBean) {
        int operateResult = 1;
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(queryPersonBean.getPage()), Integer.parseInt(queryPersonBean.getRows()));
            List<QueryPersonBean> list = this.userManageService.queryPersonList2(queryPersonBean, this.getControlDeps(request), this.getControlPolices(request), page);
            result.put("total", page.getTotal());
            result.put("rows", list);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }
}

