/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.session;

import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.BeanUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;

public final class SingleSignOutHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private String artifactParameterName = "ticket";
    private String logoutParameterName = "logoutRequest";

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.sessionMappingStorage = storage;
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public void setArtifactParameterName(String name) {
        this.artifactParameterName = name;
    }

    public void setLogoutParameterName(String name) {
        this.logoutParameterName = name;
    }

    public void init() {
        CommonUtils.assertNotNull((Object)this.artifactParameterName, (String)"artifactParameterName cannot be null.");
        CommonUtils.assertNotNull((Object)this.logoutParameterName, (String)"logoutParameterName cannot be null.");
        CommonUtils.assertNotNull((Object)this.sessionMappingStorage, (String)"sessionMappingStorage cannote be null.");
    }

    public boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.artifactParameterName));
    }

    public boolean isLogoutRequest(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && !this.isMultipartRequest(request) && CommonUtils.isNotBlank((String)CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName));
    }

    public void recordSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String token = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.artifactParameterName);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Recording session for token " + token));
        }
        try {
            this.sessionMappingStorage.removeBySessionById(session.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sessionMappingStorage.addSessionById(token, session);
    }

    public void destroySession(HttpServletRequest request) {
        String token;
        String logoutMessage = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.logoutParameterName);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Logout request:\n" + logoutMessage));
        }
        if (CommonUtils.isNotBlank((String)(token = XmlUtils.getTextForElement((String)logoutMessage, (String)"SessionIndex")))) {
            HttpSession session = this.sessionMappingStorage.removeSessionByMappingId(token);
            if (session != null) {
                String sessionID = session.getId();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Invalidating session [" + sessionID + "] for token [" + token + "]"));
                }
                try {
                    session.invalidate();
                }
                catch (IllegalStateException e) {
                    this.log.debug((Object)"Error invalidating session.", (Throwable)e);
                }
            }
            TokenFactory tokenFactory = (TokenFactory)BeanUtils.getBean(TokenFactory.class);
            tokenFactory.getOperator().invalidate("cas:assertion:" + token);
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart");
    }
}

