/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.CookieUtils;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;

public abstract class AbstractTicketValidationFilter
extends AbstractCasFilter {
    private TicketValidator ticketValidator;
    private boolean redirectAfterValidation = false;
    private boolean exceptionOnValidationFailure = true;
    private boolean useSession = true;

    protected TicketValidator getTicketValidator(FilterConfig filterConfig) {
        return this.ticketValidator;
    }

    protected HostnameVerifier getHostnameVerifier(FilterConfig filterConfig) {
        String className = this.getPropertyFromInitParams(filterConfig, "hostnameVerifier", null);
        this.log.trace((Object)("Using hostnameVerifier parameter: " + className));
        String config = this.getPropertyFromInitParams(filterConfig, "hostnameVerifierConfig", null);
        this.log.trace((Object)("Using hostnameVerifierConfig parameter: " + config));
        return className != null ? (config != null ? (HostnameVerifier)ReflectUtils.newInstance((String)className, (Object[])new Object[]{config}) : (HostnameVerifier)ReflectUtils.newInstance((String)className, (Object[])new Object[0])) : null;
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        this.setExceptionOnValidationFailure(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "exceptionOnValidationFailure", "true")));
        this.log.trace((Object)("Setting exceptionOnValidationFailure parameter: " + this.exceptionOnValidationFailure));
        this.setRedirectAfterValidation(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "redirectAfterValidation", "true")));
        this.log.trace((Object)("Setting redirectAfterValidation parameter: " + this.redirectAfterValidation));
        this.setUseSession(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "useSession", "true")));
        this.log.trace((Object)("Setting useSession parameter: " + this.useSession));
        this.setTicketValidator(this.getTicketValidator(filterConfig));
        super.initInternal(filterConfig);
    }

    public void init() {
        super.init();
        CommonUtils.assertNotNull((Object)this.ticketValidator, (String)"ticketValidator cannot be null.");
    }

    protected boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        return true;
    }

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
    }

    protected void onFailedValidation(HttpServletRequest request, HttpServletResponse response) {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.preFilter(servletRequest, servletResponse, filterChain)) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String ticket = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.getArtifactParameterName());
            if (CommonUtils.isNotBlank((String)ticket)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Attempting to validate ticket: " + ticket));
                }
                try {
                    Assertion e = this.ticketValidator.validate(ticket, this.constructServiceUrl(request, response));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Successfully authenticated user: " + e.getPrincipal().getName()));
                    }
                    request.setAttribute("_const_cas_assertion_", (Object)e);
                    if ("1".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
                        CookieUtils.addCookie(response, "_const_cas_ticket_", ticket);
                        TokenFactory tokenFactory = (TokenFactory)BeanUtils.getBean(TokenFactory.class);
                        tokenFactory.getOperator().add("cas:assertion:" + ticket, e);
                    }
                    if (this.useSession) {
                        request.getSession().setAttribute("_const_cas_assertion_", (Object)e);
                    }
                    this.onSuccessfulValidation(request, response, e);
                    if (this.redirectAfterValidation) {
                        this.log.debug((Object)"Redirecting after successful ticket validation.");
                        response.sendRedirect(this.constructServiceUrl(request, response));
                        return;
                    }
                }
                catch (TicketValidationException var8) {
                    response.setStatus(403);
                    this.log.warn((Object)var8, (Throwable)var8);
                    this.onFailedValidation(request, response);
                    if (this.exceptionOnValidationFailure) {
                        throw new ServletException((Throwable)var8);
                    }
                    return;
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public final void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public final void setRedirectAfterValidation(boolean redirectAfterValidation) {
        this.redirectAfterValidation = redirectAfterValidation;
    }

    public final void setExceptionOnValidationFailure(boolean exceptionOnValidationFailure) {
        this.exceptionOnValidationFailure = exceptionOnValidationFailure;
    }

    public final void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }
}

