/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.control;

import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.OnlineUserService;
import com.xdja.pams.common.ServiceResultOut;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class OnlineUserControler
extends BaseControler {
    @Autowired
    private OnlineUserService onlineUserService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    private static final Logger log = LoggerFactory.getLogger(OnlineUserControler.class);

    @RequestMapping(value={"/bims/OnlineUserControler/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/bims/OnlineUserControler/queryOnlineUser.do"})
    public void queryOnlineUser(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryPersonBean queryPersonBean) {
        int operateResult = 1;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        try {
            Page page = new Page(Integer.parseInt(queryPersonBean.getPage()), Integer.parseInt(queryPersonBean.getRows()));
            String controlDeps = this.getControlDeps(request);
            String controlPolices = this.getControlPolices(request);
            List<Person> personList = this.onlineUserService.queryOnlineUser(queryPersonBean, controlDeps, controlPolices, page);
            result.put("total", Integer.valueOf(page.getTotal()));
            ArrayList<QueryPersonBean> list = new ArrayList<QueryPersonBean>();
            for (int i = 0; i < personList.size(); ++i) {
                QueryPersonBean personBean = new QueryPersonBean();
                Person person = personList.get(i);
                personBean.setId(person.getId());
                personBean.setCode(person.getCode());
                personBean.setName(person.getName());
                personBean.setDepName(person.getDepartment().getName());
                personBean.setLoginTime(Util.getDate("yyyy-MM-dd HH:mm", person.getClientLoginTime()));
                list.add(personBean);
            }
            result.put("rows", list);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u83b7\u53d6\u5728\u7ebf\u4eba\u5458\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/bims/OnlineUserControler/forceOffline.do"})
    public void forceOffline(HttpServletRequest request, HttpServletResponse response, ModelMap map, String code, String reason) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            ServiceResultOut result = this.onlineUserService.forceOffline(code, reason);
            if ("succ".equals(result.getRtnFlag())) {
                rtnResult.setRtnCode("0");
                rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rtnResult.setRtnCode("1");
                rtnResult.setRtnMsg(result.getRtnMsg());
            }
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }
}

