/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.dao.impl;

import com.xdja.pams.bims.dao.MobileDao;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.common.basedao.BaseDao;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class MobileDaoImpl
implements MobileDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public Mobile queryMobileByHql(String hql, String[] values) {
        return (Mobile)this.baseDao.getObjectByHQL(hql, values);
    }

    @Override
    public List<Mobile> queryMobileListBySql(String sql, String[] values) {
        return this.baseDao.getListBySQL(sql, values, Mobile.class);
    }

    @Override
    public void addMobile(Mobile mobile) {
        this.baseDao.create(mobile);
    }

    @Override
    public void deleteBatch(List<Mobile> mobiles) {
        if (!CollectionUtils.isEmpty(mobiles)) {
            ArrayList<String> ids = new ArrayList<String>();
            for (Mobile mobile : mobiles) {
                ids.add(mobile.getId());
            }
            ArrayList<ArrayList<String>> params = new ArrayList<ArrayList<String>>();
            ArrayList<String> nameKeys = new ArrayList<String>();
            params.add(ids);
            nameKeys.add("ids");
            String sql = "delete from T_BIMS_MOBILE t where t.id in(:ids)";
            this.baseDao.updateBySql(sql, params.toArray(), nameKeys);
        }
    }

    @Override
    public List<Mobile> queryMobileByPersonId(String personId) {
        String hql = "from Mobile where person.id = ?";
        return this.baseDao.getListByHQL(hql, new Object[]{personId});
    }
}

