/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.dao.impl;

import com.xdja.pams.bims.bean.PersonTerminal;
import com.xdja.pams.bims.bean.TreePerson;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.entity.PersonExcel;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class PersonDaoImpl
implements PersonDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public String addPerson(Person person) {
        person.setTimestamp(new Date().getTime());
        return (String)this.baseDao.create(person);
    }

    @Override
    public void deletePerson(Person person) {
        this.baseDao.delete(person);
    }

    @Override
    public void updatePerson(Person person) {
        this.baseDao.update(person);
    }

    @Override
    public Person queryPersonById(String personId) {
        return (Person)this.baseDao.getObjectById(Person.class, (Serializable)((Object)personId));
    }

    @Override
    public List<Person> queryPersonListByHql(String selectCount, String select, Object[] values, Page page) {
        return this.baseDao.getListByHQL(selectCount, select, values, page);
    }

    @Override
    public List<Person> queryPersonListBySql(String selectCount, String select, Object[] values, Page page) {
        return this.baseDao.getListBySQL(selectCount, select, values, page, Person.class);
    }

    @Override
    public Person queryPersonByHql(String strHql, String[] values) {
        return (Person)this.baseDao.getObjectByHQL(strHql, values);
    }

    @Override
    public List<PersonExcel> queryPersonExcelListBySql(String selectCount, String select, Object[] values, Page page) {
        return this.baseDao.getListBySQL(selectCount, select, values, page, PersonExcel.class);
    }

    @Override
    public String addMobile(Mobile mobile) {
        return (String)this.baseDao.create(mobile);
    }

    @Override
    public void deleteMobile(String personId) {
        this.baseDao.updateBySql("delete T_BIMS_MOBILE where  PERSON_ID=?", new String[]{personId});
    }

    @Override
    public void deleteNoPersonMobile() {
        this.baseDao.updateBySql("delete T_BIMS_MOBILE where  PERSON_ID is null", null);
    }

    @Override
    public List<Person> queryPersonListBySql(String select) {
        return this.baseDao.getListBySQL(select, null, Person.class);
    }

    @Override
    public List<Person> queryPersonListBySql(String select, Object[] values) {
        return this.baseDao.getListBySQL(select, values, Person.class);
    }

    @Override
    public Person getUserByIdentifer(String identifier) {
        String selectHql = "from Person as person where person.flag='0' and person.identifier=?";
        String[] values = new String[]{identifier};
        return this.queryPersonByHql(selectHql, values);
    }

    @Override
    public List<TreePerson> queryTreePersonBySql(String sql, Object[] values) {
        return this.baseDao.getListBySQL(sql, values, TreePerson.class);
    }

    @Override
    public List<Person> queryPersonListByIds(List<String> ids) {
        ArrayList<Person> personList = new ArrayList<Person>();
        if (!CollectionUtils.isEmpty(ids)) {
            String select = "select * from t_person where id in (:ids)";
            ArrayList<String> nameKeys = new ArrayList<String>();
            nameKeys.add("ids");
            int count = ids.size() / 500;
            if (ids.size() % 500 > 0) {
                ++count;
            }
            List<String> qids = null;
            for (int i = 1; i <= count; ++i) {
                int startIndex = (i - 1) * 500;
                int endIndex = i == count ? ids.size() : i * 500;
                qids = ids.subList(startIndex, endIndex);
                personList.addAll(this.baseDao.getListBySQL(select, new Object[]{qids}, Person.class, nameKeys));
            }
        }
        return personList;
    }

    @Override
    public List<PersonTerminal> queryPersonImeiList(String personId) {
        String sql = "select * from t_person_terminal where personId=?";
        return this.baseDao.getListBySQL(sql, new String[]{personId}, PersonTerminal.class);
    }

    @Override
    public List<Person> queryAllPersonList(boolean includeDelete) {
        String select = " from Person ";
        if (!includeDelete) {
            select = select + " where flag != 1";
        }
        return this.baseDao.getListByHQL(select, null);
    }

    @Override
    public List<Object[]> queryPersonName(String[] code) {
        SQLQuery query = this.baseDao.getCurrentSession().createSQLQuery("select code, name from T_PERSON where code in (:code)");
        query.setParameterList("code", (Object[])code);
        List objects = query.list();
        return objects;
    }
}

