/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.basecontroler;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.upms.entity.SysPower;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;

public class BaseControler
implements Serializable {
    private UserManageService userManage = (UserManageService)BeanUtils.getBean(UserManageService.class);
    private TokenFactory tokenFactory = (TokenFactory)BeanUtils.getBean(TokenFactory.class);
    public Person person;
    public Operator operator;
    public String menuName;
    public String menuCode;
    public String menuLinkPage;

    public String getRootId(HttpServletRequest request) {
        this.setOperator(request);
        String rootIds = this.operator.getControlDeps();
        return rootIds.split(",")[0];
    }

    public String getControlDeps(HttpServletRequest request) {
        this.setOperator(request);
        return this.operator.getControlDeps();
    }

    public String getControlPolices(HttpServletRequest request) {
        this.setOperator(request);
        return this.operator.getControlPolices();
    }

    public void setOperator(HttpServletRequest request) {
        String key = CookieUtils.getCookie(request, "operator", String.class);
        this.operator = (Operator)this.tokenFactory.getOperator().get(key);
        if (null != this.operator && null == this.person) {
            this.person = this.userManage.queryPersonById(this.operator.getPerson().getId());
            this.operator.setPerson(this.person);
            this.setControls(this.person, this.operator);
        }
    }

    public void setControls(Person person, Operator operator) {
        StringBuilder controlDeps = new StringBuilder();
        List<Department> controlDepList = person.getControlDepdList();
        if (CollectionUtils.isEmpty(controlDepList)) {
            operator.setControlDeps(person.getDepId());
        } else {
            for (Department department : controlDepList) {
                controlDeps.append(department.getId()).append(",");
            }
            if (StringUtils.isNotBlank((CharSequence)controlDeps.toString())) {
                controlDeps = new StringBuilder(controlDeps.substring(0, controlDeps.length() - 1));
            }
            operator.setControlDeps(controlDeps.toString());
        }
        StringBuilder controlPolices = new StringBuilder();
        List<CommonCode> controlPoliceList = person.getControlPolicedList();
        if (CollectionUtils.isEmpty(controlPoliceList)) {
            operator.setControlPolices("all");
        } else {
            for (CommonCode commonCode : controlPoliceList) {
                controlPolices.append(commonCode.getCode()).append(",");
            }
            if (StringUtils.isNotBlank((CharSequence)controlPolices.toString())) {
                controlPolices = new StringBuilder(controlPolices.substring(0, controlPolices.length() - 1));
            }
            operator.setControlPolices(controlPolices.toString());
        }
    }

    public SysPower getPower(HttpServletRequest request, String menuId, String parentId) {
        return this.operator.getTopMenu().get(parentId).getChildren().get(menuId);
    }

    public void setMenuInfo(HttpServletRequest request, String menuId, String parentId) {
        this.setOperator(request);
        SysPower sysPower = this.getPower(request, menuId, parentId);
        this.menuCode = menuId;
        this.menuName = sysPower.getName();
        this.menuLinkPage = sysPower.getLink_page();
    }

    public Operator getOperator(HttpServletRequest request) {
        if (this.operator == null) {
            this.setOperator(request);
        }
        return this.operator;
    }

    @ModelAttribute
    public void init(HttpServletRequest request, HttpServletResponse response) {
        this.setOperator(request);
    }
}

