/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.service.impl;

import com.xdja.pams.common.service.PnPushService;
import com.xdja.pams.common.util.MD5Util;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.tims.bean.PnRequestBean;
import com.xdja.pams.tims.dao.MsgPushDao;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PnPushServiceImpl
implements PnPushService {
    @Autowired
    private MsgPushDao msgPushDao;
    private static final Logger log = LoggerFactory.getLogger(PnPushServiceImpl.class);

    @Override
    public String push(List<String> personIds, String appId, String bodyJson, String pushReceiveType, String url) throws Exception {
        if (CollectionUtils.isEmpty(personIds)) {
            return "";
        }
        PnRequestBean pr = new PnRequestBean();
        if (StringUtils.isBlank((CharSequence)pushReceiveType)) {
            pushReceiveType = "0";
        }
        String imeiAll = this.toImeis(personIds, pushReceiveType);
        pr.setTo(imeiAll);
        pr.setFrom(appId);
        pr.setTitle("");
        pr.setMessage(bodyJson);
        String rqJson = Util.toJsonStr(pr);
        rqJson = URLEncoder.encode(rqJson, "utf-8");
        HttpRequestUtil httpclient = new HttpRequestUtil();
        log.debug("\u63a8\u9001url:" + url + " \u8bf7\u6c42\u6570\u636e:" + rqJson);
        String rst = httpclient.post(url, rqJson);
        log.debug("\u63a8\u9001\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)rst);
        return rst;
    }

    @Override
    public String push(List<String> personIds, String appId, String isCache, String bodyJson, String pushReceiveType, String url) throws Exception {
        if (CollectionUtils.isEmpty(personIds)) {
            return "";
        }
        PnRequestBean pr = new PnRequestBean();
        if (StringUtils.isBlank((CharSequence)pushReceiveType)) {
            pushReceiveType = "0";
        }
        String imeiAll = this.toImeis(personIds, pushReceiveType);
        pr.setTo(imeiAll);
        pr.setFrom(appId);
        pr.setCache(isCache);
        pr.setTitle("");
        pr.setMessage(bodyJson);
        String rqJson = Util.toJsonStr(pr);
        rqJson = URLEncoder.encode(rqJson, "utf-8");
        HttpRequestUtil httpclient = new HttpRequestUtil();
        log.debug("\u63a8\u9001url:" + url + " \u8bf7\u6c42\u6570\u636e:" + rqJson);
        String rst = httpclient.post(url, rqJson);
        log.debug("\u63a8\u9001\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)rst);
        return rst;
    }

    /*
     * WARNING - void declaration
     */
    private String toImeis(List<String> personIds, String pushReceiveType) {
        void var5_9;
        if (CollectionUtils.isEmpty(personIds)) {
            return "";
        }
        HashSet<String> imeiSet = new HashSet<String>();
        for (String string : personIds) {
            if ("0".equals(pushReceiveType)) {
                List<String> personImeiList = this.msgPushDao.queryToPersonImeiByPersonId(string);
                imeiSet.addAll(personImeiList);
            }
            if (!"1".equals(pushReceiveType)) continue;
            List<String> personIccid = this.msgPushDao.queryToPersonICCIDByPersonId(string);
            imeiSet.addAll(personIccid);
        }
        StringBuffer sb = new StringBuffer();
        for (String imei : imeiSet) {
            if (imei.length() < 15) {
                imei = (imei + "00000").substring(0, 15);
            }
            if ((imei = MD5Util.MD5(imei)) != null) {
                imei = imei.toLowerCase();
            }
            sb.append(imei).append(",");
        }
        String string = sb.toString();
        if (string.length() > 0) {
            String string2 = string.substring(0, string.length() - 1);
        }
        return var5_9;
    }
}

