/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.token.operator;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.common.token.config.TokenConfig;
import com.xdja.pams.common.token.operator.AbstractTokenOperator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisTokenOperator
extends AbstractTokenOperator {
    private RedisTemplate<String, Object> redisTemplate;
    private String prefix = "template:token";

    public RedisTokenOperator(TokenConfig config) {
        super(config);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private String actualKey(String key) {
        return this.prefix + ":" + key;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public String add(Object value) {
        String key = this.config.getKeyGenerator().key();
        String actualKey = this.actualKey(key);
        this.redisTemplate.opsForValue().set((Object)actualKey, value, this.config.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
        return key;
    }

    @Override
    public void add(String key, String value) {
        String actualKey = this.actualKey(key);
        this.redisTemplate.opsForValue().set((Object)actualKey, (Object)value, this.config.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
    }

    @Override
    public String addEx(Object value, long timeout, TimeUnit unit) {
        String key = this.config.getKeyGenerator().key();
        String actualKey = this.actualKey(key);
        this.redisTemplate.opsForValue().set((Object)actualKey, value, timeout, unit);
        return key;
    }

    @Override
    public void addEx(String key, String value, long timeout, TimeUnit unit) {
        String actualKey = this.actualKey(key);
        this.redisTemplate.opsForValue().set((Object)actualKey, (Object)value, timeout, unit);
    }

    @Override
    public Object get(String token) {
        String actualKey = this.actualKey(token);
        if ("1".equals(SystemConfig.getInstance().getString("session.autodelay"))) {
            this.redisTemplate.expire((Object)actualKey, this.config.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
        }
        return this.redisTemplate.opsForValue().get((Object)actualKey);
    }

    @Override
    public List<Object> values() {
        Set set = this.redisTemplate.keys((Object)(this.prefix + "*"));
        return this.redisTemplate.opsForValue().multiGet((Collection)set);
    }

    @Override
    public Map<String, Object> all() {
        Set set = this.redisTemplate.keys((Object)(this.prefix + "*"));
        List list = this.redisTemplate.opsForValue().multiGet((Collection)set);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iterator = set.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            map.put(key, list.get(i));
            ++i;
        }
        return map;
    }

    @Override
    public boolean delay(String token) {
        String actualKey = this.actualKey(token);
        return this.redisTemplate.expire((Object)actualKey, this.config.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
    }

    @Override
    public boolean invalidate(String token) {
        String actualKey = this.actualKey(token);
        this.redisTemplate.delete((Object)actualKey);
        return true;
    }

    @Override
    public void add(String key, Object o) {
        String actualKey = this.actualKey(key);
        this.redisTemplate.opsForValue().set((Object)actualKey, o, this.config.getExpiredTimeInMinutes(), TimeUnit.MINUTES);
    }

    public void add(String key, long value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }
}

