/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import com.alibaba.fastjson.JSON;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieUtils {
    private static final Log log = LogFactory.getLog(CookieUtils.class);

    public static Cookie[] getCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        return cookies;
    }

    public static void showCookie(HttpServletRequest request) {
        Cookie[] c = CookieUtils.getCookies(request);
        for (int i = 0; i < (c == null ? 0 : c.length); ++i) {
            log.debug((Object)("\u4e00\u6761cookie____  name: " + c[i].getName() + "  || value: " + c[i].getValue()));
        }
    }

    public static void saveCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, Object object) {
        CookieUtils.addCookie(response, name, object, null);
    }

    public static void addCookie(HttpServletResponse response, String name, Object object, Integer maxAge) {
        try {
            String v = URLEncoder.encode(JSON.toJSONString((Object)object), "UTF-8");
            String cookieValue = name + "=" + v + ";path=/pams/;HttpOnly";
            if (maxAge != null && maxAge > 0) {
                cookieValue = cookieValue + ";Max-Age=" + maxAge;
            }
            response.addHeader("Set-Cookie", cookieValue);
        }
        catch (Exception e) {
            log.error((Object)(" -------\u6dfb\u52a0cookie \u5931\u8d25\uff01--------" + e.getMessage()));
        }
    }

    public static <T> T getCookie(HttpServletRequest request, String name, Class<T> clazz) {
        try {
            Cookie[] cookies = CookieUtils.getCookies(request);
            String v = null;
            for (int i = 0; i < (cookies == null ? 0 : cookies.length); ++i) {
                if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
                v = URLDecoder.decode(cookies[i].getValue(), "UTF-8");
            }
            if (v != null) {
                return (T)JSON.parseObject(v, clazz);
            }
        }
        catch (Exception e) {
            log.error((Object)("------\u83b7\u53d6 clazz Cookie \u5931\u8d25----- " + e.getMessage()));
        }
        return null;
    }

    public static String getCookie(HttpServletRequest request, String name) {
        try {
            Cookie[] cookies = CookieUtils.getCookies(request);
            for (int i = 0; i < (cookies == null ? 0 : cookies.length); ++i) {
                if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
                return URLDecoder.decode(cookies[i].getValue(), "UTF-8");
            }
        }
        catch (Exception e) {
            log.error((Object)(" --------\u83b7\u53d6String cookie \u5931\u8d25--------   " + e.getMessage()));
        }
        return null;
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        try {
            Cookie[] cookies = CookieUtils.getCookies(request);
            for (int i = 0; i < (cookies == null ? 0 : cookies.length); ++i) {
                if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
                Cookie cookie = new Cookie(name, null);
                cookie.setMaxAge(0);
                cookie.setPath("/pams/");
                CookieUtils.saveCookie(response, cookie);
            }
        }
        catch (Exception e) {
            log.error((Object)(" -------\u5220\u9664cookie\u5931\u8d25\uff01--------" + e.getMessage()));
        }
    }

    public static void delayCookie(HttpServletRequest request, HttpServletResponse response, String name, Integer ttl) {
        try {
            Cookie[] cookies = CookieUtils.getCookies(request);
            for (int i = 0; i < (cookies == null ? 0 : cookies.length); ++i) {
                if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
                Cookie cookie = new Cookie(name, cookies[i].getValue());
                cookie.setMaxAge(ttl.intValue());
                cookie.setPath("/pams/");
                CookieUtils.saveCookie(response, cookie);
            }
        }
        catch (Exception e) {
            log.error((Object)(" -------cookie\u7eed\u671f\u5931\u8d25\uff01--------" + e.getMessage()));
        }
    }
}

