/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import com.xdja.framework.commons.fileserver.FdfsUtil;
import com.xdja.framework.commons.fileserver.bean.TrunkFileInfo;
import com.xdja.framework.commons.fileserver.exception.ErrorMsgException;
import com.xdja.pams.syms.service.SystemConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FastDfsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FastDfsUtils.class);
    @Autowired
    private SystemConfigService systemConfigService;
    private String fastdfsUrl;
    private String userId;
    private String secret;
    private FdfsUtil fdfsUtil;

    public String uploadToFASTDFS(byte[] arr, String picName) throws Exception {
        try {
            this.init();
            TrunkFileInfo trunkFileInfo = this.fdfsUtil.trunkupload(arr, "", picName, 1, (long)arr.length);
            return trunkFileInfo.getFileid();
        }
        catch (ErrorMsgException e) {
            LOGGER.error("\u4e0a\u4f20fastDfss\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            throw new Exception("\u4e0a\u4f20\u56fe\u7247\u5230\u56fe\u7247\u670d\u52a1\u5931\u8d25");
        }
    }

    public byte[] downloadFromFASTDFS(String uri) throws Exception {
        byte[] bytes;
        try {
            this.init();
            bytes = this.fdfsUtil.download(uri, 0);
        }
        catch (Exception e) {
            LOGGER.error("\u4ecefastdfs\u4e0b\u8f7d\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            throw new Exception("\u4ecefastdfs\u4e0b\u8f7d\u5931\u8d25");
        }
        return bytes;
    }

    private void init() throws Exception {
        this.fastdfsUrl = this.systemConfigService.getValueByCode("FAST_DFS_SERVER_URL");
        this.userId = this.systemConfigService.getValueByCode("FAST_DFG_USRID");
        this.secret = this.systemConfigService.getValueByCode("FAST_DFS_SECRET");
        this.fdfsUtil = FdfsUtil.create((String)this.fastdfsUrl, (String)this.userId, (String)this.secret);
    }
}

