/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileAgentUtils {
    public static final String SENDER = "jxsp";
    private static final Logger log = LoggerFactory.getLogger(FileAgentUtils.class);

    public static String getHeader(String fileId, long fileLen, String fileType) {
        return "<?xml version =\"1.0\" encoding =\"UTF-8\"?><Root><Version>20130327</Version><Sender>jxsp</Sender><FileID>" + fileId + "</FileID><FileLength>" + fileLen + "</FileLength><FileType>" + fileType + "</FileType><StartPos>0</StartPos></Root>";
    }

    public static String getDownloadHeader(String fileId) {
        return "<?xml version =\"1.0\" encoding =\"UTF-8\"?><Root><Version>20130327</Version><Receiver>test</Receiver><FileID>" + fileId + "</FileID><FileRange>0-A</FileRange></Root>";
    }

    public void uploadToFileAgent(MultipartFile file, String fileId, String pubUrl) throws IOException {
        InputStream fis = file.getInputStream();
        int size = fis.available();
        InputStreamEntity entity = new InputStreamEntity(fis, (long)size);
        String fileExtension = Files.getFileExtension((String)file.getOriginalFilename());
        this.uploadToFileAgent(fileId, pubUrl, size, (HttpEntity)entity, fileExtension);
    }

    public void uploadToFileAgent(InputStream fis, String fileName, String fileId, String pubUrl) throws IOException {
        int size = fis.available();
        InputStreamEntity entity = new InputStreamEntity(fis, (long)size);
        String fileExtension = Files.getFileExtension((String)fileName);
        this.uploadToFileAgent(fileId, pubUrl, size, (HttpEntity)entity, fileExtension);
    }

    public void uploadToFileAgent(String fileId, String pubUrl, long size, HttpEntity entity, String fileExtension) throws IOException {
        pubUrl = pubUrl + "/FileUpload";
        String header = FileAgentUtils.getHeader(fileId, size, fileExtension);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(pubUrl);
        post.setHeader("xmlData", header);
        post.setEntity(entity);
        HttpResponse response = httpClient.execute((HttpUriRequest)post);
        Header rstHeader = response.getFirstHeader("xmlData");
        String responseXml = null;
        if (rstHeader == null || !StringUtils.isNotBlank((CharSequence)(responseXml = rstHeader.getValue()))) {
            throw new IllegalStateException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1aFileAgent\u54cd\u5e94\u65e0\u7ed3\u679c");
        }
        if (!responseXml.contains("<Code>00</Code>")) {
            throw new IllegalStateException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1aFileAgent\u54cd\u5e94\u5931\u8d25" + responseXml);
        }
    }

    public byte[] downloadFromFileAgent(String fileId, String pubUrl) {
        pubUrl = pubUrl + "/FileBreakDownload";
        try {
            String header = FileAgentUtils.getDownloadHeader(fileId);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost post = new HttpPost(pubUrl);
            post.setHeader("xmlData", header);
            ArrayList param = Lists.newArrayList();
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            InputStream inputStream = response.getEntity().getContent();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = inputStream.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byte[] byteArray = output.toByteArray();
            inputStream.close();
            output.close();
            return byteArray;
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u4e8c\u8fdb\u5236\u6d41\u51fa\u9519" + fileId + ":" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static String generateFileId() {
        String dateTime = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        String uuid = UUID.randomUUID().toString().replaceAll("\\-", "");
        return dateTime + "_" + uuid;
    }
}

