/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import com.xdja.pams.common.util.MD5;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public final class Md5PwdEncoder {
    private static Md5PwdEncoder instance = new Md5PwdEncoder();
    private static MD5 md5 = new MD5();
    private String defaultSalt;

    public static Md5PwdEncoder getInstance() {
        return instance;
    }

    private Md5PwdEncoder() {
    }

    public String encodePassword(String rawPass) {
        return md5.getEncodePass(rawPass);
    }

    public String encodePassword(String rawPass, String salt) {
        byte[] digest;
        String saltedPass = this.mergePasswordAndSalt(rawPass, salt, false);
        MessageDigest messageDigest = this.getMessageDigest();
        try {
            digest = messageDigest.digest(saltedPass.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported!");
        }
        return new String(Hex.encodeHex((byte[])digest));
    }

    public boolean isPasswordValid(String encPass, String rawPass) {
        return this.isPasswordValid(encPass, rawPass, this.defaultSalt);
    }

    public boolean isPasswordValid(String encPass, String rawPass, String salt) {
        if (encPass == null) {
            return false;
        }
        return encPass.equals(this.encodePassword(rawPass, salt));
    }

    protected MessageDigest getMessageDigest() {
        String algorithm = "MD5";
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm [" + algorithm + "]");
        }
    }

    protected String mergePasswordAndSalt(String password, Object salt, boolean strict) {
        if (password == null) {
            password = "";
        }
        if (strict && salt != null && (salt.toString().lastIndexOf("{") != -1 || salt.toString().lastIndexOf("}") != -1)) {
            throw new IllegalArgumentException("Cannot use { or } in salt.toString()");
        }
        if (salt == null || "".equals(salt)) {
            return password;
        }
        return password + "{" + salt.toString() + "}";
    }

    public String getDefaultSalt() {
        return this.defaultSalt;
    }

    public void setSefaultSalt(String defaultSalt) {
        this.defaultSalt = defaultSalt;
    }
}

