/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.getwayapi.service.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.getwayapi.bean.OnlineRecord;
import com.xdja.pams.getwayapi.dao.GetWayDao;
import com.xdja.pams.getwayapi.entity.SafeClientOnOffRecord;
import com.xdja.pams.getwayapi.service.OnlineService;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class OnlineServiceImpl
implements OnlineService,
InitializingBean,
DisposableBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LinkedBlockingQueue<OnlineRecord> onlineRecordQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<OnlineRecord> onlineRecordTimerQueue = new LinkedBlockingQueue();
    @Resource
    private SystemLogService systemLogService;
    @Resource
    private GetWayDao getWayDao;
    private ExecutorService executorService;
    @Resource
    private SystemConfigService systemConfigService;
    @Resource
    private UserManageService userManageService;
    private ConcurrentMap<String, Set<String>> gatewayMap = Maps.newConcurrentMap();

    public void afterPropertiesSet() throws Exception {
        SystemConfig monitorEnable = this.systemConfigService.getByCode("SYSCONF_GATEWAY_ONLINE_ENABLE");
        if (monitorEnable != null && "1".equals(monitorEnable.getValue())) {
            this.executorService = Executors.newFixedThreadPool(2);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    OnlineServiceImpl.this.storeRecordToLogms();
                }
            });
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    OnlineServiceImpl.this.storeRecordForTimer();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allOffline(String gatewayIp) {
        Set snSet = (Set)this.gatewayMap.get(gatewayIp);
        if (snSet != null) {
            String[] deletes = null;
            Set set = snSet;
            synchronized (set) {
                deletes = snSet.toArray(new String[0]);
                snSet.clear();
            }
            if (deletes != null && deletes.length > 0) {
                Date now = new Date();
                for (String string : deletes) {
                }
            }
        }
    }

    @Override
    public void offline(String ip, String sn, String uploaded, String downloaded, String onlineTime, String port, String gatewayUrl) {
        this.onlineRecordQueue.add(new OnlineRecord(ip, sn, uploaded, downloaded, onlineTime, false, port, gatewayUrl));
    }

    @Override
    public void online(String ip, String sn, String onlineTime, String port, String gatewayUrl) {
        this.onlineRecordQueue.add(new OnlineRecord(ip, sn, null, null, onlineTime, true, port, gatewayUrl));
    }

    public void destroy() throws Exception {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
    }

    private void storeRecordToLogms() {
        this.logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u542f\u52a8\u4e0a\u4e0b\u7ebf\u76d1\u542c\u961f\u5217\u5904\u7406");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                OnlineRecord record = this.onlineRecordQueue.take();
                if (record == null) continue;
                String state = record.isOnline() ? "\u4e0a\u7ebf" : "\u4e0b\u7ebf";
                List<Device> devices = this.getWayDao.getBySn(record.getSn());
                Device device = (Device)Iterables.getFirst(devices, null);
                if (device != null) {
                    long otl;
                    SafeClientOnOffRecord scr;
                    Person person = this.userManageService.queryPersonById(device.getPersonId());
                    if (person == null) {
                        this.logger.warn("\u627e\u4e0d\u5230" + state + "\u901a\u77e5sn:" + record.getSn() + ",device:" + device.getId() + "\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f!");
                        continue;
                    }
                    if (record.isOnline()) {
                        scr = this.getWayDao.getSafeClientOnOffRecordOfOnlineLast(person.getId(), record.getSn(), record.getIp(), record.getPort(), record.getGatewayUrl());
                        if (scr != null) continue;
                        scr = new SafeClientOnOffRecord();
                        scr.setPersonId(person.getId());
                        scr.setSn(device.getSn());
                        scr.setOfflineFlag("0");
                        if (record.getOnlineTime() != null) {
                            try {
                                otl = Long.parseLong(record.getOnlineTime());
                                scr.setOnTime(new Date(new Date().getTime() - otl * 1000L));
                            }
                            catch (Exception e) {
                                scr.setOnTime(new Date());
                            }
                        } else {
                            scr.setOnTime(new Date());
                        }
                        scr.setIp(record.getIp());
                        scr.setPort(record.getPort());
                        scr.setCardType(device.getType());
                        scr.setGatewayUrl(record.getGatewayUrl());
                        this.getWayDao.saveSafeClientOnOffRecord(scr);
                        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), record.getIp(), 0, 1, "", record.getSn(), "", "SAFE_CLIENT_ONLINE", "\u5b89\u5168\u5ba2\u6237\u7aef\u4e0a\u7ebf");
                        continue;
                    }
                    scr = this.getWayDao.getSafeClientOnOffRecordOfOnlineLast(person.getId(), record.getSn(), record.getIp(), record.getPort(), record.getGatewayUrl());
                    if (scr == null) {
                        scr = new SafeClientOnOffRecord();
                        scr.setPersonId(person.getId());
                        scr.setSn(device.getSn());
                        if (record.getOnlineTime() != null) {
                            try {
                                otl = Long.parseLong(record.getOnlineTime());
                                scr.setOnTime(new Date(new Date().getTime() - otl * 1000L));
                            }
                            catch (Exception e) {
                                scr.setOnTime(new Date());
                            }
                        } else {
                            scr.setOnTime(new Date());
                        }
                        scr.setCardType(device.getType());
                        scr.setOffTime(new Date());
                        scr.setDownloaded(record.getDownloaded());
                        scr.setUploaded(record.getUploaded());
                        scr.setGatewayUrl(record.getGatewayUrl());
                        scr.setOfflineFlag("1");
                        this.getWayDao.saveSafeClientOnOffRecord(scr);
                    } else {
                        scr.setCardType(device.getType());
                        scr.setOffTime(new Date());
                        scr.setDownloaded(record.getDownloaded());
                        scr.setUploaded(record.getUploaded());
                        scr.setGatewayUrl(record.getGatewayUrl());
                        scr.setOfflineFlag("1");
                        this.getWayDao.updateSafeClientOnOffRecord(scr);
                    }
                    this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), record.getIp(), 5, 1, "", record.getSn(), "", "SAFE_CLIENT_OFFLINE", "\u5b89\u5168\u5ba2\u6237\u7aef\u4e0b\u7ebf");
                    continue;
                }
                this.logger.warn("\u627e\u4e0d\u5230" + state + "\u901a\u77e5sn:" + record.getSn() + "\u5bf9\u5e94\u7684Device\u4fe1\u606f!");
            }
            catch (InterruptedException e2) {
                this.logger.error("store storeRecordToLogms thread be interrupted", (Throwable)e2);
            }
            catch (Exception e) {
                this.logger.error("storeRecordToLogms thread error", (Throwable)e);
            }
        }
        this.logger.info("storeRecordToLogms thread stop ...");
    }

    private void storeRecordForTimer() {
        this.logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u542f\u52a8\u5b9a\u65f6\u540c\u6b65\u4e0b\u7ebf\u4eba\u5458\u961f\u5217\u5904\u7406");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                OnlineRecord record = this.onlineRecordTimerQueue.take();
                if (record == null) continue;
                SafeClientOnOffRecord scr = this.getWayDao.getSafeClientOnOffRecordOfOnlineLast(record.getSn(), record.getIp(), record.getPort(), record.getGatewayUrl());
                if (scr != null) {
                    if (record.getOnlineTime() != null) {
                        try {
                            long otl = Long.parseLong(record.getOnlineTime());
                            scr.setOnTime(new Date(new Date().getTime() - otl * 1000L));
                        }
                        catch (Exception e) {
                            scr.setOnTime(new Date());
                        }
                    } else {
                        scr.setOnTime(new Date());
                    }
                    scr.setUploaded(record.getUploaded());
                    scr.setDownloaded(record.getDownloaded());
                    scr.setOffTime(new Date());
                    this.getWayDao.updateSafeClientOnOffRecord(scr);
                    continue;
                }
                List<Device> devices = this.getWayDao.getBySn(record.getSn());
                Device device = (Device)Iterables.getFirst(devices, null);
                if (device == null) continue;
                Person person = this.userManageService.queryPersonById(device.getPersonId());
                if (person == null) {
                    this.logger.warn("\u627e\u4e0d\u5230\u5df2\u4e0a\u7ebf\u901a\u77e5sn:" + record.getSn() + ",device:" + device.getId() + "\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f!");
                    continue;
                }
                scr = new SafeClientOnOffRecord();
                scr.setPersonId(person.getId());
                scr.setSn(device.getSn());
                scr.setOfflineFlag("0");
                if (record.getOnlineTime() != null) {
                    try {
                        long otl = Long.parseLong(record.getOnlineTime());
                        scr.setOnTime(new Date(new Date().getTime() - otl * 1000L));
                    }
                    catch (Exception e) {
                        scr.setOnTime(new Date());
                    }
                } else {
                    scr.setOnTime(new Date());
                }
                scr.setIp(record.getIp());
                scr.setPort(record.getPort());
                scr.setCardType(device.getType());
                scr.setGatewayUrl(record.getGatewayUrl());
                scr.setUploaded(record.getUploaded());
                scr.setDownloaded(record.getDownloaded());
                scr.setOffTime(new Date());
                this.getWayDao.saveSafeClientOnOffRecord(scr);
                this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), record.getIp(), 0, 1, "", record.getSn(), "", "SAFE_CLIENT_ONLINE", "\u5b89\u5168\u5ba2\u6237\u7aef\u4e0a\u7ebf");
            }
            catch (InterruptedException e2) {
                this.logger.error("store storeRecordForTimer thread be interrupted", (Throwable)e2);
            }
            catch (Exception e) {
                this.logger.error("storeRecordForTimer thread error", (Throwable)e);
            }
        }
        this.logger.info("storeRecordToLogms thread stop ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecurityCardOnline(String sn) {
        boolean result = false;
        Iterator iterator = this.gatewayMap.values().iterator();
        while (iterator.hasNext()) {
            Set one;
            Set set = one = (Set)iterator.next();
            synchronized (set) {
                if (one.contains(sn)) {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    void testInsertRecord(OnlineRecord record) {
        this.onlineRecordQueue.add(record);
    }

    @Override
    public void updateOffLine(List<String> snList, Date reqDate, String gatewayUrl) {
        this.getWayDao.updateOffLine(snList, reqDate, gatewayUrl);
    }

    @Override
    public void onlineFlowTimer(String ip, String sn, String uploaded, String downloaded, String onlineTime, String port, String gatewayUrl) {
        this.onlineRecordTimerQueue.add(new OnlineRecord(ip, sn, uploaded, downloaded, onlineTime, false, port, gatewayUrl));
    }
}

