/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.iam;

import com.alibaba.fastjson.JSON;
import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.bims.dao.MobileDao;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.iam.bean.IdpAuthResult;
import com.xdja.pams.iam.bean.IdpException;
import com.xdja.pams.iam.bean.IdpParam;
import com.xdja.pams.iam.bean.IdpResult;
import com.xdja.pams.iam.helper.ParamCheckHelper;
import com.xdja.pams.iam.manager.SafeCardIdpAuthManager;
import com.xdja.pams.iam.manager.UserPwdIdpAuthManager;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/iam"})
public class IamIdpController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamIdpController.class);
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private MobileDao mobileDao;
    private SystemConfig systemConfig = SystemConfig.getInstance();

    @RequestMapping(value={"/idp/auth.do"})
    public void doIDPAuth(@RequestBody String param, HttpServletResponse response) {
        ParamCheckHelper helper = new ParamCheckHelper(param);
        helper.setSecret(this.systemConfig.getString("iam.idp.secret"));
        helper.checkParam();
        IdpParam idpParam = (IdpParam)JSON.parseObject((String)param, IdpParam.class);
        String mode = idpParam.getAuthMode();
        String[] modes = mode.split(",");
        try {
            IdpAuthResult result = new IdpAuthResult();
            for (String m : modes) {
                if (Util.varCheckEmp(m)) continue;
                if ("1".equals(m.trim())) {
                    SafeCardIdpAuthManager safeCard = new SafeCardIdpAuthManager(idpParam, this.deviceService);
                    safeCard.auth(result);
                }
                if (!"2".equals(m.trim())) continue;
                UserPwdIdpAuthManager userPwd = new UserPwdIdpAuthManager(idpParam, this.userManageService);
                userPwd.auth(result);
            }
            this.checkPersonDevice(result);
            IdpResult success = IdpResult.success(result);
            Util.writeUtf8JSON(response, Util.toJsonStr(success));
        }
        catch (IdpException e) {
            IdpResult.ErrorCode errorCode = e.getErrorCode();
            LOGGER.error(errorCode.getDesc(), (Throwable)e);
            Util.writeUtf8JSON(response, Util.toJsonStr(IdpResult.error(errorCode)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Util.writeUtf8JSON(response, Util.toJsonStr(IdpResult.error(IdpResult.ErrorCode.SERVER_INTERNAL_EXCEPTION)));
        }
    }

    private void checkPersonDevice(IdpAuthResult result) {
        List<Mobile> mobiledList;
        Person person = result.getPerson();
        Device device = result.getDevice();
        if (person == null || device == null) {
            if (person == null && device == null) {
                throw new IdpException(IdpResult.ErrorCode.UNKNOWN_USER);
            }
            if (person == null) {
                person = this.userManageService.getPersonByPersonId(device.getPersonId());
                result.setPerson(person);
            }
        } else if (!person.getId().equals(device.getPersonId())) {
            LOGGER.error("\u5b89\u5168\u5361\u548c\u4eba\u5458\u4e0d\u5339\u914d");
            throw new IdpException(IdpResult.ErrorCode.PERSON_CARD_NOT_MATCH);
        }
        if ((mobiledList = person.getMobiledList()) == null || mobiledList.isEmpty()) {
            mobiledList = this.mobileDao.queryMobileByPersonId(person.getId());
        }
        result.setMobiles(mobiledList);
    }
}

